/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.interfaces.Bebildert;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.BildOhneTitel;
import eu.gronos.beschriftungen.model.Gerichtet;
import eu.gronos.beschriftungen.model.IntervallUnBeschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainer;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.view.RechnerhammerIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ComponentBeschrifter {
    public static int MAX_ZEICHEN_PRO_ZEILE = 40;

    public Component beschrifte(Component das, NameContainer damit) throws IllegalArgumentException {
        if (das == null) {
            throw new IllegalArgumentException("Component darf nicht null sein!");
        }
        das.setName(damit.getId());
        if (damit instanceof Beschriftung) {
            this.deployTitle(das, (Beschriftung)damit);
            this.deployShortDescription(das, (Beschriftung)damit, null);
            this.deployMnemonic(das, (Beschriftung)damit);
            if (damit instanceof LangBeschriftung) {
                this.deployActionCommandKey(das, (LangBeschriftung)damit);
                this.deployImage(das, (LangBeschriftung)damit);
                this.deployAcceleratorKey(das, (LangBeschriftung)damit);
                this.deployLongDescription(das, (LangBeschriftung)damit);
            }
        } else if (damit instanceof UnBeschriftung) {
            this.deployAccessibleName(das, this.createCompleteTitle((UnBeschriftung)damit));
            this.deployShortDescription(das, ((UnBeschriftung)damit).getRef(), (UnBeschriftung)damit);
            if (damit instanceof BildOhneTitel) {
                this.deployImage(das, (Bebildert)((Object)damit));
            }
            if (damit instanceof IntervallUnBeschriftung) {
                this.deployIntervall(das, (IntervallUnBeschriftung)damit);
            }
        }
        if (damit.richter != null) {
            this.deployAlignment(das, damit.richter);
        }
        return das;
    }

    public Component beschrifteVergittert(Component das, NameContainer damit, Container dahin) {
        if (dahin == null) {
            throw new IllegalArgumentException("Container darf nicht null sein!");
        }
        this.beschrifte(das, damit);
        this.add(das, damit, dahin);
        return das;
    }

    public Component beschrifteGemeinsam(JLabel dasLabel, Beschriftung damitLabel, Component das, UnBeschriftung damit, Container dahin) {
        this.beschrifteVergittert(dasLabel, damitLabel, dahin);
        this.beschrifteVergittert(das, damit, dahin);
        dasLabel.setLabelFor(das);
        return das;
    }

    public Component beschrifteGemeinsam(JLabel dasLabel, Component das, UnBeschriftung damit, Container dahin) {
        Beschriftung damitLabel = damit.getRef();
        return this.beschrifteGemeinsam(dasLabel, damitLabel, das, damit, dahin);
    }

    public Component beschrifteGemeinsam(Component das, UnBeschriftung damit, Container dahin) {
        return this.beschrifteGemeinsam(new JLabel(), das, damit, dahin);
    }

    public Component add(Component das, NameContainer damit, Container dahin) {
        if (damit.gitterBeutel != null) {
            dahin.add(das, damit.gitterBeutel.get(0).toGitterBeutel());
        } else {
            dahin.add(das);
        }
        return das;
    }

    public Component add(BeschriebeneAktion das, Container dahin) {
        return this.add(das.toButton(), das.getBeschriftung(), dahin);
    }

    public Component add(BooleanConfigAction das, Container dahin) {
        return this.add(das.toJToggleButton(), das.getBeschriftung(), dahin);
    }

    public Action beschrifte(Action action, LangBeschriftung damit) {
        this.deployTitle(action, damit);
        this.deployShortDescription(action, damit, null);
        this.deployLongDescription(action, damit);
        this.deployActionCommandKey(action, damit);
        this.deployImage(action, damit);
        this.deployMnemonic(action, damit);
        this.deployAcceleratorKey(action, damit);
        return action;
    }

    public Vorsorgend<?> changeTo(Vorsorgend<?> vorsorgend, int index) {
        this.changeTitle(vorsorgend, index);
        this.changeDescription(vorsorgend, index);
        return vorsorgend;
    }

    public Vorsorgend<?> changeTo(Vorsorgend<?> vorsorgend, int index, Object ... args) {
        this.changeTo(vorsorgend, index);
        if (vorsorgend != null && vorsorgend.isFormatted()) {
            Beschriftung beschriftung = (Beschriftung)((Object)vorsorgend);
            String format = String.format(beschriftung.getTitle(), args);
            beschriftung.setTitle(format);
        } else {
            System.out.println("Ist nicht formatted!");
        }
        return vorsorgend;
    }

    public boolean changeTo(Vorsorgend<?> vorsorgend, String title) {
        int index = this.indexOf(vorsorgend.getAlternativeTitles(), title);
        if (index > -1) {
            this.changeTo(vorsorgend, index);
            return true;
        }
        Kostenrechner.getLogger().info(String.format("Beschriftung nicht gefunden: '%s'", title));
        return false;
    }

    public int indexOf(List<String> alternativen, String neu) {
        int index = 0;
        while (index < alternativen.size()) {
            if (this.istGleicherText(alternativen.get(index), neu)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean istGleicherText(String erste, String zweite) {
        return this.deWhiteSpace(erste).toLowerCase().equals(this.deWhiteSpace(zweite).toLowerCase());
    }

    public String brecheZeilen(String string) {
        String[] zeilen;
        StringBuffer gesamt = new StringBuffer();
        StringBuffer zeile = new StringBuffer();
        String[] stringArray = zeilen = string.trim().split("\\s+");
        int n = zeilen.length;
        int n2 = 0;
        while (n2 < n) {
            String wort = stringArray[n2];
            if (zeile.length() + wort.length() > MAX_ZEICHEN_PRO_ZEILE) {
                gesamt.append(zeile);
                gesamt.append("\n");
                zeile = new StringBuffer();
            }
            zeile.append(wort);
            zeile.append(" ");
            ++n2;
        }
        gesamt.append(zeile);
        gesamt.append("\n");
        return gesamt.toString();
    }

    public String deWhiteSpace(String string) {
        return string.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ').replaceAll("\\s", " ").replaceAll("\\s+", " ").trim();
    }

    private void deployTitle(Object das, Beschriftung beschriftung) {
        String title = beschriftung.getTitle();
        if (das instanceof Action) {
            ((Action)das).putValue("Name", title);
        } else if (das instanceof JComponent) {
            if (das instanceof JLabel) {
                ((JLabel)das).setText(title);
            } else if (das instanceof AbstractButton) {
                if (((AbstractButton)das).getAction() != null) {
                    this.deployTitle(((AbstractButton)das).getAction(), beschriftung);
                } else {
                    ((AbstractButton)das).setText(title);
                }
            } else if ((das instanceof JPanel || das instanceof JScrollPane) && ((JComponent)das).getBorder() instanceof TitledBorder) {
                ((TitledBorder)((JComponent)das).getBorder()).setTitle(title);
            }
        } else if (das instanceof Window) {
            if (das instanceof JDialog) {
                ((JDialog)das).setTitle(title);
            } else if (das instanceof JFrame) {
                ((JFrame)das).setTitle(title);
            }
        } else if (das instanceof Component) {
            this.deployAccessibleName((Component)das, title);
        }
    }

    private void deployAccessibleName(Component das, String title) {
        if (das instanceof JScrollPane && ((JScrollPane)das).getVerticalScrollBar() != null && ((JScrollPane)das).getVerticalScrollBar().getAccessibleContext() != null) {
            ((JScrollPane)das).getVerticalScrollBar().getAccessibleContext().setAccessibleName(title);
        } else if (das.getAccessibleContext() != null) {
            das.getAccessibleContext().setAccessibleName(title);
        } else {
            System.err.println("AccessibleContext null bei " + das.getClass().toString());
        }
    }

    private String createCompleteTitle(UnBeschriftung un) {
        String title = un.getRef().getTitle();
        if (title == null || title.trim().isEmpty()) {
            return "";
        }
        title = this.deWhiteSpace(title);
        StringBuilder sb = new StringBuilder(title);
        if (un.getPrefix() != null && !un.getPrefix().isEmpty()) {
            sb.insert(0, String.valueOf(un.getPrefix()) + " ");
        }
        if (un.getSuffix() != null && !un.getSuffix().isEmpty()) {
            sb.append(" " + un.getSuffix());
        }
        return sb.toString();
    }

    private void deployShortDescription(Object das, Beschriftung beschriftung, UnBeschriftung unbeschriftung) {
        String shortDescription = beschriftung.getShortDescription();
        if (Kostenrechner.debug) {
            String id = "(" + beschriftung.getId();
            if (unbeschriftung != null) {
                id = String.valueOf(id) + ":" + unbeschriftung.getId();
            }
            id = String.valueOf(id) + ") ";
            shortDescription = String.valueOf(id) + shortDescription;
        }
        if (shortDescription != null && !shortDescription.isEmpty()) {
            shortDescription = this.deWhiteSpace(shortDescription);
            shortDescription = this.brecheZeilen(shortDescription);
        }
        if (das instanceof Action) {
            ((Action)das).putValue("ShortDescription", shortDescription);
        } else if (das instanceof AbstractButton && ((AbstractButton)das).getAction() != null) {
            this.deployShortDescription(((AbstractButton)das).getAction(), beschriftung, unbeschriftung);
        } else if (das instanceof JComponent) {
            ((JComponent)das).setToolTipText(shortDescription);
        }
        if (das instanceof Component && ((Component)das).getAccessibleContext() != null) {
            ((Component)das).getAccessibleContext().setAccessibleDescription(shortDescription);
        }
    }

    private void deployMnemonic(Object das, Beschriftung beschriftung) {
        if (beschriftung.hasMnemonic()) {
            if (das instanceof Action) {
                ((Action)das).putValue("MnemonicKey", (int)beschriftung.getMnemonic());
            } else if (das instanceof JComponent) {
                if (das instanceof JLabel) {
                    ((JLabel)das).setDisplayedMnemonic(beschriftung.getMnemonic());
                } else if (das instanceof AbstractButton) {
                    if (((AbstractButton)das).getAction() != null) {
                        this.deployMnemonic(((AbstractButton)das).getAction(), beschriftung);
                    } else {
                        ((AbstractButton)das).setMnemonic(beschriftung.getMnemonic());
                    }
                }
            }
        }
    }

    private void deployAlignment(Component das, Gerichtet damit) {
        if (damit.horizontal != null) {
            if (das instanceof JLabel) {
                ((JLabel)das).setHorizontalAlignment(damit.horizontal);
            } else if (das instanceof AbstractButton) {
                ((AbstractButton)das).setHorizontalAlignment(damit.horizontal);
            } else if (das instanceof JTextField) {
                ((JTextField)das).setHorizontalAlignment(damit.horizontal);
            }
        }
        if (damit.vertical != null) {
            if (das instanceof JLabel) {
                ((JLabel)das).setVerticalAlignment(damit.vertical);
            } else if (das instanceof AbstractButton) {
                ((AbstractButton)das).setVerticalAlignment(damit.vertical);
            } else {
                boolean cfr_ignored_0 = das instanceof JTextField;
            }
        }
    }

    private void deployActionCommandKey(Object das, LangBeschriftung beschriftung) {
        if (beschriftung.getActionCommandKey() != null) {
            if (das instanceof Action) {
                ((Action)das).putValue("ActionCommandKey", beschriftung.getActionCommandKey());
            } else if (das instanceof AbstractButton) {
                if (((AbstractButton)das).getAction() != null) {
                    this.deployActionCommandKey(((AbstractButton)das).getAction(), beschriftung);
                } else {
                    ((AbstractButton)das).setActionCommand(beschriftung.getActionCommandKey());
                }
            }
        }
    }

    private void deployLongDescription(Object das, LangBeschriftung damit) {
        if (damit.getLongDescription() != null) {
            if (das instanceof Action) {
                ((Action)das).putValue("LongDescription", damit.getLongDescription());
            } else if (das instanceof AbstractButton && ((AbstractButton)das).getAction() != null) {
                this.deployLongDescription(((AbstractButton)das).getAction(), damit);
            }
        }
    }

    private void deployAcceleratorKey(Object das, LangBeschriftung damit) {
        if (damit.getAcceleratorKey() != null) {
            if (das instanceof Action) {
                ((Action)das).putValue("AcceleratorKey", damit.getAcceleratorKey().toKeyStroke());
            } else if (das instanceof AbstractButton) {
                if (((AbstractButton)das).getAction() != null) {
                    this.deployAcceleratorKey(((AbstractButton)das).getAction(), damit);
                } else if (das instanceof JMenuItem) {
                    ((JMenuItem)das).setAccelerator(damit.getAcceleratorKey().toKeyStroke());
                }
            }
        }
    }

    private void deployImage(Object das, Bebildert damit) {
        if (damit.getImage() != null) {
            ImageIcon ii = RechnerhammerIcons.loadIcon(damit.getImage());
            ii.setDescription(damit.getImage());
            if (das instanceof Action) {
                ((Action)das).putValue("SwingLargeIconKey", ii);
            } else if (das instanceof JLabel) {
                ((JLabel)das).setIcon(RechnerhammerIcons.loadIcon(damit.getImage()));
            } else if (das instanceof AbstractButton) {
                if (((AbstractButton)das).getAction() != null) {
                    this.deployImage(((AbstractButton)das).getAction(), damit);
                } else {
                    ((AbstractButton)das).setIcon(RechnerhammerIcons.loadIcon(damit.getImage()));
                }
            }
        }
    }

    private void deployIntervall(Component das, IntervallUnBeschriftung damit) {
        if (das instanceof JSlider) {
            JSlider slider = (JSlider)das;
            slider.setMinimum(damit.getMinimum());
            slider.setMaximum(damit.getMaximum());
            slider.setMinorTickSpacing(damit.getMinorTick());
            slider.setMajorTickSpacing(damit.getMajorTick());
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
        }
    }

    private void changeTitle(Vorsorgend<?> vorsorgend, int index) {
        if (index > -1 && index < vorsorgend.getAlternativeTitles().size()) {
            ((Beschriftung)((Object)vorsorgend)).setTitle(this.deWhiteSpace(vorsorgend.getAlternativeTitles().get(index)));
        } else {
            Kostenrechner.getLogger().info(String.format("Titel Nr. %d aus Beschriftung %d nicht vorhanden: !%n", index, ((NameContainer)((Object)vorsorgend)).getKey()));
        }
    }

    private void changeDescription(Vorsorgend<?> vorsorgend, int index) {
        if (index > -1 && vorsorgend.getAlternativeDescriptions() != null && index < vorsorgend.getAlternativeDescriptions().size()) {
            ((Beschriftung)((Object)vorsorgend)).setShortDescription(this.deWhiteSpace(vorsorgend.getAlternativeDescriptions().get(index)));
        } else {
            Kostenrechner.getLogger().info(String.format("Kurzbeschreibung Nr. %d aus Beschriftung %d nicht vorhanden!%n", index, ((NameContainer)((Object)vorsorgend)).getKey()));
        }
    }
}

