/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.controller;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.interfaces.ConfigOption;
import eu.gronos.beschriftungen.model.BooleanConfigSchluessel;
import eu.gronos.beschriftungen.model.NameContainer;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.util.BooleanConfigOption;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;

public class BooleanConfigAction
extends BeschriebeneAktion
implements ConfigOption<Boolean> {
    private static final long serialVersionUID = 6129451338244952803L;
    private final BooleanConfigOption option;

    public BooleanConfigAction(SchluesselBeschriftung beschriftung) {
        super(beschriftung);
        this.option = new BooleanConfigOption((BooleanConfigSchluessel)beschriftung.getConfigSchluessel());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof AbstractButton) {
            this.setValueFromButton((AbstractButton)source);
        }
    }

    @Override
    public Boolean getStandardWert() {
        return (Boolean)this.option.getStandardWert();
    }

    @Override
    public String getSchluessel() {
        return this.option.getSchluessel();
    }

    @Override
    public void setValue(Boolean value) {
        this.option.setValue(value);
        this.setValueToButton(value);
    }

    @Override
    public Boolean getValue() {
        Boolean value = (Boolean)this.option.getValue();
        this.setValueToButton(value);
        return value;
    }

    @Override
    public void reset() {
        this.option.reset();
    }

    public JToggleButton toJToggleButton() {
        JToggleButton tb = (JToggleButton)this.toButton(new JToggleButton());
        tb.setName(this.getBeschriftung().getId());
        return tb;
    }

    @Override
    public AbstractButton toButton(AbstractButton button) {
        button.setAction(this);
        this.getValue();
        this.setButtonText();
        return button;
    }

    @Override
    public JMenuItem toMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        return this.toMenuItem(item);
    }

    @Override
    public JMenuItem toMenuItem(JMenuItem item) {
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.beschrifte(item, (NameContainer)this.getBeschriftung());
        item.setAction(this);
        this.getValue();
        this.setButtonText();
        return item;
    }

    @Override
    public SchluesselBeschriftung getBeschriftung() {
        return (SchluesselBeschriftung)super.getBeschriftung();
    }

    protected void setButtonText() {
        int index = this.valueToIndex();
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.changeTo(this.getBeschriftung(), index);
        beschrifter.beschrifte(this, this.getBeschriftung());
    }

    private int valueToIndex() {
        return this.getValue() != false ? 1 : 0;
    }

    private void setValueFromButton(AbstractButton button) {
        boolean value = button.isSelected();
        this.option.inRegistrySchreiben(value);
        this.setButtonText();
    }

    private void setValueToButton(boolean value) {
        this.putValue("SwingSelectedKey", value);
    }
}

