/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.util;

import eu.gronos.beschriftungen.interfaces.ConfigOption;
import eu.gronos.beschriftungen.model.ConfigSchluessel;
import eu.gronos.kostenrechner.Kostenrechner;
import java.util.prefs.Preferences;

public abstract class PreferencesConfigOption<E>
implements ConfigOption<E> {
    public static final String NODE = "/eu/gronos/kostentenor";
    private static final Preferences userPrefs = Preferences.userRoot().node("/eu/gronos/kostentenor");
    private final String schluessel;
    protected final E standardWert;

    public PreferencesConfigOption(ConfigSchluessel<E> parameter) {
        this.schluessel = parameter.getSchluessel();
        this.standardWert = parameter.getStandardWert();
    }

    public Preferences getUserprefs() {
        return userPrefs;
    }

    @Override
    public String getSchluessel() {
        return this.schluessel;
    }

    @Override
    public E getStandardWert() {
        return this.standardWert;
    }

    @Override
    public void setValue(E value) {
        this.inRegistrySchreiben(value);
    }

    @Override
    public E getValue() {
        E value = this.ausRegistryLesen();
        return value;
    }

    @Override
    public void reset() {
        this.setValue(this.getStandardWert());
    }

    protected void logInfo(String wert) {
        String msg = String.format("Schreibe in Registry ... %s/%s: %s", this.getUserprefs().absolutePath(), this.getSchluessel(), wert);
        Kostenrechner.getLogger().info(msg);
    }

    protected abstract void inRegistrySchreiben(E var1);

    protected abstract E ausRegistryLesen();
}

