/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;

public class FontHelfer {
    public static final int MAX_ZEILEN = 40;
    public static final int MAX_SPALTEN = 150;
    public static double zoom = 1.33;

    public Dimension getCharDimension(FontMetrics fontMetrics) {
        int charWidth = fontMetrics.charWidth('n');
        int lineHeight = fontMetrics.getHeight();
        return new Dimension(charWidth, lineHeight);
    }

    public Dimension calculatePreferredSizeFrom(int maxSpalten, int maxZeilen, Dimension charDimension, Dimension maximumSize, Dimension preferredSize) {
        preferredSize.width = charDimension.width > 0 && charDimension.width * maxSpalten < maximumSize.width ? charDimension.width * maxSpalten : maximumSize.width;
        if (charDimension.height > 0 && charDimension.height * maxZeilen < maximumSize.height) {
            preferredSize.height = charDimension.height * maxZeilen;
        }
        return preferredSize;
    }

    public Dimension calculatePreferredSizeWith(Insets insets, Dimension minimum, Dimension preferred) {
        double rand = insets.left + insets.right + insets.top + insets.bottom;
        double width = minimum.getWidth() > preferred.getWidth() ? minimum.getWidth() : preferred.getWidth();
        double height = minimum.getHeight() > preferred.getHeight() ? minimum.getHeight() : preferred.getHeight();
        return new Dimension((int)(width += rand), (int)(height += rand));
    }

    public Font getFontForName(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        Font f = null;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fonts = stringArray[n2];
            if (name.equals(fonts)) {
                f = new Font(fonts, 0, 12);
            }
            ++n2;
        }
        return f;
    }
}

