/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.view;

import eu.gronos.beschriftungen.view.FontHelfer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class FontHelferForComponent
extends FontHelfer {
    private final JComponent component;
    private final Font normal;
    private final Font fett;

    public FontHelferForComponent(JComponent component) {
        this.component = component;
        this.normal = component.getFont();
        this.fett = component.getFont().deriveFont(1);
    }

    public void setPreferredSizeFromAttributeSet(AttributeSet attrib, int maxSpalten, int maxZeilen) {
        Dimension maximumSize = this.component.getMaximumSize();
        Dimension preferredSize = this.component.getPreferredSize();
        this.calculatePreferredSizeFrom(maxSpalten, maxZeilen, this.getCharDimension(attrib), maximumSize, preferredSize);
        this.component.setPreferredSize(preferredSize);
    }

    public FontMetrics getFontMetrics(AttributeSet attrib) {
        return this.component.getFontMetrics(this.getFontForName(StyleConstants.getFontFamily(attrib)));
    }

    private Dimension getCharDimension(AttributeSet attrib) {
        FontMetrics fontMetrics = this.component.getFontMetrics(this.getFontForName(StyleConstants.getFontFamily(attrib)));
        return this.getCharDimension(fontMetrics);
    }

    public void sizeLabel(JLabel label, int multiplikator) {
        Dimension dim = this.getCharDimension(this.component.getFontMetrics(this.normal));
        dim.setSize(dim.width * multiplikator, label.getPreferredSize().height);
        label.setPreferredSize(dim);
    }

    public Font boldLabel(JLabel label) {
        label.setFont(this.fett);
        return this.fett;
    }
}

