/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.view;

import eu.gronos.beschriftungen.view.FontHelfer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class FontHelferForWindow
extends FontHelfer {
    private final Window window;

    public FontHelferForWindow(Window window) {
        this.window = window;
    }

    public Dimension calculatePreferredSizeWith(Insets insets) {
        Dimension minimum = this.window.getMinimumSize();
        Dimension preferred = this.window.getPreferredSize();
        return this.calculatePreferredSizeWith(insets, minimum, preferred);
    }

    public void setPreferredSizeFromAttributeSet(AttributeSet attrib, int maxSpalten, int maxZeilen) {
        Dimension maximumSize = this.window.getMaximumSize();
        Dimension preferredSize = this.window.getPreferredSize();
        this.calculatePreferredSizeFrom(maxSpalten, maxZeilen, this.getCharDimension(attrib), maximumSize, preferredSize);
        this.window.setPreferredSize(preferredSize);
    }

    public Font baseFont() {
        return this.window.getFont();
    }

    public static Dimension averageDimension(List<Dimension> dimensionen) {
        long width = 0L;
        long height = 0L;
        long zaehler = 0L;
        Dimension screenSize = FontHelferForWindow.getScreenSize();
        for (Dimension d : dimensionen) {
            long w = d.width > screenSize.width ? (long)screenSize.width : (long)d.width;
            width += w;
            long h = d.height > screenSize.height ? (long)screenSize.height : (long)d.height;
            height += h;
            ++zaehler;
        }
        return new Dimension((int)(width / zaehler), (int)(height / zaehler));
    }

    private static Dimension getScreenSize() throws HeadlessException {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        screenSize.height = Integer.min(screenSize.height, maxBounds.height);
        screenSize.width = Integer.min(screenSize.width, maxBounds.width);
        return screenSize;
    }

    private Dimension getCharDimension(AttributeSet attrib) {
        FontMetrics fontMetrics = this.window.getFontMetrics(this.getFontForName(StyleConstants.getFontFamily(attrib)));
        return this.getCharDimension(fontMetrics);
    }
}

