/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.beschriftungen.view;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.KontextMouseListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PopupMenuBuilder {
    public JPopupMenu build(Beschriftung beschriftung, JComponent comp, Integer[] seperators, BeschriebeneAktion ... actions) {
        JPopupMenu pop = new JPopupMenu(beschriftung.getTitle());
        JMenuItem menuItem = new JMenuItem();
        if (beschriftung == null || beschriftung.getTitle() == null) {
            System.out.println("Beschriftung null!");
        }
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.beschrifte(pop, beschriftung);
        beschrifter.beschrifte(menuItem, beschriftung);
        pop.add(menuItem);
        int index = 0;
        while (index < actions.length) {
            if (Arrays.asList(seperators).contains(index + 1)) {
                pop.addSeparator();
            }
            BeschriebeneAktion action = actions[index];
            pop.add(action.toMenuItem());
            if (comp.getActionMap() != null) {
                LangBeschriftung langBeschriftung = action.getBeschriftung();
                String actionCommandKey = langBeschriftung.getActionCommandKey();
                comp.getActionMap().put(actionCommandKey, action);
                if (comp.getInputMap() != null && langBeschriftung.getAcceleratorKey() != null) {
                    comp.getInputMap().put(langBeschriftung.getAcceleratorKey().toKeyStroke(), actionCommandKey);
                }
            } else {
                System.out.println("ActionMap ist null!");
            }
            ++index;
        }
        if (comp instanceof JTable) {
            comp.addMouseListener(new KontextMouseListener((JTable)comp, pop));
        } else {
            comp.addMouseListener(new KontextMouseListener(pop));
        }
        return pop;
    }

    public void printActionMap(JComponent comp) {
        if (comp.getActionMap() != null) {
            ActionMap map = comp.getActionMap();
            Object[] objectArray = map.allKeys();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Action a = map.get(o);
                System.out.println(String.format("Key: %s; Action: %s", o.toString(), a.toString()));
                ++n2;
            }
        }
    }
}

