/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerMap;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.FontHelferForWindow;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.controller.system.LizenzNoergler;
import eu.gronos.kostenrechner.util.system.ArgumentParser;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.OsLookAndFeelChanger;
import eu.gronos.kostenrechner.view.RechnerhammerIcons;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;
import eu.gronos.kostenrechner.view.helpanderror.HilfePanel;
import eu.gronos.kostenrechner.view.menus.BearbeitenJMenu;
import eu.gronos.kostenrechner.view.menus.DateiJMenu;
import eu.gronos.kostenrechner.view.menus.ExtrasJMenu;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class Kostenrechner
extends JFrame {
    public static final String KOSTENRECHNER_VERSION = " v0.7";
    private static final long serialVersionUID = -8308234314555759118L;
    public static boolean debug = false;
    public static int ctrlMask = 2;
    private JPanel contentPane;
    private JTabbedPane tabbedPane;
    public static final Clock systemDefaultZone = Clock.systemDefaultZone();
    private static Kostenrechner instance = null;
    private static final Logger logger = Logger.getLogger("eu.gronos.kostenrechner");
    private static String logFileName = "(kein)";
    private static Path logFile;

    public static void main(final String[] args) {
        OsLookAndFeelChanger.pruefeOS();
        Kostenrechner.addFileLogger();
        final ArgumentParser argumeterParser = new ArgumentParser(args);
        debug = argumeterParser.parseDebug();
        if (debug) {
            Kostenrechner.getLogger().info("Debug aktiviert!");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Kostenrechner.setInstance(new Kostenrechner());
                    instance.setVisible(true);
                    Kostenrechner.getLogger().info(String.format("Einlesen der Beschriftungen dauerte %d ms.", NameContainerMap.end - NameContainerMap.start));
                    Path xml = null;
                    if (args != null && args.length > 0) {
                        xml = argumeterParser.parseDateiname();
                        new XmlTransferHandler().nimmXmlDatei(xml);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Kostenrechner() {
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setTabbedPane(new JTabbedPane(1));
        this.contentPane.add(this.getTabbedPane());
        ArrayList<Dimension> dimensionen = new ArrayList<Dimension>();
        dimensionen.addAll(Arrays.asList(this.fuelleStreitwertReduktionPanel()));
        dimensionen.addAll(Arrays.asList(this.fuelleBaumbachPanel()));
        dimensionen.addAll(Arrays.asList(this.fuelleHilfsaufrechnungPanel()));
        dimensionen.addAll(Arrays.asList(this.fuelleGebuehrenRechnerPanel()));
        dimensionen.add(this.getTabbedPane().getPreferredSize());
        dimensionen.add(this.fuelleHilfePanel());
        this.setSize(FontHelferForWindow.averageDimension(dimensionen));
        System.out.println("Gr\u00f6\u00dfe des Fensters: " + this.getSize());
        this.baueMenuBar();
        this.definiereIcons();
        this.setTransferHandler(new XmlTransferHandler());
        new LizenzNoergler(this).noergle();
        Beschriftung beschriftung = (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(100);
        beschriftung.setTitle(String.valueOf(beschriftung.getTitle()) + KOSTENRECHNER_VERSION);
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.beschrifte(this, beschriftung);
        beschrifter.beschrifte(this.tabbedPane, NameContainerSammlung.BESCHRIFTUNGEN.get(111));
    }

    public static Kostenrechner getInstance() {
        return instance;
    }

    public static void setInstance(Kostenrechner instance) {
        Kostenrechner.instance = instance;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static Path getLogFile() {
        return logFile;
    }

    public static void setLogFile(Path logFile) {
        Kostenrechner.logFile = logFile;
    }

    void definiereIcons() {
        RechnerhammerIcons alleIcons = RechnerhammerIcons.getInstance();
        alleIcons.loadIcons();
        this.setIconImages(alleIcons);
    }

    public static void addFileLogger() {
        try {
            logFile = Files.createTempFile(null, ".kostentenor.log", new FileAttribute[0]);
            String fileName = logFile.toAbsolutePath().toString();
            FileHandler handler = new FileHandler(fileName, true);
            Kostenrechner.getLogger().addHandler(handler);
            Kostenrechner.getLogger().info("Logge in: " + fileName);
            logFileName = fileName;
        }
        catch (IOException e) {
            FehlerHelper.zeigeFehler("Konnte Logger nicht bauen.\nLogger konnte Datei nicht \u00f6ffnen", e);
        }
    }

    private void baueMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        ExtrasJMenu aktionenMenu = ExtrasJMenu.getInstance();
        DateiJMenu dateiMenu = DateiJMenu.getInstance();
        BearbeitenJMenu bearbeitenMenu = BearbeitenJMenu.getInstance();
        menuBar.add(dateiMenu);
        menuBar.add(bearbeitenMenu);
        menuBar.add(aktionenMenu);
        dateiMenu.setKostenrechner(this);
        dateiMenu.buildMenu();
        bearbeitenMenu.setKostenrechner(this);
        bearbeitenMenu.buildMenu();
        aktionenMenu.setKostenrechner(this);
        aktionenMenu.buildMenu();
        this.setJMenuBar(menuBar);
        this.addWindowListener((WindowListener)((Object)dateiMenu.getBeendenAction()));
    }

    private Dimension[] fuelleStreitwertReduktionPanel() {
        TeilklageruecknahmePanel pnStreitwertreduktion = TeilklageruecknahmePanel.getInstance();
        pnStreitwertreduktion.intoTabbedPane(this.getTabbedPane(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(10000));
        ((KostenJPanel)pnStreitwertreduktion).setKostenrechner(this);
        ((KostenJPanel)pnStreitwertreduktion).buildPanel();
        return new Dimension[]{pnStreitwertreduktion.getMinimumSize(), pnStreitwertreduktion.getPreferredSize()};
    }

    private Dimension[] fuelleBaumbachPanel() {
        StreitgenossenPanel pnBaumbach = StreitgenossenPanel.getInstance();
        pnBaumbach.intoTabbedPane(this.getTabbedPane(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(30000));
        ((KostenJPanel)pnBaumbach).setKostenrechner(this);
        ((KostenJPanel)pnBaumbach).buildPanel();
        return new Dimension[]{pnBaumbach.getMinimumSize(), pnBaumbach.getPreferredSize()};
    }

    private Dimension[] fuelleHilfsaufrechnungPanel() {
        ForderungsStaffelungPanel pnHilfsaufrechnung = ForderungsStaffelungPanel.getInstance();
        pnHilfsaufrechnung.intoTabbedPane(this.getTabbedPane(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(40000));
        pnHilfsaufrechnung.setKostenrechner(this);
        pnHilfsaufrechnung.buildPanel();
        return new Dimension[]{pnHilfsaufrechnung.getMaximumSize(), pnHilfsaufrechnung.getPreferredSize()};
    }

    private Dimension[] fuelleGebuehrenRechnerPanel() {
        GebuehrenBerechnungPanel pnGebuehrenRechner = GebuehrenBerechnungPanel.getInstance();
        pnGebuehrenRechner.intoTabbedPane(this.getTabbedPane(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(20000));
        ((KostenJPanel)pnGebuehrenRechner).setKostenrechner(this);
        ((KostenJPanel)pnGebuehrenRechner).buildPanel();
        this.getTabbedPane().addChangeListener(pnGebuehrenRechner.getAufrufHorcher());
        return new Dimension[]{pnGebuehrenRechner.getMaximumSize(), pnGebuehrenRechner.getPreferredSize()};
    }

    private Dimension fuelleHilfePanel() {
        HilfePanel pnHilfePanel = HilfePanel.getInstance();
        pnHilfePanel.intoTabbedPane(this.getTabbedPane(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(50000));
        pnHilfePanel.setKostenrechner(this);
        pnHilfePanel.buildPanel();
        return pnHilfePanel.getPreferredSize();
    }

    private void setTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }
}

