/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.interfaces.RowHandler;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class EintragEntfernenAktion
extends BeschriebeneAktion {
    private static final long serialVersionUID = 8001075205760187469L;

    public EintragEntfernenAktion(LangBeschriftung beschriftung) {
        super(beschriftung);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o instanceof JMenuItem) {
            JPopupMenu popup = (JPopupMenu)((JMenuItem)o).getParent();
            this.entferneUeberPopupMenu(popup);
        } else if (o instanceof JTable) {
            JTable table = (JTable)o;
            this.entferneUeberTable(table);
        }
    }

    public void entferneTabellenEintrag(JTable table, RowHandler<?> model) {
        System.out.println("EintragEntfernenAktion#entferneTabellenEintrag!");
        if (table == null || model == null || table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = table.getSelectedRow();
        model.removeRow(selectedRow);
    }

    private void entferneUeberTable(JTable table) {
        if (table.getModel() == null || !(table.getModel() instanceof RowHandler)) {
            return;
        }
        RowHandler model = (RowHandler)((Object)table.getModel());
        this.entferneTabellenEintrag(table, model);
    }

    private void entferneUeberPopupMenu(JPopupMenu popup) {
        if (popup.getName() == null) {
            return;
        }
        if (popup.getName().equals("17100")) {
            this.entferneTabellenEintrag(TeilklageruecknahmePanel.getInstance().tabVorher, TeilklageruecknahmePanel.getInstance().getGttmVorher());
        }
        if (popup.getName().equals("17200")) {
            this.entferneTabellenEintrag(TeilklageruecknahmePanel.getInstance().tabNachher, TeilklageruecknahmePanel.getInstance().getGttmNachher());
        }
        if (popup.getName().equals("39200")) {
            StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(StreitgenossenPanel.getInstance().tabBeklagte, StreitgenossenPanel.getInstance().btmBeklagte);
        }
        if (popup.getName().equals("39100")) {
            StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(StreitgenossenPanel.getInstance().tabKlaeger, StreitgenossenPanel.getInstance().btmKlaeger);
        }
        if (popup.getName().equals("39300")) {
            StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(StreitgenossenPanel.getInstance().tabDrittwiderbeklagte, StreitgenossenPanel.getInstance().btmDrittwiderbeklagte);
        }
        if (popup.getName().equals("44000")) {
            this.entferneTabellenEintrag(ForderungsStaffelungPanel.getInstance().tbForderungen, ForderungsStaffelungPanel.getInstance().ftm);
        }
        if (popup.getName().equals("24200")) {
            this.entferneTabellenEintrag(GebuehrenBerechnungPanel.getInstance().tabGebuehrenTatbestaende, GebuehrenBerechnungPanel.getInstance().gttmRechner);
        }
    }
}

