/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import java.text.ParseException;
import javax.swing.JFormattedTextField;

public class NumberExtractor {
    public static final String FEHLER_KEINE_ZAHL = "Es konnte keine Zahl im Feld '%s' erkannt werden: '%s'!";
    private final JFormattedTextField formattedTextField;
    private String beschriftung;

    public NumberExtractor(JFormattedTextField formattedTextField, String beschriftung) {
        this.formattedTextField = formattedTextField;
        this.beschriftung = beschriftung;
    }

    public Euro extractEuro() {
        Number number = this.extractNumber();
        if (number instanceof Euro) {
            return (Euro)number;
        }
        if (number instanceof Long || number instanceof Integer) {
            return Euro.ofEuros(number.longValue());
        }
        if (number instanceof Double) {
            return Euro.ofEuros((Double)number);
        }
        return Euro.ofEuros(number.doubleValue());
    }

    public double extractDouble() {
        Number number = this.extractNumber();
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public int extractInteger() {
        Number number = this.extractNumber();
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public long extractLong() {
        Number number = this.extractNumber();
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    private Number extractNumber() {
        String text = this.formattedTextField.getText();
        System.out.print("getText:" + text + ";");
        try {
            this.formattedTextField.commitEdit();
            Object value = this.formattedTextField.getValue();
            System.out.println("value:" + value + ";" + value.getClass());
            if (value != null && value instanceof Number) {
                return (Number)value;
            }
            throw new NumberFormatException(String.format(FEHLER_KEINE_ZAHL, this.beschriftung, text));
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(String.format(FEHLER_KEINE_ZAHL, this.beschriftung, text));
            nfe.addSuppressed(e);
            throw nfe;
        }
    }
}

