/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenHinzufuegenDialog;
import java.awt.event.ActionEvent;

public class StreitgenossenBeteiligterNeuAction
extends BeschriebeneAktion
implements AbfrageLieferant<BeteiligtenHinzufuegenDialog> {
    private final StreitgenossenTabellenBehandelnd panel;
    private static final long serialVersionUID = -6505409262360418812L;
    private Beteiligter.BeteiligtenTyp typ;
    private BeteiligtenHinzufuegenDialog dialog = null;

    public StreitgenossenBeteiligterNeuAction(StreitgenossenTabellenBehandelnd panel, Beteiligter.BeteiligtenTyp typ, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = panel;
        this.typ = typ;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.beteiligtenHinzufuegen((BeteiligtenTableModel)this.panel.getTableModel(this.typ.ordinal()));
    }

    @Override
    public BeteiligtenHinzufuegenDialog getDialog() {
        return this.dialog;
    }

    private void beteiligtenHinzufuegen(BeteiligtenTableModel btm) {
        BaumbachBeteiligter bt = btm.getRowCount() > 0 ? btm.getRow(btm.getRowCount() - 1) : new BaumbachBeteiligter(btm.getBeteiligtenTyp(), Beteiligter.GenusNumerus.WEIBLICH_SINGULAR, Euro.ZERO_CENTS, Euro.ZERO_CENTS, false);
        this.setDialog(new BeteiligtenHinzufuegenDialog(Kostenrechner.getInstance(), bt, this.panel.isWiderKlageAnzeigen()));
        bt = (BaumbachBeteiligter)this.dialog.showDialogAndAsk();
        this.dialog = null;
        if (bt != null) {
            try {
                btm.addRow(bt);
            }
            catch (IllegalArgumentException e) {
                FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            }
        }
    }

    private BeteiligtenHinzufuegenDialog setDialog(BeteiligtenHinzufuegenDialog dialog) {
        this.dialog = dialog;
        return dialog;
    }
}

