/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import java.awt.event.ActionEvent;

public class StreitgenossenGesamtschuldBkExtractAction
extends BeschriebeneAktion {
    private final StreitgenossenTabellenBehandelnd handler;
    private static final long serialVersionUID = -2835734772816646654L;

    public StreitgenossenGesamtschuldBkExtractAction(StreitgenossenTabellenBehandelnd handler, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.handler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        BeteiligtenTableModel btm = (BeteiligtenTableModel)this.handler.getTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE.ordinal());
        BaumbachBeteiligtenListe beteiligte = btm.getAllValues();
        if (beteiligte == null || beteiligte.size() < 2) {
            return;
        }
        BaumbachGesamtschuldnerschaft gesamtschuldnerschaft = beteiligte.extrahiereGesamtschuldnerschaft(btm.getBeteiligtenTyp());
        if (gesamtschuldnerschaft != null) {
            btm.addRow(gesamtschuldnerschaft);
            this.actionPerformed(event);
            btm.fireTableDataChanged();
        } else {
            Kostenrechner.getLogger().info("Schleife endet!");
        }
    }
}

