/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.GesamtschuldnerDialog;
import java.awt.event.ActionEvent;

public class StreitgenossenGesamtschuldnerBkAction
extends BeschriebeneAktion
implements AbfrageLieferant<GesamtschuldnerDialog> {
    private final StreitgenossenTabellenBehandelnd panel;
    private static final long serialVersionUID = 3348162188610732190L;
    private GesamtschuldnerDialog dialog = null;

    public StreitgenossenGesamtschuldnerBkAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            try {
                this.setDialog(new GesamtschuldnerDialog(this.panel.getKostenrechner(), ((BeteiligtenTableModel)this.panel.getTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE.ordinal())).getAllValues(), this.panel.getExtrahierenAktion(Beteiligter.BeteiligtenTyp.BEKLAGTE)));
                BaumbachGesamtschuldnerschaft bt = (BaumbachGesamtschuldnerschaft)this.getDialog().showDialogAndAsk();
                if (bt != null) {
                    ((BeteiligtenTableModel)this.panel.getTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE.ordinal())).addRow(bt);
                }
            }
            catch (IllegalArgumentException iae) {
                FehlerHelper.zeigeFehler(iae.getLocalizedMessage(), iae);
                this.setDialog(null);
            }
        }
        finally {
            this.setDialog(null);
        }
    }

    @Override
    public GesamtschuldnerDialog getDialog() {
        return this.dialog;
    }

    private void setDialog(GesamtschuldnerDialog dialog) {
        this.dialog = dialog;
    }
}

