/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.util.baumbach.StreitgenossenPruefer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;

public class StreitgenossenParser
implements ParsendUndBauend<Streitgenossen> {
    private Streitgenossen rueckgabewert;
    private Widerklage mitWiderklage;
    private JTable tabKlaeger;
    private JTable tabBeklagte;
    private JTable tabDrittwiderbeklagte;
    private final boolean streng;

    public StreitgenossenParser() {
        this(false);
    }

    public StreitgenossenParser(boolean streng) {
        this.streng = streng;
    }

    @Override
    public ParsendUndBauend<Streitgenossen> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("31011".equals(component.getName())) {
                    this.tabKlaeger = (JTable)component;
                } else if ("32011".equals(component.getName())) {
                    this.tabBeklagte = (JTable)component;
                } else if ("33111".equals(component.getName())) {
                    this.tabDrittwiderbeklagte = (JTable)component;
                } else {
                    System.out.println("H\u00e4? " + component.getName());
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert = this.leseFelder();
            if (this.streng) {
                return this.parseEingabe(this.rueckgabewert);
            }
        }
        catch (NullPointerException | NumberFormatException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
        return true;
    }

    @Override
    public boolean parseEingabe(Streitgenossen rueckgabewert) throws NumberFormatException, NullPointerException {
        this.rueckgabewert = rueckgabewert;
        return new StreitgenossenPruefer().pruefeEingabe(rueckgabewert);
    }

    @Override
    public Streitgenossen getRueckgabewert() {
        return this.rueckgabewert;
    }

    public ParsendUndBauend<Streitgenossen> setzeSonstigeWerte(Widerklage mitWiderklage) {
        this.mitWiderklage = mitWiderklage;
        return this;
    }

    private Streitgenossen leseFelder() throws NumberFormatException, NullPointerException {
        this.rueckgabewert = new Streitgenossen();
        this.rueckgabewert.widerklage = this.mitWiderklage.isVorhanden();
        this.rueckgabewert.wirtschaftlichIdentisch = this.mitWiderklage.isWirtschaftlichIdentisch();
        BeteiligtenTableModel btmKlaeger = (BeteiligtenTableModel)this.tabKlaeger.getModel();
        this.rueckgabewert.klaeger = btmKlaeger.getAllValues();
        BeteiligtenTableModel btmBeklagte = (BeteiligtenTableModel)this.tabBeklagte.getModel();
        this.rueckgabewert.beklagte = btmBeklagte.getAllValues();
        if (this.mitWiderklage.isVorhanden()) {
            BeteiligtenTableModel btmDrittwiderbeklagte = (BeteiligtenTableModel)this.tabDrittwiderbeklagte.getModel();
            this.rueckgabewert.drittwiderbeklagte = btmDrittwiderbeklagte.getAllValues();
        } else {
            this.rueckgabewert.drittwiderbeklagte = new BaumbachBeteiligtenListe();
        }
        return this.rueckgabewert;
    }
}

