/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.WiderklageHinzufuegenDialog;
import java.awt.event.ActionEvent;

public class StreitgenossenWiderklageAction
extends BeschriebeneAktion
implements AbfrageLieferant<WiderklageHinzufuegenDialog> {
    private final StreitgenossenTabellenBehandelnd panel;
    private static final long serialVersionUID = 7753262660993032427L;
    private final WiderklageHinzufuegenDialog dialog;

    public StreitgenossenWiderklageAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = panel;
        this.dialog = new WiderklageHinzufuegenDialog(panel.getKostenrechner());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Widerklage widerklage = (Widerklage)this.dialog.showDialogAndAsk();
        if (widerklage == null) {
            return;
        }
        this.panel.setWiderKlageAnzeigen(widerklage.isVorhanden());
        ((BeteiligtenTableModel)this.panel.getTableModel(Beteiligter.BeteiligtenTyp.KLAEGER.ordinal())).setWiderKlageAnzeigen(widerklage.isVorhanden());
        ((BeteiligtenTableModel)this.panel.getTableModel(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal())).setWiderKlageAnzeigen(widerklage.isVorhanden());
        ((BeteiligtenTableModel)this.panel.getTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE.ordinal())).setWiderKlageAnzeigen(widerklage.isVorhanden());
        this.panel.setWirtschaftlichIdentisch(widerklage.isWirtschaftlichIdentisch());
    }

    @Override
    public WiderklageHinzufuegenDialog getDialog() {
        return this.dialog;
    }
}

