/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.baumbach.BaumbachAssistentDialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Path;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StreitgenossenXJustizLesenAction
extends BeschriebeneAktion
implements AbfrageLieferant<JDialog> {
    private final StreitgenossenTabellenBehandelnd handler;
    private final JFrame frame;
    private static final long serialVersionUID = 3372100502718641247L;
    private KostenFileChooser fileChooser = null;

    public StreitgenossenXJustizLesenAction(StreitgenossenTabellenBehandelnd handler, JFrame frame, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.handler = handler;
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Path auswahl = null;
        VerfahrensDatenContainer container = null;
        this.fileChooser = new KostenFileChooser(XjustizContentHandler.XJUSTIZ_FILTER, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
        int ergebnis = this.fileChooser.showOpenDialog(this.frame);
        if (ergebnis == 0) {
            auswahl = this.fileChooser.getSelectedPath();
            this.fileChooser = null;
            container = this.xJustizLesen(auswahl);
            if (container != null && container.streitgenossen != null) {
                this.handler.setzeWerte(container.streitgenossen);
                this.handler.requestFocusInWindow();
            }
        } else {
            this.fileChooser = null;
        }
    }

    public VerfahrensDatenContainer xJustizLesen(Path datei) {
        BaumbachAssistentDialog bad;
        Kostenrechner.getLogger().info("xJustizLesen!");
        VerfahrensDatenContainer container = null;
        try {
            container = new XjustizContentHandler(XjustizContentHandler.vonPathNachURI(datei)).parseXjustiz();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
        }
        if (container != null) {
            Kostenrechner.getLogger().info("container != null --> BaumbachAssistent mit container bauen");
            bad = new BaumbachAssistentDialog(this.frame, container);
        } else {
            bad = new BaumbachAssistentDialog(this.frame, this.handler.isWiderKlageAnzeigen());
        }
        Kostenrechner.getLogger().info("BaumbachAssistentDialog aufrufen");
        container = (VerfahrensDatenContainer)bad.showDialogAndAsk();
        Kostenrechner.getLogger().info(String.format("BaumbachAssistentDialog ist fertig; container == null? %s!", container == null));
        return container;
    }

    @Override
    public JDialog getDialog() {
        if (this.fileChooser != null) {
            return this.fileChooser.getDialog();
        }
        return null;
    }
}

