/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRahmenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.GebuehrenMitAnzahl;
import eu.gronos.kostenrechner.interfaces.GebuehrenMitAnzahlLinear;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AuslagenHoeheVisibilityHorcher
implements ListSelectionListener,
ListDataListener {
    private final JFormattedTextField ftf;
    private final JLabel label;
    private int selectedIndex = -1;
    private final VorsorgendeBeschriftung beschriftung;

    public AuslagenHoeheVisibilityHorcher(JFormattedTextField ftf, JLabel label, VorsorgendeBeschriftung beschriftung) {
        this.ftf = ftf;
        this.label = label;
        this.beschriftung = beschriftung;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!(e.getSource() instanceof JList)) {
            return;
        }
        GebuehrenTatbestand gt = this.getSelectedItem((JList)e.getSource());
        this.changeVisibility(gt);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (!(e.getSource() instanceof ListModel)) {
            return;
        }
        GebuehrenTatbestand gt = this.getSelectedItem((ListModel)e.getSource());
        this.changeVisibility(gt);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    private void changeVisibility(GebuehrenTatbestand gt) {
        if (gt != null && gt instanceof AuslagenTatbestand && (((AuslagenTatbestand)gt).getBetrag() == null || Euro.ofCents(0L).compareTo(((AuslagenTatbestand)gt).getBetrag()) >= 0)) {
            this.aktiviereFtfAuslagenHoehe("0", 1, gt);
        } else if (gt != null && gt instanceof GebuehrenMitAnzahlLinear && ((GebuehrenMitAnzahl)((Object)gt)).getAnzahl() < 0) {
            this.aktiviereFtfAuslagenHoehe("0", 2, gt);
        } else if (gt != null && gt instanceof GebuehrenAnrechnungsTatbestand) {
            this.aktiviereFtfAuslagenHoehe(String.format("%,.2f", ((GebuehrenAnrechnungsTatbestand)gt).getMittel()), 3, gt);
        } else if (gt != null && gt instanceof GebuehrenRahmenTatbestand) {
            this.aktiviereFtfAuslagenHoehe(String.format("%,.1f", ((GebuehrenRahmenTatbestand)gt).getMittel()), 3, gt);
        } else {
            this.ftf.setEnabled(false);
            ComponentBeschrifter beschrifter = new ComponentBeschrifter();
            beschrifter.changeTo(this.beschriftung, 0);
            beschrifter.beschrifte(this.label, this.beschriftung);
        }
    }

    private void aktiviereFtfAuslagenHoehe(String feldText, int index, GebuehrenTatbestand gt) {
        this.ftf.setVisible(true);
        this.ftf.setEnabled(true);
        this.ftf.setText(feldText);
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.changeTo(this.beschriftung, index);
        if (gt instanceof GebuehrenMitAnzahlLinear && this.beschriftung.getTitle().contains("%")) {
            this.beschriftung.setTitle(String.format(this.beschriftung.getTitle(), ((GebuehrenMitAnzahl)((Object)gt)).getEinheit()));
        }
        beschrifter.beschrifte(this.label, this.beschriftung);
    }

    private GebuehrenTatbestand getSelectedItem(JList<?> liste) {
        this.selectedIndex = liste.getSelectedIndex();
        if (liste == null || this.selectedIndex < 0) {
            return null;
        }
        ListModel<?> model = liste.getModel();
        return this.getSelectedItem(model);
    }

    private GebuehrenTatbestand getSelectedItem(ListModel<?> model) {
        Object element = model.getElementAt(this.selectedIndex);
        if (element instanceof GebuehrenTatbestand) {
            return (GebuehrenTatbestand)element;
        }
        return null;
    }
}

