/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.util.gebuehren.GebuehrenBerechnungPruefer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;

public class GebuehrenBerechnungParser
implements ParsendUndBauend<GebuehrenBerechnung> {
    private GebuehrenBerechnung rueckgabewert;
    private JFormattedTextField textfield;
    private JTable table;
    private final boolean streng;

    public GebuehrenBerechnungParser() {
        this(false);
    }

    public GebuehrenBerechnungParser(boolean streng) {
        this.streng = streng;
    }

    @Override
    public ParsendUndBauend<GebuehrenBerechnung> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("21005".equals(component.getName())) {
                    this.textfield = (JFormattedTextField)component;
                } else if ("22011".equals(component.getName())) {
                    this.table = (JTable)component;
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() throws NumberFormatException, NullPointerException {
        try {
            if (this.table == null) {
                throw new NullPointerException();
            }
            this.rueckgabewert = this.leseFelder();
            if (this.streng) {
                return this.parseEingabe(this.rueckgabewert);
            }
        }
        catch (NullPointerException | NumberFormatException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
        return true;
    }

    @Override
    public boolean parseEingabe(GebuehrenBerechnung rueckgabewert) throws NumberFormatException, NullPointerException, IllegalArgumentException {
        this.rueckgabewert = rueckgabewert;
        return new GebuehrenBerechnungPruefer().pruefeEingabe(rueckgabewert);
    }

    @Override
    public GebuehrenBerechnung getRueckgabewert() {
        return this.rueckgabewert;
    }

    private GebuehrenBerechnung leseFelder() throws NumberFormatException, NullPointerException {
        GebuehrenBerechnung rueckgabewert = new GebuehrenBerechnung();
        rueckgabewert.streitwert = Euro.ZERO_CENTS;
        rueckgabewert.gebuehren = new GebuehrenAuflistung();
        NumberExtractor extractor = new NumberExtractor(this.textfield, this.textfield.getAccessibleContext().getAccessibleName());
        rueckgabewert.streitwert = Euro.ofEuros(extractor.extractDouble());
        System.out.println("Gelesener Streitwert: " + rueckgabewert.streitwert);
        GebuehrenTableModel model = (GebuehrenTableModel)this.table.getModel();
        rueckgabewert.gebuehren = model.getAllValues();
        return rueckgabewert;
    }
}

