/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.TenorAction;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.logic.gebuehren.MehrkostenMethode;
import eu.gronos.kostenrechner.logic.gebuehren.QuotenMethode;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

public class TeilklageTenorAction
extends TenorAction {
    private static final long serialVersionUID = -172361077062445138L;
    private final TeilklageruecknahmePanel panel;

    public TeilklageTenorAction(TeilklageruecknahmePanel teilklageruecknahmePanel, LangBeschriftung beschriftung) {
        super(beschriftung);
        this.panel = teilklageruecknahmePanel;
    }

    @Override
    protected boolean allesOk() throws IllegalArgumentException {
        if (!this.panel.pruefeTabellen()) {
            throw new IllegalArgumentException("Bitte geben Sie zun\u00e4chst ein welche Geb\u00fchren vor und/oder nach der Streitwertreduktion angefallen waren.");
        }
        return true;
    }

    @Override
    protected TenorDatenContainer tenorDaten(VerfahrensDatenContainer container) throws IllegalArgumentException {
        if (this.panel.isQuotenMethodeVorziehen()) {
            return new QuotenMethode(container).erzeugeContainer();
        }
        return new MehrkostenMethode(container).erzeugeContainer();
    }
}

