/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.util.gebuehren.TeilklageruecknahmePruefer;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;

public class TeilklageruecknahmeParser
implements ParsendUndBauend<Teilklageruecknahme> {
    private Teilklageruecknahme rueckgabewert;
    private JComboBox<Beteiligter> cbKlaeger;
    private JComboBox<Beteiligter> cbBeklagte;
    private JFormattedTextField ftfStreitwertVorher;
    private JTable tabVorher;
    private JFormattedTextField ftfStreitwertNachher;
    private JTable tabNachher;
    private JFormattedTextField ftfObsiegen;
    private final boolean streng;

    public TeilklageruecknahmeParser() {
        this(false);
    }

    public TeilklageruecknahmeParser(boolean streng) {
        this.streng = streng;
    }

    @Override
    public ParsendUndBauend<Teilklageruecknahme> leseComponents(Component ... components) {
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                JComponent component = (JComponent)comp;
                if ("11005".equals(component.getName())) {
                    this.cbKlaeger = (JComboBox)component;
                } else if ("11015".equals(component.getName())) {
                    this.cbBeklagte = (JComboBox)component;
                } else if ("12005".equals(component.getName())) {
                    this.ftfStreitwertVorher = (JFormattedTextField)component;
                } else if ("12011".equals(component.getName())) {
                    this.tabVorher = (JTable)component;
                } else if ("13005".equals(component.getName())) {
                    this.ftfStreitwertNachher = (JFormattedTextField)component;
                } else if ("13011".equals(component.getName())) {
                    this.tabNachher = (JTable)component;
                } else if ("14005".equals(component.getName())) {
                    this.ftfObsiegen = (JFormattedTextField)component;
                } else {
                    System.out.println("H\u00e4? " + component.getName());
                }
                ++n2;
            }
        }
        return this;
    }

    @Override
    public boolean parseEingabe() throws NumberFormatException, NullPointerException {
        try {
            this.rueckgabewert = this.leseFelder();
            if (this.streng) {
                this.parseEingabe(this.rueckgabewert);
            }
        }
        catch (NullPointerException | NumberFormatException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
        return true;
    }

    @Override
    public boolean parseEingabe(Teilklageruecknahme rueckgabewert) throws NumberFormatException, NullPointerException, IllegalArgumentException {
        this.rueckgabewert = rueckgabewert;
        return new TeilklageruecknahmePruefer().pruefeEingabe(rueckgabewert);
    }

    @Override
    public Teilklageruecknahme getRueckgabewert() {
        return this.rueckgabewert;
    }

    private Teilklageruecknahme leseFelder() throws NumberFormatException, NullPointerException {
        this.rueckgabewert = new Teilklageruecknahme();
        this.rueckgabewert.parteien.add((Beteiligter)this.cbKlaeger.getSelectedItem());
        this.rueckgabewert.parteien.add((Beteiligter)this.cbBeklagte.getSelectedItem());
        NumberExtractor xtractor = new NumberExtractor(this.ftfStreitwertVorher, this.ftfStreitwertVorher.getAccessibleContext().getAccessibleName());
        this.rueckgabewert.streitwerteUndObsiegen.add(Euro.ofEuros(xtractor.extractLong()));
        xtractor = new NumberExtractor(this.ftfStreitwertNachher, this.ftfStreitwertNachher.getAccessibleContext().getAccessibleName());
        this.rueckgabewert.streitwerteUndObsiegen.add(Euro.ofEuros(xtractor.extractLong()));
        xtractor = new NumberExtractor(this.ftfObsiegen, this.ftfObsiegen.getAccessibleContext().getAccessibleName());
        this.rueckgabewert.streitwerteUndObsiegen.add(Euro.ofEuros(xtractor.extractLong()));
        GebuehrenTableModel gtmVorher = (GebuehrenTableModel)this.tabVorher.getModel();
        this.rueckgabewert.vorher = gtmVorher.getAllValues();
        GebuehrenTableModel gtmNachher = (GebuehrenTableModel)this.tabNachher.getModel();
        this.rueckgabewert.nachher = gtmNachher.getAllValues();
        return this.rueckgabewert;
    }
}

