/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.system;

import eu.gronos.beschriftungen.model.BooleanConfigSchluessel;
import eu.gronos.beschriftungen.util.BooleanConfigOption;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.Noergelnd;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;
import java.awt.Window;
import javax.swing.JFrame;

public class DatenschutzNoergler
implements Noergelnd<BooleanConfigOption>,
AbfrageLieferant<DatenschutzZustimmungDialog> {
    private final JFrame owner;
    private int level;
    private BooleanConfigOption basisOption;
    private BooleanConfigOption anhangOption;
    private DatenschutzZustimmung zustimmung;
    private DatenschutzZustimmungDialog dialog = null;

    public DatenschutzNoergler(JFrame owner, int level) {
        this.owner = owner;
        this.level = level;
        this.setZustimmung(new DatenschutzZustimmung());
        this.basisOption = new BooleanConfigOption(new BooleanConfigSchluessel("dsgvo-email-basis", false));
        this.getZustimmung().emailBasisZugestimmt = (Boolean)this.basisOption.getValue();
        this.anhangOption = new BooleanConfigOption(new BooleanConfigSchluessel("dsgvo-email-anhang", false));
        this.getZustimmung().emailAnhangZugestimmt = (Boolean)this.anhangOption.getValue();
    }

    @Override
    public boolean noergle() {
        if (this.getZustimmung().get(this.level)) {
            return true;
        }
        this.setZustimmung((DatenschutzZustimmung)this.setDialog(new DatenschutzZustimmungDialog((Window)this.owner, this.level, this.getZustimmung())).showDialogAndAsk());
        this.setDialog(null);
        if (this.getZustimmung() != null) {
            this.basisOption.setValue(this.getZustimmung().emailBasisZugestimmt);
            this.anhangOption.setValue(this.getZustimmung().emailAnhangZugestimmt);
            return this.getZustimmung().get(this.level);
        }
        return false;
    }

    @Override
    public BooleanConfigOption getOption() {
        if (34 == this.level) {
            return this.anhangOption;
        }
        return this.basisOption;
    }

    public void reset() {
        this.getOption().reset();
    }

    public DatenschutzZustimmung getZustimmung() {
        return this.zustimmung;
    }

    public void setZustimmung(DatenschutzZustimmung zustimmung) {
        this.zustimmung = zustimmung;
    }

    @Override
    public DatenschutzZustimmungDialog getDialog() {
        return this.dialog;
    }

    private DatenschutzZustimmungDialog setDialog(DatenschutzZustimmungDialog dialog) {
        this.dialog = dialog;
        return this.dialog;
    }
}

