/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.system;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class DatenschutzZustimmungAktion
extends BeschriebeneAktion
implements ParsendUndBauend<DatenschutzZustimmung> {
    private static final long serialVersionUID = 3427160893867504969L;
    private DatenschutzZustimmungDialog dialog;
    private DatenschutzZustimmung rueckgabewert;
    private int benoetigtesLevel;
    private int aktuellesLevel;

    public DatenschutzZustimmungAktion(DatenschutzZustimmungDialog dialog, LangBeschriftung beschriftung, int level, DatenschutzZustimmung rueckgabewert) {
        super(beschriftung);
        this.dialog = dialog;
        this.rueckgabewert = rueckgabewert;
        this.benoetigtesLevel = level;
        if (21 == level) {
            this.setAktuellesLevel(21);
        } else if (34 == level) {
            if (rueckgabewert.emailBasisZugestimmt) {
                this.setAktuellesLevel(34);
            } else {
                this.setAktuellesLevel(21);
            }
        } else {
            throw new IllegalArgumentException("level hat keinen g\u00fcltigen Wert");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.parseEingabe();
        if (this.calculateIndex() == 0 && this.getAktuellesLevel() < this.getBenoetigtesLevel()) {
            this.setAktuellesLevel(this.getBenoetigtesLevel());
            SwingUtilities.invokeLater(() -> this.dialog.wechseleTab());
            return;
        }
        this.dialog.setOk(true);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public int calculateIndex() {
        if (21 == this.getAktuellesLevel()) {
            return 0;
        }
        if (34 == this.getAktuellesLevel()) {
            return 1;
        }
        return -1;
    }

    @Override
    public ParsendUndBauend<DatenschutzZustimmung> leseComponents(Component ... components) {
        return this;
    }

    @Override
    public boolean parseEingabe() {
        try {
            this.rueckgabewert.set(this.getAktuellesLevel(), true);
            return this.parseEingabe(this.rueckgabewert);
        }
        catch (IllegalArgumentException | NullPointerException ne) {
            FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
            return false;
        }
    }

    @Override
    public boolean parseEingabe(DatenschutzZustimmung rueckgabewert) throws IllegalArgumentException, NullPointerException {
        this.rueckgabewert = rueckgabewert;
        return true;
    }

    @Override
    public DatenschutzZustimmung getRueckgabewert() {
        return this.rueckgabewert;
    }

    public int getBenoetigtesLevel() {
        return this.benoetigtesLevel;
    }

    public int getAktuellesLevel() {
        return this.aktuellesLevel;
    }

    public void setAktuellesLevel(int aktuellesLevel) {
        this.aktuellesLevel = aktuellesLevel;
    }
}

