/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.system;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailFehler;
import eu.gronos.kostenrechner.util.files.ThrowableWrapper;
import eu.gronos.kostenrechner.view.helpanderror.FehlerDialog;
import java.io.StringWriter;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class FehlerHelper {
    private final Throwable throwable;
    private final String meldung;
    private final BeschriebeneAktion emailSchreibenFehler;
    private static FehlerDialog dialog = null;

    public FehlerHelper(Throwable throwable, String meldung) {
        this.throwable = throwable;
        StackTraceElement stack = throwable.getStackTrace()[0];
        String klasse = stack.getClassName();
        this.meldung = this.repariereMeldung(meldung, throwable);
        String methode = stack.getMethodName();
        Kostenrechner.getLogger().logp(Level.WARNING, klasse, methode, meldung, throwable);
        this.emailSchreibenFehler = new SchreibeEmailFehler((LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(72045), this);
    }

    private String repariereMeldung(String meldung, Throwable throwable) {
        if (meldung == null || meldung.isEmpty()) {
            if (throwable.getLocalizedMessage() != null && !throwable.getLocalizedMessage().isEmpty()) {
                return throwable.getLocalizedMessage();
            }
            if (throwable.getMessage() != null && !throwable.getMessage().isEmpty()) {
                return throwable.getMessage();
            }
            return throwable.getClass().toString();
        }
        return meldung;
    }

    public static void zeigeFehler(String meldung, Throwable throwable) {
        if (Kostenrechner.getInstance() == null || !Kostenrechner.getInstance().isVisible()) {
            if (Kostenrechner.getLogger() == null) {
                System.err.println(meldung);
                throwable.printStackTrace();
            } else {
                StackTraceElement stack = throwable.getStackTrace()[0];
                String klasse = stack.getClassName();
                String methode = stack.getMethodName();
                Kostenrechner.getLogger().logp(Level.SEVERE, klasse, methode, meldung, throwable);
            }
        } else {
            FehlerHelper.setDialog(new FehlerDialog(meldung, new FehlerHelper(throwable, meldung))).showDialog();
            FehlerHelper.setDialog(null);
        }
    }

    public String baueFehlerXmlString(boolean formatted) {
        StringWriter sw = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance(ThrowableWrapper.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", new Boolean(formatted));
            marshaller.marshal((Object)new ThrowableWrapper(this.throwable), sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "Fehler beim Konvertieren in XML: " + e.getLocalizedMessage();
        }
        return sw.toString();
    }

    public static FehlerDialog getDialog() {
        return dialog;
    }

    public static FehlerDialog setDialog(FehlerDialog dialog) {
        FehlerHelper.dialog = dialog;
        return dialog;
    }

    public BeschriebeneAktion getEmailAktion() {
        return this.emailSchreibenFehler;
    }

    public String getMeldung() {
        return this.meldung;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

