/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.controller.system;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.DatenschutzNoergler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.EmailData;
import eu.gronos.kostenrechner.data.Ersetzung;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.util.ErsetzungComparator;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.xml.bind.JAXB;

public abstract class SchreibeEmail
extends BeschriebeneAktion
implements AbfrageLieferant<DatenschutzZustimmungDialog> {
    private static final long serialVersionUID = 9027687725799709474L;
    private static final String E_MAIL_FEHLER_URI_SYNTAX = "URI-Syntax falsch: ";
    private static final String E_MAIL_FEHLER_ENCODING = "Zeichenkodierung nicht unterst\u00fctzt: ";
    private static final String E_MAIL_FEHLER_TEXT = "Fehler beim Aufruf des Standard-E-Mail-Programms: ";
    private final EmailData eMailData = JAXB.unmarshal(this.getClass().getClassLoader().getResourceAsStream("resources/email.xml"), EmailData.class);
    protected static final String SUBJECT2 = "?subject=";
    protected static final String BODY2 = "&BODY=";
    protected static final String MAILTO = "mailto:";
    protected static final String NEUER_ABSATZ = "\n\n";
    private DatenschutzNoergler noergler = null;

    protected SchreibeEmail(LangBeschriftung beschriftung) {
        super(beschriftung);
        this.eMailData.replaceWiths.sort(new ErsetzungComparator());
    }

    @Override
    public DatenschutzZustimmungDialog getDialog() {
        if (this.getNoergler() == null) {
            return null;
        }
        return this.getNoergler().getDialog();
    }

    protected final void schreibe(String subject, String body) {
        try {
            URI mailtoURI = new URI(MAILTO + this.eMailData.helpDeskEmail + SUBJECT2 + this.urlEncode(subject) + BODY2 + this.urlEncode(body));
            Desktop.getDesktop().mail(mailtoURI);
        }
        catch (UnsupportedEncodingException uee) {
            FehlerHelper.zeigeFehler("Fehler beim Aufruf des Standard-E-Mail-Programms: Zeichenkodierung nicht unterst\u00fctzt: " + uee.getLocalizedMessage(), uee);
        }
        catch (URISyntaxException use) {
            FehlerHelper.zeigeFehler("Fehler beim Aufruf des Standard-E-Mail-Programms: URI-Syntax falsch: " + use.getLocalizedMessage(), use);
        }
        catch (IOException ioe) {
            FehlerHelper.zeigeFehler(E_MAIL_FEHLER_TEXT + ioe.getLocalizedMessage(), ioe);
        }
    }

    protected final String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    protected void schreibeDifferenziert(String subject, String basisFrage, String erweiterterText) {
        this.setNoergler(new DatenschutzNoergler(Kostenrechner.getInstance(), 34)).noergle();
        DatenschutzZustimmung zustimmung = this.getNoergler().getZustimmung();
        this.setNoergler(null);
        if (zustimmung != null && zustimmung.emailBasisZugestimmt) {
            StringBuilder body = new StringBuilder(basisFrage);
            if (zustimmung.emailAnhangZugestimmt) {
                body.append(erweiterterText);
            }
            this.schreibe(subject, body.toString());
        }
    }

    protected final String verkleinere(String lang) {
        String string = lang;
        this.eMailData.replaceWiths.sort(new ErsetzungComparator());
        for (Ersetzung e : this.eMailData.replaceWiths) {
            string = string.replaceAll(e.getReplace(), e.getWith());
        }
        if (!this.eMailData.replaceWiths.isEmpty()) {
            System.out.println(String.valueOf(this.eMailData.replaceWiths.get(0).getReplace()) + " / " + this.eMailData.replaceWiths.get(this.eMailData.replaceWiths.size() - 1).getReplace());
        }
        return string;
    }

    protected DatenschutzNoergler getNoergler() {
        return this.noergler;
    }

    protected DatenschutzNoergler setNoergler(DatenschutzNoergler noergler) {
        this.noergler = noergler;
        return this.noergler;
    }
}

