/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import eu.gronos.kostenrechner.logic.TenorTexter;
import java.util.ArrayList;
import java.util.Collection;

public class BaumbachBeteiligtenListe
extends ArrayList<BaumbachBeteiligter> {
    private static final long serialVersionUID = -8096730827452814426L;
    private static final String ANGRIFFS_NAME = "%s ./. %s auf %,.2f EUR";

    public BaumbachBeteiligtenListe() {
    }

    public BaumbachBeteiligtenListe(Collection<? extends BaumbachBeteiligter> c) throws IllegalArgumentException {
        super(c);
        if (!this.istReihenfolgeEingehalten()) {
            throw new IllegalArgumentException("Die Collection der BaumbachBeteiligten muss die Beteiligten bzgl. des Typs in der Reihenfolge KLAEGER, [DRITTWIDERBEKLAGTE,] BEKLAGTE enthalten!");
        }
    }

    public BaumbachBeteiligtenListe(Collection<? extends BaumbachBeteiligter> kl, Collection<? extends BaumbachBeteiligter> bk) throws IllegalArgumentException {
        super(kl);
        this.addAll(bk);
        if (!this.istReihenfolgeEingehalten()) {
            throw new IllegalArgumentException("Die Collection der BaumbachBeteiligten muss die Beteiligten bzgl. des Typs in der Reihenfolge KLAEGER, [DRITTWIDERBEKLAGTE,] BEKLAGTE enthalten!");
        }
    }

    public BaumbachBeteiligtenListe(Collection<? extends BaumbachBeteiligter> kl, Collection<? extends BaumbachBeteiligter> dwbk, Collection<? extends BaumbachBeteiligter> bk) throws IllegalArgumentException {
        super(kl);
        this.addAll(dwbk);
        this.addAll(bk);
        if (!this.istReihenfolgeEingehalten()) {
            throw new IllegalArgumentException("Die Collection der BaumbachBeteiligten muss die Beteiligten bzgl. des Typs in der Reihenfolge KLAEGER, [DRITTWIDERBEKLAGTE,] BEKLAGTE enthalten!");
        }
    }

    public BaumbachGesamtschuldnerschaft getAlsGesamtschuldner(int index) {
        return (BaumbachGesamtschuldnerschaft)super.get(index);
    }

    public HtmlRtfFormattierend addiereStreitwerte() {
        Euro zwischen = Euro.ZERO_CENTS;
        for (BaumbachBeteiligter bb : this) {
            if (bb.isGesamtschuldnerschaft()) continue;
            zwischen = zwischen.add(bb.getAntrag());
        }
        return zwischen;
    }

    @Deprecated
    public double addiereStreitwerte(int beteiligtenTyp2) {
        Beteiligter.BeteiligtenTyp beteiligtenTyp = Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp2];
        return this.addiereStreitwerte(beteiligtenTyp).doubleValue();
    }

    public Euro addiereStreitwerte(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        Euro zwischen = Euro.ZERO_CENTS;
        for (BaumbachBeteiligter bb : this) {
            if (bb.getTyp() != beteiligtenTyp || bb.isGesamtschuldnerschaft()) continue;
            zwischen = zwischen.add(bb.getAntrag());
        }
        return zwischen;
    }

    @Deprecated
    public double addiereUnterliegen(int beteiligtenTyp2) {
        Beteiligter.BeteiligtenTyp beteiligtenTyp = Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp2];
        return this.addiereUnterliegen(beteiligtenTyp).doubleValue();
    }

    public Euro addiereUnterliegen(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        Euro zwischen = Euro.ZERO_CENTS;
        for (BaumbachBeteiligter bb : this) {
            if (bb.getTyp() != beteiligtenTyp) continue;
            zwischen = bb.isGesamtschuldnerschaft() ? zwischen.add(bb.getErfolg().multiply(Double.valueOf(((BaumbachGesamtschuldnerschaft)bb).getAnzahl()))) : zwischen.add(bb.getErfolg());
        }
        return zwischen;
    }

    public Euro addiereAngreiferUnterliegen(Beteiligter.BeteiligtenTyp typGegenseite) {
        return this.addiereStreitwerte(typGegenseite).subtract(this.addiereUnterliegen(typGegenseite));
    }

    @Deprecated
    public double addiereAngreiferUnterliegen(int typGegenseite) {
        return this.addiereAngreiferUnterliegen(Beteiligter.BeteiligtenTyp.of(typGegenseite)).doubleValue();
    }

    public HtmlRtfFormattierend addiereKlaegerUnterliegenFor(int kl, boolean beiGesamtschuldnernMultiplizieren, boolean zusaetzlichesGesamtschuldnerischesUnterliegenBeruecksichtigen) {
        return this.getStreitwertFor(kl).subtract(this.getUnterliegenFor(kl, beiGesamtschuldnernMultiplizieren, zusaetzlichesGesamtschuldnerischesUnterliegenBeruecksichtigen));
    }

    @Deprecated
    public int zaehleBeteiligteFuerTyp(int beteiligtenTyp) {
        return this.zaehleBeteiligteFuerTyp(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp]);
    }

    private int zaehleBeteiligteFuerTyp(Beteiligter.BeteiligtenTyp typ) {
        int zwischen = 0;
        for (Beteiligter bb : this) {
            if (bb.getTyp() != typ) continue;
            ++zwischen;
        }
        return zwischen;
    }

    public int zaehleKlaeger() {
        int zwischen = this.zaehleBeteiligteFuerTyp(Beteiligter.BeteiligtenTyp.KLAEGER);
        return zwischen;
    }

    public int zaehleBeklagte() {
        int zwischen = this.zaehleBeteiligteFuerTyp(Beteiligter.BeteiligtenTyp.BEKLAGTE);
        return zwischen;
    }

    public int zaehleDrittwiderbeklagte() {
        int zwischen = this.zaehleBeteiligteFuerTyp(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE);
        return zwischen;
    }

    public int zaehleAnWiderklageBeteiligte(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        int anzahl = 0;
        for (BaumbachBeteiligter bbt : this) {
            if (!bbt.isAnWiderklageBeteiligt() || beteiligtenTyp != null && beteiligtenTyp != bbt.getTyp()) continue;
            ++anzahl;
        }
        return anzahl;
    }

    @Deprecated
    public int zaehleAnWiderklageBeteiligte(int beteiligtenTyp) {
        return this.zaehleAnWiderklageBeteiligte(beteiligtenTyp < 0 ? null : Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp]);
    }

    public int zaehleAnWiderklageBeteiligte() {
        return this.zaehleAnWiderklageBeteiligte(-1);
    }

    public boolean istReihenfolgeEingehalten() {
        boolean zwischen = true;
        int highest = 0;
        for (Beteiligter bb : this) {
            if (bb.getTyp().ordinal() > highest) {
                highest = bb.getTyp().ordinal();
                continue;
            }
            if (bb.getTyp().ordinal() >= highest) continue;
            zwischen = false;
        }
        return zwischen;
    }

    public boolean enthaeltAnWiderklageBeteiligte() {
        return this.zaehleAnWiderklageBeteiligte() > 0;
    }

    public boolean enthaeltGesamtschuldner() {
        return this.zaehleGesamtschuldner() > 0;
    }

    @Deprecated
    public int[] minUndMax(int beteiligtenTyp2) {
        Beteiligter.BeteiligtenTyp beteiligtenTyp = Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp2];
        return this.minUndMax(beteiligtenTyp);
    }

    public int[] minUndMax(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        int[] minMax = new int[2];
        int[] parteien = new int[]{this.zaehleKlaeger(), this.zaehleDrittwiderbeklagte(), this.zaehleBeklagte()};
        switch (beteiligtenTyp) {
            case KLAEGER: {
                minMax[0] = 0;
                minMax[1] = parteien[Beteiligter.BeteiligtenTyp.KLAEGER.ordinal()] - 1;
                break;
            }
            case DRITTWIDERBEKLAGTE: {
                minMax[0] = parteien[Beteiligter.BeteiligtenTyp.KLAEGER.ordinal()];
                minMax[1] = parteien[Beteiligter.BeteiligtenTyp.KLAEGER.ordinal()] + parteien[Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal()] - 1;
                break;
            }
            case BEKLAGTE: {
                minMax[0] = parteien[Beteiligter.BeteiligtenTyp.KLAEGER.ordinal()] + parteien[Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal()];
                minMax[1] = parteien[Beteiligter.BeteiligtenTyp.KLAEGER.ordinal()] + parteien[Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal()] + parteien[Beteiligter.BeteiligtenTyp.BEKLAGTE.ordinal()] - 1;
                break;
            }
            default: {
                minMax = null;
            }
        }
        return minMax;
    }

    public String parteiBezeichner(Beteiligter.Casus casus, int index) {
        int laufendeNummer = this.ermittleLaufendeNummerFuerBeteiligtenTyp(index);
        boolean einzigerSeinerArt = this.isEinzigerSeinerArt(index);
        return ((BaumbachBeteiligter)this.get(index)).parteiBezeichner(casus, laufendeNummer, einzigerSeinerArt);
    }

    @Deprecated
    public String parteiBezeichner(int casus, int index) {
        return this.parteiBezeichner(Beteiligter.Casus.values()[casus], index);
    }

    public int ermittleLaufendeNummerFuerBeteiligtenTyp(int index) {
        return index + 1 - this.minUndMax(this.getTypFor(index))[0];
    }

    public Beteiligter.GenusNumerus getGenusNumerusFor(int index) {
        return ((BaumbachBeteiligter)this.get(index)).getGenusNumerus();
    }

    @Deprecated
    public Beteiligter ermittleGenusNumerusForAll(int typ2) {
        Beteiligter.BeteiligtenTyp typ = Beteiligter.BeteiligtenTyp.values()[typ2];
        return this.ermittleGenusNumerusForAll(typ);
    }

    public Beteiligter ermittleGenusNumerusForAll(Beteiligter.BeteiligtenTyp typ) {
        Beteiligter bt = new Beteiligter(typ, Beteiligter.GenusNumerus.MAENNLICH_SINGULAR);
        if (this.size() > 0 && this.size() < 2) {
            bt.setGenusNumerus(this.getGenusNumerusFor(0));
        } else {
            Beteiligter.GenusNumerus genus = Beteiligter.GenusNumerus.MAENNLICH_PLURAL;
            boolean maenner = false;
            for (BaumbachBeteiligter bb : this) {
                if (bb.getGenusNumerus().getGenus() != Beteiligter.GenusNumerus.Genus.MAENNLICH) continue;
                maenner = true;
            }
            if (!maenner) {
                genus = Beteiligter.GenusNumerus.WEIBLICH_PLURAL;
            }
            bt.setGenusNumerus(genus);
            bt.setLfdNr(genus.ordinal());
        }
        return bt;
    }

    public Beteiligter.BeteiligtenTyp getTypFor(int index) {
        return ((BaumbachBeteiligter)this.get(index)).getTyp();
    }

    public Euro getStreitwertFor(int index) {
        return ((BaumbachBeteiligter)this.get(index)).getAntrag();
    }

    public Euro getUnterliegenFor(int index, boolean beiGesamtschuldnernMultiplizieren, boolean zusaetzlichesGesamtschuldnerischesUnterliegenBeruecksichtigen) {
        Euro unterliegen;
        Euro euro = unterliegen = beiGesamtschuldnernMultiplizieren ? this.getGanzesUnterliegen(index) : ((BaumbachBeteiligter)this.get(index)).getErfolg();
        if (zusaetzlichesGesamtschuldnerischesUnterliegenBeruecksichtigen) {
            unterliegen = unterliegen.add(this.getZusaetzlichesUnterliegen(index));
        }
        return unterliegen;
    }

    public boolean isGesamtschuldnerschaft(int index) {
        return ((BaumbachBeteiligter)this.get(index)).isGesamtschuldnerschaft();
    }

    public boolean isAnWiderklageBeteiligt(int index) {
        return ((BaumbachBeteiligter)this.get(index)).isAnWiderklageBeteiligt();
    }

    public boolean isEinzelpersonUndAnWiderklageBeteiligt(int index) {
        return this.isAnWiderklageBeteiligt(index) && !this.isGesamtschuldnerschaft(index);
    }

    public Euro getHoechstenStreitwert(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        Euro hoechster = Euro.ZERO_CENTS;
        for (BaumbachBeteiligter bbt : this) {
            if (bbt.getTyp() != beteiligtenTyp || !bbt.getAntrag().greaterThan(Euro.ZERO_CENTS) || !bbt.getAntrag().greaterThan(hoechster)) continue;
            hoechster = bbt.getAntrag();
        }
        return hoechster;
    }

    @Deprecated
    public double getHoechstenStreitwert(int beteiligtenTyp) {
        return this.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp]).doubleValue();
    }

    public ArrayList<Integer> findeGesamtschuldnerIndices(Beteiligter.BeteiligtenTyp beteiligtenTyp, boolean gesamtschuldnerisch) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int index = 0;
        while (index < this.size()) {
            if (((BaumbachBeteiligter)this.get(index)).isGesamtschuldnerschaft() == gesamtschuldnerisch && this.getTypFor(index) == beteiligtenTyp) {
                indices.add(index);
            }
            ++index;
        }
        return indices;
    }

    @Deprecated
    public ArrayList<Integer> findeGesamtschuldnerIndices(int beteiligtenTyp, boolean gesamtschuldnerisch) {
        return this.findeGesamtschuldnerIndices(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp], gesamtschuldnerisch);
    }

    public ArrayList<Integer> beteiligteInTenorReihenfolge(boolean klaegerVorBeklagten) {
        Beteiligter.BeteiligtenTyp[] typen;
        Beteiligter.BeteiligtenTyp[] beteiligtenTypArray;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (klaegerVorBeklagten) {
            Beteiligter.BeteiligtenTyp[] beteiligtenTypArray2 = new Beteiligter.BeteiligtenTyp[3];
            beteiligtenTypArray2[0] = Beteiligter.BeteiligtenTyp.KLAEGER;
            beteiligtenTypArray2[1] = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
            beteiligtenTypArray = beteiligtenTypArray2;
            beteiligtenTypArray2[2] = Beteiligter.BeteiligtenTyp.BEKLAGTE;
        } else {
            Beteiligter.BeteiligtenTyp[] beteiligtenTypArray3 = new Beteiligter.BeteiligtenTyp[3];
            beteiligtenTypArray3[0] = Beteiligter.BeteiligtenTyp.BEKLAGTE;
            beteiligtenTypArray3[1] = Beteiligter.BeteiligtenTyp.KLAEGER;
            beteiligtenTypArray = beteiligtenTypArray3;
            beteiligtenTypArray3[2] = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
        }
        Beteiligter.BeteiligtenTyp[] beteiligtenTypArray4 = typen = beteiligtenTypArray;
        int n = typen.length;
        int n2 = 0;
        while (n2 < n) {
            Beteiligter.BeteiligtenTyp typ = beteiligtenTypArray4[n2];
            boolean[] blArray = new boolean[2];
            blArray[0] = true;
            boolean[] blArray2 = blArray;
            int n3 = blArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block10: {
                    Beteiligter.BeteiligtenTyp t;
                    ArrayList<Integer> zwischen;
                    boolean gesamtschuldnerisch;
                    block8: {
                        block9: {
                            gesamtschuldnerisch = blArray2[n4];
                            zwischen = null;
                            t = typ;
                            if (!gesamtschuldnerisch) break block8;
                            if (typ != Beteiligter.BeteiligtenTyp.KLAEGER) break block9;
                            t = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
                            break block8;
                        }
                        if (typ == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE) break block10;
                    }
                    if ((zwischen = this.findeGesamtschuldnerIndices(t, gesamtschuldnerisch)).size() > 0) {
                        indices.addAll(zwischen);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return indices;
    }

    public ArrayList<Integer> beteiligteWieVerklagt() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Beteiligter.BeteiligtenTyp[] beteiligtenTypArray = new Beteiligter.BeteiligtenTyp[]{Beteiligter.BeteiligtenTyp.BEKLAGTE, Beteiligter.BeteiligtenTyp.KLAEGER, Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE};
        int n = beteiligtenTypArray.length;
        int n2 = 0;
        while (n2 < n) {
            Beteiligter.BeteiligtenTyp typ = beteiligtenTypArray[n2];
            int index = 0;
            while (index < this.size()) {
                if (this.getTypFor(index) == typ && !this.isGesamtschuldnerschaft(index)) {
                    if (typ == Beteiligter.BeteiligtenTyp.BEKLAGTE || typ == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE) {
                        indices.add(new Integer(index));
                    }
                    if (typ == Beteiligter.BeteiligtenTyp.KLAEGER && this.isAnWiderklageBeteiligt(index)) {
                        indices.add(new Integer(index));
                    }
                }
                ++index;
            }
            ++n2;
        }
        return indices;
    }

    public boolean hatDarueberHinaus(int index) {
        ArrayList<Integer> liste = this.findeDarueberHinaus(index);
        return liste != null && liste.size() > 0;
    }

    public ArrayList<Integer> findeDarueberHinaus(int index) {
        ArrayList<Integer> liste = new ArrayList<Integer>();
        if (this.get(index) instanceof BaumbachGesamtschuldnerschaft) {
            for (int i : this.findeGesamtschuldnerIndices(((BaumbachBeteiligter)this.get(index)).getTyp(), true)) {
                BaumbachGesamtschuldnerschaft derGrosse = this.getAlsGesamtschuldner(i);
                BaumbachGesamtschuldnerschaft derKleine = this.getAlsGesamtschuldner(index);
                if (derGrosse.getAufzaehlung().length <= derKleine.getAufzaehlung().length) continue;
                boolean alleEnthalten = true;
                int[] nArray = derKleine.getAufzaehlung();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int mitglied = nArray[n2];
                    BaumbachBeteiligtenListe mitglieder = derKleine.getBaumbachBeteiligtenListe();
                    if (!derGrosse.contains(mitglieder.getTypFor(mitglied), mitglieder.ermittleLaufendeNummerFuerBeteiligtenTyp(mitglied))) {
                        alleEnthalten = false;
                    }
                    ++n2;
                }
                if (!alleEnthalten) continue;
                liste.add(new Integer(i));
            }
        } else {
            Beteiligter.BeteiligtenTyp obertyp = ((BaumbachBeteiligter)this.get(index)).getTyp();
            if (obertyp == Beteiligter.BeteiligtenTyp.KLAEGER) {
                obertyp = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
            }
            for (int i : this.findeGesamtschuldnerIndices(obertyp, true)) {
                if (!((BaumbachGesamtschuldnerschaft)this.get(i)).contains(((BaumbachBeteiligter)this.get(index)).getTyp(), this.ermittleLaufendeNummerFuerBeteiligtenTyp(index))) continue;
                liste.add(new Integer(i));
            }
        }
        return liste;
    }

    @Deprecated
    public BaumbachGesamtschuldnerschaft extrahiereGesamtschuldnerschaft(int beteiligtenTyp) {
        return this.extrahiereGesamtschuldnerschaft(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp]);
    }

    public BaumbachGesamtschuldnerschaft extrahiereGesamtschuldnerschaft(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        int i2;
        ArrayList<Integer> eingangsListe;
        Beteiligter.BeteiligtenTyp typ;
        ArrayList<Integer> ausgabeListe = new ArrayList<Integer>();
        int maenner = 0;
        int frauen = 0;
        Euro sockelbetrag = Euro.ZERO_CENTS;
        boolean widerklageDabei = false;
        Beteiligter.BeteiligtenTyp beteiligtenTyp2 = typ = beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER ? (typ = Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE) : beteiligtenTyp;
        if (typ == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE) {
            eingangsListe = this.findeGesamtschuldnerIndices(Beteiligter.BeteiligtenTyp.KLAEGER, false);
            eingangsListe.addAll(this.findeGesamtschuldnerIndices(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE, false));
        } else {
            eingangsListe = this.findeGesamtschuldnerIndices(beteiligtenTyp, false);
        }
        for (int i2 : eingangsListe) {
            Euro zwischen = ((BaumbachBeteiligter)this.get(i2)).getErfolg();
            if (sockelbetrag.compareTo(Euro.ZERO_CENTS) <= 0) {
                sockelbetrag = zwischen;
                continue;
            }
            if (!zwischen.greaterThan(Euro.ZERO_CENTS) || !zwischen.lessThan(sockelbetrag)) continue;
            sockelbetrag = zwischen;
        }
        if (sockelbetrag.compareTo(Euro.ZERO_CENTS) <= 0) {
            return null;
        }
        for (int i2 : eingangsListe) {
            BaumbachBeteiligter bb = (BaumbachBeteiligter)this.get(i2);
            if (bb.getErfolg().compareTo(sockelbetrag) < 0) continue;
            ausgabeListe.add(i2);
            if (bb.getGenusNumerus() == Beteiligter.GenusNumerus.MAENNLICH_SINGULAR || bb.getGenusNumerus() == Beteiligter.GenusNumerus.MAENNLICH_PLURAL) {
                ++maenner;
            } else {
                ++frauen;
            }
            if (beteiligtenTyp == Beteiligter.BeteiligtenTyp.BEKLAGTE || !bb.isAnWiderklageBeteiligt()) continue;
            widerklageDabei = true;
        }
        if (ausgabeListe.size() < 2) {
            return null;
        }
        Kostenrechner.getLogger().info(String.format("Size: %d.", ausgabeListe.size()));
        for (int i2 : ausgabeListe) {
            ((BaumbachBeteiligter)this.get(i2)).setErfolg(((BaumbachBeteiligter)this.get(i2)).getErfolg().subtract(sockelbetrag));
        }
        int[] indices = new int[ausgabeListe.size()];
        i2 = 0;
        while (i2 < ausgabeListe.size()) {
            indices[i2] = (Integer)ausgabeListe.get(i2);
            ++i2;
        }
        Beteiligter.GenusNumerus genusNumerus = frauen > maenner ? Beteiligter.GenusNumerus.WEIBLICH_PLURAL : Beteiligter.GenusNumerus.MAENNLICH_PLURAL;
        return new BaumbachGesamtschuldnerschaft(typ, genusNumerus, sockelbetrag, widerklageDabei, indices, this);
    }

    public String benenneAngriffGegen(int index) {
        return String.format(ANGRIFFS_NAME, this.parteiBezeichner(Beteiligter.Casus.NOMINATIV, this.findeAngreiferVon(index)), this.parteiBezeichner(Beteiligter.Casus.AKKUSATIV, index), this.getStreitwertFor(index));
    }

    int zaehleRichtigeBeteiligte() {
        return this.size() - this.zaehleGesamtschuldner();
    }

    int zaehleGesamtschuldner() {
        int anzahl = 0;
        for (BaumbachBeteiligter bbt : this) {
            if (!bbt.isGesamtschuldnerschaft()) continue;
            ++anzahl;
        }
        return anzahl;
    }

    BaumbachBeteiligtenListe alleBeteiligtenEinesTyps(int beteiligtenTyp) {
        if (this.zaehleBeteiligteFuerTyp(beteiligtenTyp) <= 0) {
            return new BaumbachBeteiligtenListe();
        }
        int[] fromTo = this.minUndMax(beteiligtenTyp);
        return new BaumbachBeteiligtenListe(this.subList(fromTo[0], fromTo[1]));
    }

    String parteiBezeichnerListe(Beteiligter.Casus casus, int[] indexes) {
        String zwischen = "";
        Beteiligter.BeteiligtenTyp typ = null;
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (this.getTypFor(index) != typ) {
                zwischen = String.valueOf(zwischen) + Beteiligter.parteiBezeichner(this.getTypFor(index), Beteiligter.GenusNumerus.of(this.getGenusNumerusFor(index).getGenus(), this.isEinzigerSeinerArt(index) ? Beteiligter.GenusNumerus.Numerus.SINGULAR : Beteiligter.GenusNumerus.Numerus.PLURAL), -1, casus, true);
            }
            typ = this.getTypFor(index);
            if (!this.isEinzigerSeinerArt(index)) {
                zwischen = String.valueOf(zwischen) + Beteiligter.fuegeLaufendeNummerHinzu(this.ermittleLaufendeNummerFuerBeteiligtenTyp(index));
            }
            zwischen = String.valueOf(zwischen) + ", ";
            ++n2;
        }
        return TenorTexter.undStattKomma(TenorTexter.letztesKommaWeg(zwischen.replace("  ", " ")));
    }

    @Deprecated
    String parteiBezeichnerListe(int casus, int[] indexes) {
        return this.parteiBezeichnerListe(Beteiligter.Casus.values()[casus], indexes);
    }

    boolean isEinzigerSeinerArt(int index) {
        return this.findeGesamtschuldnerIndices(this.getTypFor(index), false).size() < 2;
    }

    boolean isEinzigerSeinerArt(Beteiligter beteiligter) {
        return this.contains(beteiligter) && this.findeGesamtschuldnerIndices(beteiligter.getTyp(), false).size() < 2;
    }

    String kurzBezeichnerListe(Beteiligter.Casus casus, int[] indexes) {
        String liste = "";
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            liste = String.valueOf(liste) + ((BaumbachBeteiligter)this.get(index)).kurzBezeichner(casus) + (this.zaehleBeteiligteFuerTyp(this.getTypFor(index)) > 1 ? "-" + this.ermittleLaufendeNummerFuerBeteiligtenTyp(index) : "") + ", ";
            ++n2;
        }
        return TenorTexter.letztesKommaWeg(liste);
    }

    @Deprecated
    String kurzBezeichnerListe(int casus, int[] indexes) {
        return this.kurzBezeichnerListe(Beteiligter.Casus.values()[casus], indexes);
    }

    int findeAngreiferVon(int index) {
        int ergebnis = -1;
        switch (this.getTypFor(index)) {
            case KLAEGER: {
                if (!this.isAnWiderklageBeteiligt(index)) {
                    return -1;
                }
                int i = 0;
                while (i < this.size()) {
                    if (this.getTypFor(i) == Beteiligter.BeteiligtenTyp.BEKLAGTE && this.isAnWiderklageBeteiligt(i)) {
                        ergebnis = i;
                    }
                    ++i;
                }
                return ergebnis;
            }
            case DRITTWIDERBEKLAGTE: {
                int i = 0;
                while (i < this.size()) {
                    if (this.getTypFor(i) == Beteiligter.BeteiligtenTyp.BEKLAGTE && this.isAnWiderklageBeteiligt(i)) {
                        ergebnis = i;
                    }
                    ++i;
                }
                return ergebnis;
            }
            case BEKLAGTE: {
                int i = 0;
                while (i < this.size()) {
                    if (this.getTypFor(i) == Beteiligter.BeteiligtenTyp.KLAEGER) {
                        ergebnis = i;
                    }
                    ++i;
                }
                return ergebnis;
            }
        }
        return ergebnis;
    }

    private Euro getGanzesUnterliegen(int index) {
        Euro unterliegen = ((BaumbachBeteiligter)this.get(index)).getErfolg();
        if (((BaumbachBeteiligter)this.get(index)).isGesamtschuldnerschaft()) {
            unterliegen = unterliegen.multiply(Double.valueOf(this.getAlsGesamtschuldner(index).getAnzahl()));
        }
        return unterliegen;
    }

    private Euro getZusaetzlichesUnterliegen(int index) {
        Euro unterliegen = Euro.ZERO_CENTS;
        BaumbachBeteiligter beteiligter = (BaumbachBeteiligter)this.get(index);
        if (beteiligter.isGesamtschuldnerschaft()) {
            return unterliegen;
        }
        for (BaumbachBeteiligter bbt : this) {
            if (!bbt.isGesamtschuldnerschaft() || !((BaumbachGesamtschuldnerschaft)bbt).contains(beteiligter.getTyp(), this.ermittleLaufendeNummerFuerBeteiligtenTyp(index))) continue;
            unterliegen = unterliegen.add(bbt.getErfolg());
        }
        return unterliegen;
    }
}

