/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.EuroAdapter;
import eu.gronos.kostenrechner.interfaces.AntragErfolgElement;
import eu.gronos.kostenrechner.interfaces.Hinzufuegbar;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class BaumbachBeteiligter
extends Beteiligter
implements Serializable,
Hinzufuegbar,
AntragErfolgElement {
    public static final String UND_WK_WBK = "und %s";
    public static final String PARTEI_UND_WK_WBK = "%s und %s";
    public static final String[] WIDERBEKLAGTEN_BEUGUNG = new String[]{"Widerbeklagter", "Widerbeklagte"};
    public static final String[] WIDERKLAEGER_BEUGUNG = new String[]{"Widerkl\u00e4ger", "Widerkl\u00e4gerin"};
    private static final long serialVersionUID = -3484780882204159173L;
    private Euro antrag;
    private Euro erfolg;
    private boolean anWiderklageBeteiligt;

    public BaumbachBeteiligter(Beteiligter.BeteiligtenTyp typ, Beteiligter.GenusNumerus genusNumerus, Euro streitwert, Euro unterliegen, boolean anWiderklageBeteiligt) {
        super(typ, genusNumerus);
        this.antrag = streitwert;
        this.erfolg = unterliegen;
        this.anWiderklageBeteiligt = anWiderklageBeteiligt;
    }

    public BaumbachBeteiligter(Beteiligter beteiligter, Euro streitwert, Euro unterliegen, boolean anWiderklageBeteiligt) {
        super(beteiligter);
        this.antrag = streitwert;
        this.erfolg = unterliegen;
        this.anWiderklageBeteiligt = anWiderklageBeteiligt;
    }

    public BaumbachBeteiligter() {
    }

    @Override
    @XmlAttribute(name="streitwert")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getAntrag() {
        return this.antrag;
    }

    @Override
    public void setAntrag(Euro antrag) {
        this.antrag = antrag;
    }

    @Override
    @XmlAttribute(name="unterliegen")
    @XmlJavaTypeAdapter(value=EuroAdapter.class)
    public Euro getErfolg() {
        return this.erfolg;
    }

    @Override
    public void setErfolg(Euro unterliegen) {
        this.erfolg = unterliegen;
    }

    @XmlAttribute(name="widerklage")
    public boolean isAnWiderklageBeteiligt() {
        return this.anWiderklageBeteiligt;
    }

    public void setAnWiderklageBeteiligt(boolean anWiderklageBeteiligt) {
        this.anWiderklageBeteiligt = this.getTyp() == Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE ? true : anWiderklageBeteiligt;
    }

    public boolean isGesamtschuldnerschaft() {
        return false;
    }

    @Override
    public String getId() {
        if (this.getTyp() == null) {
            return null;
        }
        return "" + this.getTyp().kurz() + this.getTempNr();
    }

    @Override
    public String langBezeichnung() {
        return this.parteiBezeichner(Beteiligter.Casus.NOMINATIV, this.getLfdNr(), false);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString().replace("Beteiligter ", "BaumbachBeteiligter ").replace("]", ", "));
        builder.append("streitwert=");
        builder.append(this.antrag);
        builder.append(", unterliegen=");
        builder.append(this.erfolg);
        builder.append(", anWiderklageBeteiligt=");
        builder.append(this.anWiderklageBeteiligt);
        builder.append("]");
        return builder.toString();
    }
}

