/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.baumbach;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.logic.TenorToken;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;

public class MehrfachBeteiligter
extends Beteiligter {
    private static final long serialVersionUID = -2607492610898941487L;
    private List<Beteiligter> beteiligte;
    private final boolean gesamtschuldnerisch;

    public MehrfachBeteiligter(List<Beteiligter> beteiligte, boolean gesamtschuldnerisch) {
        this.setBeteiligte(beteiligte);
        this.gesamtschuldnerisch = gesamtschuldnerisch;
        this.setTyp(beteiligte.get(0).getTyp());
        Beteiligter.GenusNumerus.Numerus pl = beteiligte.size() > 1 ? Beteiligter.GenusNumerus.Numerus.PLURAL : Beteiligter.GenusNumerus.Numerus.SINGULAR;
        this.setGenusNumerus(Beteiligter.GenusNumerus.of(beteiligte.get(0).getGenusNumerus().getGenus(), pl));
    }

    public MehrfachBeteiligter() {
        this(new ArrayList<Beteiligter>(), false);
    }

    @Override
    public boolean isPlural() {
        return this.beteiligte.size() > 1;
    }

    public boolean isGesamtschuldnerschaft() {
        return this.gesamtschuldnerisch;
    }

    public boolean isGesamtschuldnerisch() {
        return this.gesamtschuldnerisch;
    }

    public int size() {
        return this.beteiligte.size();
    }

    public boolean listEquals(List<Beteiligter> other) {
        return this.beteiligte.equals(other);
    }

    @XmlElement(name="beteiligtenVerweis")
    @XmlIDREF
    public List<Beteiligter> getBeteiligte() {
        return new ArrayList<Beteiligter>(this.beteiligte);
    }

    @XmlAttribute(name="ids")
    public String getIds() {
        if (this.beteiligte == null || this.beteiligte.isEmpty()) {
            return null;
        }
        return this.beteiligte.stream().map(b -> b.getId()).collect(Collectors.joining(","));
    }

    @Override
    public String parteiBezeichner(Beteiligter.Casus casus, int laufendeNummer, boolean einzigerSeinerArt) {
        StringBuilder builder = new StringBuilder(MehrfachBeteiligter.parteiBezeichnerListe(this.beteiligte, this.beteiligte, casus));
        this.formatGesamtschuldner(builder);
        return builder.toString();
    }

    @Override
    public String kurzBezeichner(Beteiligter.Casus casus) {
        StringBuilder builder = new StringBuilder();
        for (Beteiligter bet : this.beteiligte) {
            builder.append(bet.kurzBezeichner(casus));
            builder.append(", ");
        }
        MehrfachBeteiligter.behandleKomma(builder);
        this.formatGesamtschuldner(builder);
        return builder.toString();
    }

    @Override
    public String langBezeichnung() {
        StringBuilder builder = new StringBuilder();
        for (Beteiligter bet : this.beteiligte) {
            builder.append(bet.langBezeichnung());
            builder.append(", ");
        }
        MehrfachBeteiligter.behandleKomma(builder);
        this.formatGesamtschuldner(builder);
        return builder.toString();
    }

    static CharSequence kurzBezeichnerListe(List<Beteiligter> alleBeteiligte, List<Beteiligter> beteiligte, Beteiligter.Casus casus) {
        StringBuilder builder = new StringBuilder();
        Beteiligter.BeteiligtenTyp typ = null;
        for (Beteiligter bet : beteiligte) {
            if (bet.getTyp() != typ) {
                typ = bet.getTyp();
                builder.append(bet.kurzBezeichner(casus));
            }
            if (!MehrfachBeteiligter.istEinzigerSeinerArt(bet, alleBeteiligte)) {
                builder.append('-');
                builder.append(bet.getLfdNr());
            }
            builder.append(", ");
        }
        MehrfachBeteiligter.behandleKomma(builder);
        return builder;
    }

    private static void behandleKomma(StringBuilder builder) {
        int pos2;
        builder.deleteCharAt(builder.lastIndexOf(","));
        builder.deleteCharAt(builder.lastIndexOf(TenorToken.LEER.toString()));
        int pos = builder.lastIndexOf(",");
        if (pos > -1) {
            builder.replace(pos, pos + 1, " und");
        }
        if ((pos2 = builder.lastIndexOf("  ")) > -1) {
            builder.replace(pos2, pos2 + 2, TenorToken.LEER.toString());
        }
    }

    private void formatGesamtschuldner(StringBuilder builder) {
        if (this.isGesamtschuldnerisch()) {
            builder.append(String.valueOf(TenorToken.LEER.toString()) + TenorToken.GESAMTSCHULDNERISCH);
        }
    }

    private void setBeteiligte(List<Beteiligter> beteiligte) {
        this.beteiligte = new ArrayList<Beteiligter>();
        if (beteiligte != null && beteiligte.size() > 0) {
            this.beteiligte.addAll(beteiligte);
        }
    }

    public static boolean istEinzigerSeinerArt(Beteiligter beteiligter, List<Beteiligter> beteiligte) {
        Beteiligter.BeteiligtenTyp typ = beteiligter.getTyp();
        int count = 0;
        for (Beteiligter b : beteiligte) {
            if (b.getTyp() != typ) continue;
            ++count;
        }
        return count < 2;
    }

    public static CharSequence parteiBezeichnerListe(List<Beteiligter> alleBeteiligte, List<Beteiligter> beteiligte, Beteiligter.Casus casus) {
        StringBuilder builder = new StringBuilder();
        Beteiligter.BeteiligtenTyp typ = null;
        for (Beteiligter bet : beteiligte) {
            if (bet.getTyp() != typ) {
                typ = bet.getTyp();
                boolean istEinzigerSeinerArt = MehrfachBeteiligter.istEinzigerSeinerArt(bet, alleBeteiligte);
                Beteiligter.GenusNumerus.Numerus pl = MehrfachBeteiligter.istEinzigerSeinerArt(bet, beteiligte) ? Beteiligter.GenusNumerus.Numerus.SINGULAR : Beteiligter.GenusNumerus.Numerus.PLURAL;
                builder.append(Beteiligter.parteiBezeichner(typ, Beteiligter.GenusNumerus.of(bet.getGenusNumerus().getGenus(), pl), bet.getLfdNr(), casus, istEinzigerSeinerArt));
            } else {
                builder.append(MehrfachBeteiligter.fuegeLaufendeNummerHinzu(bet.getLfdNr()));
            }
            builder.append(", ");
        }
        MehrfachBeteiligter.behandleKomma(builder);
        return builder;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.beteiligte == null ? 0 : this.beteiligte.hashCode());
        result = 31 * result + (this.gesamtschuldnerisch ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MehrfachBeteiligter)) {
            return false;
        }
        MehrfachBeteiligter other = (MehrfachBeteiligter)obj;
        if (this.beteiligte == null ? other.beteiligte != null : !this.getIds().equals(other.getIds())) {
            return false;
        }
        return this.gesamtschuldnerisch == other.gesamtschuldnerisch;
    }

    public static Beteiligter from(List<Beteiligter> beteiligte, boolean gesamtschuldnerisch) {
        if (beteiligte == null || beteiligte.size() < 1) {
            return null;
        }
        if (beteiligte.size() == 1) {
            return beteiligte.get(0);
        }
        return new MehrfachBeteiligter(beteiligte, gesamtschuldnerisch);
    }
}

