/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.forderungen;

import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.OptionalEuroAdapter;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class AufrechnungsForderung
extends Forderung {
    private static final long serialVersionUID = 4494763842223765977L;
    private static final String BESCHREIBUNG = "Hilfsaufrechnung";
    private Optional<Euro> effektiverWert = Optional.empty();
    private Optional<Euro> effektiverErfolg = Optional.empty();

    public AufrechnungsForderung(boolean gegenforderung, Euro wert, Euro erfolg) throws IllegalArgumentException {
        super(gegenforderung, wert, erfolg);
    }

    public AufrechnungsForderung(Euro wert, Euro erfolg) throws IllegalArgumentException {
        this(true, wert, erfolg);
    }

    public AufrechnungsForderung() {
        super.setGegenforderung(true);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(", effektiverWert=");
        builder.append(this.effektiverWert);
        builder.append(", effektiverErfolg=");
        builder.append(this.effektiverErfolg);
        StringBuilder superBuilder = new StringBuilder(super.toString().replace("Forderung ", "AufrechnungsForderung "));
        superBuilder.insert(superBuilder.lastIndexOf("]"), builder);
        return superBuilder.toString();
    }

    @Override
    public String getBeschreibung() {
        return BESCHREIBUNG;
    }

    @XmlAttribute(name="effektivWert")
    @XmlJavaTypeAdapter(value=OptionalEuroAdapter.class)
    public Optional<Euro> getEffektiverWert() {
        return this.effektiverWert;
    }

    public void setEffektiverWert(Euro euro) {
        this.effektiverWert = euro == null || euro.lessThan(Euro.ZERO_CENTS) ? Optional.empty() : Optional.of(euro);
    }

    public void setEffektiverWert(Optional<Euro> effektiverWert) {
        this.effektiverWert = effektiverWert;
    }

    public void setzeEffektivenWertZurueck() {
        this.setEffektiverWert(Optional.empty());
    }

    @XmlAttribute(name="effErfolg")
    @XmlJavaTypeAdapter(value=OptionalEuroAdapter.class)
    public Optional<Euro> getEffektiverErfolg() {
        return this.effektiverErfolg;
    }

    public void setEffektiverErfolg(Euro euro) {
        this.effektiverErfolg = euro == null || euro.lessThan(Euro.ZERO_CENTS) ? Optional.empty() : Optional.of(euro);
    }

    public void setEffektiverErfolg(Optional<Euro> effektiverErfolg) {
        this.effektiverErfolg = effektiverErfolg;
    }

    public void setzeEffektivenErfolgZurueck() {
        this.setEffektiverErfolg(Optional.empty());
    }
}

