/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GerichtsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import java.util.ArrayList;

public class GebuehrenAuflistung
extends ArrayList<GebuehrenTatbestand> {
    private static final long serialVersionUID = 6564487211842926610L;

    public static Euro errechneGebuehr(GebuehrenTatbestand gt, Euro streitwert) {
        if (gt != null && gt instanceof AuslagenTatbestand) {
            return ((AuslagenTatbestand)gt).getBetrag();
        }
        if (gt != null && gt instanceof PauschalTatbestand) {
            return ((PauschalTatbestand)gt).getBetrag();
        }
        if (gt != null && gt instanceof GebuehrenSatzTatbestand) {
            return GebuehrenAuflistung.findeGebuehrenTabelle(gt).errechneGebuehr(streitwert, ((GebuehrenSatzTatbestand)gt).getSatz());
        }
        return Euro.ofCents(0L);
    }

    public Euro errechneGebuehrenSumme(Euro streitwert) {
        Euro summe = Euro.ofCents(0L);
        for (GebuehrenTatbestand gt : this) {
            summe = summe.add(GebuehrenAuflistung.errechneGebuehr(gt, streitwert));
        }
        return summe;
    }

    public Euro errechneGebuehrenSummeMitSteuer(Euro streitwert) {
        Euro summe = Euro.ofCents(0L);
        Euro rvgsumme = Euro.ofCents(0L);
        for (GebuehrenTatbestand gt : this) {
            if (gt instanceof MehrwertsteuerTatbestand) {
                MehrwertsteuerTatbestand mwst = (MehrwertsteuerTatbestand)gt;
                summe = summe.add(mwst.errechneSteuer(rvgsumme));
                if (!mwst.isIsoliert()) continue;
                rvgsumme = Euro.ofCents(0L);
                continue;
            }
            summe = summe.add(GebuehrenAuflistung.errechneGebuehr(gt, streitwert));
            if (gt.getGebuehrenKlasse() != AnwaltsGebuehrenTabelle.class) continue;
            rvgsumme = rvgsumme.add(GebuehrenAuflistung.errechneGebuehr(gt, streitwert));
        }
        return summe;
    }

    private static GebuehrenTabelle findeGebuehrenTabelle(GebuehrenTatbestand gt) {
        if (AnwaltsGebuehrenTabelle.class.equals(gt.getGebuehrenKlasse())) {
            return GebuehrenGesetzesSammlung.getRvg();
        }
        if (GerichtsGebuehrenTabelle.class.equals(gt.getGebuehrenKlasse())) {
            return GebuehrenGesetzesSammlung.getGkg();
        }
        return null;
    }
}

