/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGrundZeile;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenMapAdapter;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenVerzeichnis;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenZeile;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Wertgebuehren", namespace="http://www.kostentenor.de/gebuehren")
public class GebuehrenTabelle {
    private ArrayList<GebuehrenZeile> tabelle = new ArrayList();
    private GebuehrenVerzeichnis verzeichnis = new GebuehrenVerzeichnis();

    @XmlElements(value={@XmlElement(name="betraegtDieGebuehr", type=GebuehrenGrundZeile.class), @XmlElement(name="gebuehrErhoehtSichBei", type=GebuehrenZeile.class)})
    public ArrayList<GebuehrenZeile> getTabelle() {
        return this.tabelle;
    }

    public void setTabelle(ArrayList<GebuehrenZeile> tabelle) throws IllegalArgumentException {
        if (!this.istReihenfolgeEingehalten(tabelle)) {
            throw new IllegalArgumentException("Die erste Zeile muss eine GebuehrenGrundZeile sein. Keine der weiteren Zeilen darf eine GebuehrenGrundZeile sein.");
        }
        this.tabelle = tabelle;
    }

    @XmlJavaTypeAdapter(value=GebuehrenMapAdapter.class)
    public GebuehrenVerzeichnis getVerzeichnis() {
        return this.verzeichnis;
    }

    public void setVerzeichnis(GebuehrenVerzeichnis verzeichnis) {
        this.verzeichnis = verzeichnis;
    }

    /*
     * Unable to fully structure code
     */
    public Euro errechneGebuehr(Euro streitwert) {
        zwischenGebuehr = Euro.ofEuros(0.0);
        zwischenStreitWert = Euro.ofEuros(0.0);
        for (GebuehrenZeile zeile : this.getTabelle()) {
            block2: {
                if (!(zeile instanceof GebuehrenGrundZeile)) ** GOTO lbl11
                grund = (GebuehrenGrundZeile)zeile;
                zwischenGebuehr = grund.getHoehe();
                zwischenStreitWert = grund.getSprung();
                break block2;
lbl-1000:
                // 1 sources

                {
                    zwischenGebuehr = zwischenGebuehr.add(zeile.getHoehe());
                    zwischenStreitWert = zwischenStreitWert.add(zeile.getSprung());
lbl11:
                    // 2 sources

                    ** while (zwischenStreitWert.compareTo((Euro)zeile.getGrenze()) <= 0 && zwischenStreitWert.add((Euro)zeile.getHoehe()).compareTo((Euro)zeile.getGrenze()) <= 0 && zwischenStreitWert.add((Euro)zeile.getHoehe()).compareTo((Euro)streitwert) <= 0)
                }
            }
            if (zwischenStreitWert.add(zeile.getHoehe()).compareTo(streitwert) >= 0) break;
        }
        return zwischenGebuehr;
    }

    public Euro errechneGebuehr(Euro streitwert, double faktor) {
        return this.errechneGebuehr(streitwert).multiply(faktor);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ArrayList<Euro> errechneStreitwertListe() {
        liste = new ArrayList<Euro>();
        streitwert = Euro.ofCents(0L);
        for (GebuehrenZeile zeile : this.getTabelle()) {
            if (!(zeile instanceof GebuehrenGrundZeile)) ** GOTO lbl13
            grund = (GebuehrenGrundZeile)zeile;
            streitwert = grund.getSprung();
            liste.add(streitwert);
            continue;
lbl-1000:
            // 1 sources

            {
                streitwert = streitwert.add(zeile.getSprung());
                liste.add(streitwert);
lbl13:
                // 2 sources

                ** while (streitwert.compareTo((Euro)zeile.getGrenze()) <= 0 && streitwert.add((Euro)zeile.getHoehe()).compareTo((Euro)zeile.getGrenze()) <= 0)
            }
lbl14:
            // 1 sources

        }
        System.out.print("Streitwerte: ");
        for (HtmlRtfFormattierend euro : liste) {
            System.out.print(euro + " ");
        }
        return liste;
    }

    public GebuehrenTabelle readFromStream(InputStream stream) throws NullPointerException {
        if (stream == null) {
            throw new NullPointerException("Der InputStream f\u00fcr die angegebene Resource darf nicht null sein.");
        }
        GebuehrenTabelle tab = JAXB.unmarshal(stream, GebuehrenTabelle.class);
        return tab;
    }

    protected void setFromStream(InputStream stream) throws NullPointerException, IllegalArgumentException {
        GebuehrenTabelle tab = this.readFromStream(stream);
        this.setTabelle(tab.getTabelle());
        this.setVerzeichnis(tab.getVerzeichnis());
    }

    protected ArrayList<GebuehrenZeile> readTabelleFromStream(InputStream stream) throws NullPointerException {
        GebuehrenTabelle tab = this.readFromStream(stream);
        return tab.getTabelle();
    }

    private boolean istReihenfolgeEingehalten(ArrayList<GebuehrenZeile> tabelle) {
        if (tabelle == null || tabelle.size() < 2) {
            return false;
        }
        if (!(tabelle.get(0) instanceof GebuehrenGrundZeile)) {
            return false;
        }
        int index = 1;
        while (index < tabelle.size()) {
            if (tabelle.get(index) instanceof GebuehrenGrundZeile) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

