/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GerichtsGebuehrenTabelle;
import eu.gronos.kostenrechner.interfaces.Hinzufuegbar;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"vorschrift", "bezeichnung"})
public abstract class GebuehrenTatbestand
implements Serializable,
Hinzufuegbar {
    private static final String ZIFF = "Ziff.";
    private static final String KV_GKG = "KV GKG";
    private static final String VV_RVG = "VV RVG";
    private static final long serialVersionUID = -7148753363484353653L;
    private String vorschrift;
    private String bezeichnung;
    private Class<? extends GebuehrenTabelle> gebuehrenKlasse;

    public GebuehrenTatbestand(String vorschrift, String bezeichnung, Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        this.vorschrift = vorschrift;
        this.bezeichnung = bezeichnung;
        this.gebuehrenKlasse = gebuehrenKlasse;
    }

    public GebuehrenTatbestand() {
    }

    @XmlAttribute(name="vorschrift")
    public String getVorschrift() {
        if (this.vorschrift == null) {
            this.repairVorschrift();
        }
        return this.vorschrift;
    }

    public void setVorschrift(String vorschrift) {
        this.vorschrift = vorschrift;
    }

    @XmlAttribute(name="bezeichnung")
    public String getBezeichnung() {
        return this.bezeichnung;
    }

    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }

    @XmlAttribute(name="gesetz")
    public Class<? extends GebuehrenTabelle> getGebuehrenKlasse() {
        return this.gebuehrenKlasse;
    }

    public void setGebuehrenKlasse(Class<? extends GebuehrenTabelle> gebuehrenKlasse) {
        this.gebuehrenKlasse = gebuehrenKlasse;
        if (this.gebuehrenKlasse == null) {
            this.repairClass();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bezeichnung == null ? 0 : this.bezeichnung.hashCode());
        result = 31 * result + (this.gebuehrenKlasse == null ? 0 : this.gebuehrenKlasse.hashCode());
        result = 31 * result + (this.vorschrift == null ? 0 : this.vorschrift.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GebuehrenTatbestand)) {
            return false;
        }
        GebuehrenTatbestand other = (GebuehrenTatbestand)obj;
        if (this.bezeichnung == null ? other.bezeichnung != null : !this.bezeichnung.equals(other.bezeichnung)) {
            return false;
        }
        if (this.gebuehrenKlasse == null ? other.gebuehrenKlasse != null : !this.gebuehrenKlasse.equals(other.gebuehrenKlasse)) {
            return false;
        }
        return !(this.vorschrift == null ? other.vorschrift != null : !this.vorschrift.equals(other.vorschrift));
    }

    @Override
    public String langBezeichnung() {
        String gesetz = "";
        if (this.gebuehrenKlasse == AnwaltsGebuehrenTabelle.class) {
            gesetz = " RVG";
        } else if (this.gebuehrenKlasse == GerichtsGebuehrenTabelle.class) {
            gesetz = " GKG";
        }
        return String.format("%s (%s%s)", this.getBezeichnung(), this.getVorschrift(), gesetz);
    }

    public String toString() {
        return String.format("GebuehrenTatbestand [vorschrift=%s, bezeichnung=%s, gebuehrenKlasse=%s]", this.vorschrift, this.bezeichnung, this.gebuehrenKlasse);
    }

    private void repairClass() {
        if (this.bezeichnung != null) {
            if (this.bezeichnung.contains(VV_RVG)) {
                this.gebuehrenKlasse = AnwaltsGebuehrenTabelle.class;
            } else if (this.bezeichnung.contains(KV_GKG)) {
                this.gebuehrenKlasse = GerichtsGebuehrenTabelle.class;
            }
        } else if (this.vorschrift != null) {
            if (this.vorschrift.contains("VV")) {
                this.gebuehrenKlasse = AnwaltsGebuehrenTabelle.class;
            } else if (this.vorschrift.contains("KV")) {
                this.gebuehrenKlasse = GerichtsGebuehrenTabelle.class;
            }
        }
    }

    private void repairVorschrift() {
        if ((this.vorschrift == null || this.vorschrift.isEmpty()) && this.bezeichnung != null && (this.bezeichnung.contains(KV_GKG) || this.bezeichnung.contains(VV_RVG)) && this.bezeichnung.contains(ZIFF)) {
            String substring = this.bezeichnung.substring(this.bezeichnung.indexOf(ZIFF) + ZIFF.length()).trim();
            if (substring.contains(" (")) {
                substring = substring.substring(0, substring.indexOf(" ("));
            }
            this.vorschrift = substring;
        }
    }
}

