/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import javax.xml.bind.annotation.XmlAttribute;

public class MehrwertsteuerTatbestand
extends GebuehrenTatbestand {
    private static final long serialVersionUID = -8164105788751809714L;
    public static final String ART = "Umsatzsteuer";
    private double steuerSatz;
    private boolean isoliert;

    MehrwertsteuerTatbestand(String vorschrift, String bezeichnung, double steuerSatz, Class<? extends GebuehrenTabelle> gebuehrenKlasse) throws IllegalArgumentException {
        this(vorschrift, bezeichnung, steuerSatz, false, gebuehrenKlasse);
    }

    MehrwertsteuerTatbestand(String vorschrift, String bezeichnung, double steuerSatz, boolean isoliert, Class<? extends GebuehrenTabelle> gebuehrenKlasse) throws IllegalArgumentException {
        super(vorschrift, bezeichnung, gebuehrenKlasse);
        if (!(steuerSatz >= 0.0) || !(steuerSatz < 1.0)) {
            throw new IllegalArgumentException("Der steuerSatz muss >= 0.0 und < 1.0 sein.");
        }
        this.steuerSatz = steuerSatz;
        this.isoliert = isoliert;
    }

    public MehrwertsteuerTatbestand() {
    }

    @XmlAttribute(name="satz")
    public double getSteuerSatz() {
        return this.steuerSatz;
    }

    public void setSteuerSatz(double steuerSatz) throws IllegalArgumentException {
        if (!(steuerSatz >= 0.0) || !(steuerSatz < 1.0)) {
            throw new IllegalArgumentException("Der steuerSatz muss >= 0.0 und < 1.0 sein.");
        }
        this.steuerSatz = steuerSatz;
    }

    @XmlAttribute(name="reset")
    public boolean isIsoliert() {
        return this.isoliert;
    }

    public void setIsoliert(boolean isoliert) {
        this.isoliert = isoliert;
    }

    @Override
    public String toString() {
        String strIsoliert = this.isIsoliert() ? "; mit anschlie\u00dfendem Zur\u00fccksetzen der Summe" : "";
        return String.format("GebuehrenTatbestand [vorschrift=%s, bezeichnung=%s, gebuehrenKlasse=%s, steuerSatz=%s%s]", this.getVorschrift(), this.getBezeichnung(), this.getGebuehrenKlasse(), this.steuerSatz, strIsoliert);
    }

    public Euro errechneSteuer(Euro summe) {
        return summe.multiply(this.getSteuerSatz());
    }
}

