/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.Calculable;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Euro
extends Number
implements Comparable<Euro>,
Calculable<Euro, Double>,
HtmlRtfFormattierend {
    private static final String EURO_ZERO_CENT_FORMAT = "%,d,00";
    private static final String EURO_CENT_FORMAT = "%,d,%02d";
    private static final long serialVersionUID = -6454236365619266897L;
    private static final long CENTS_PER_EURO = 100L;
    private static final double CENTS_PER_EURO_DOUBLE = 100.0;
    private static final long MAX_CACHE_EUROS = 30000000L;
    private static final ConcurrentMap<Long, Euro> POOL = new ConcurrentHashMap<Long, Euro>();
    public static final Euro ZERO_CENTS = Euro.ofCents(0L);
    private final long cents;

    private Euro(long cents) {
        this.cents = cents;
    }

    @Override
    public int intValue() {
        return (int)(this.getCents() / 100L);
    }

    @Override
    public long longValue() {
        return this.getCents() / 100L;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return (double)this.getCents() / 100.0;
    }

    public static Euro ofEuros(double euros) {
        return Euro.ofCents((long)(euros * 100.0));
    }

    public static Euro ofCents(long cents) {
        long euros;
        if (cents >= 0L && cents % 100L == 0L && (euros = cents / 100L) <= 30000000L) {
            return POOL.computeIfAbsent(euros, e -> new Euro(cents));
        }
        return new Euro(cents);
    }

    static Euro ofEuros(int euros) {
        return Euro.ofCents((long)euros * 100L);
    }

    public static Euro ofEuros(long euros) {
        return Euro.ofCents(euros * 100L);
    }

    public static Euro of(long euros, int cents) {
        if (cents < 0 || (long)cents >= 100L) {
            throw new IllegalArgumentException("Cents m\u00fcssen im Bereich 0-99 cent liegen, waren aber: " + cents);
        }
        return Euro.ofCents(euros * 100L + (long)cents);
    }

    static Euro valueOf(String value) {
        value = value.trim();
        String komma = ",";
        if (value.contains(",")) {
            int pos = value.indexOf(",");
            Long euros = Long.valueOf(value.substring(0, pos));
            int end = value.length();
            long multi = 1L;
            if (end - pos - 1 > 2) {
                end = pos + 3;
            } else if (end - pos - 1 == 1) {
                multi = 10L;
            } else if (end - pos - 1 < 1) {
                return new Euro(100L * euros);
            }
            Long cents = Long.valueOf(value.substring(pos + 1, end));
            return new Euro(100L * euros + multi * cents);
        }
        return Euro.ofEuros(Double.valueOf(value));
    }

    public long getCents() {
        return this.cents;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getCents() ^ this.getCents() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Euro) {
            return this.getCents() == ((Euro)obj).getCents();
        }
        return false;
    }

    @Override
    public int compareTo(Euro anotherEuro) {
        return this.getCents() < anotherEuro.getCents() ? -1 : (this.getCents() == anotherEuro.getCents() ? 0 : 1);
    }

    @Override
    public HtmlRtfFormattierend add(long cents) {
        return Euro.ofCents(this.getCents() + cents);
    }

    @Override
    public Euro add(Euro euro) {
        return Euro.ofCents(this.getCents() + euro.getCents());
    }

    public String toString() {
        return String.format(EURO_CENT_FORMAT, this.longValue(), this.remainingCents());
    }

    @Override
    public String toRtfString() {
        return String.valueOf(this.toString()) + "\\~\u20ac";
    }

    @Override
    public String toHtmlString() {
        return String.valueOf(this.toString()) + "\u00a0\u20ac";
    }

    private long remainingCents() {
        return this.getCents() % 100L;
    }

    @Override
    public Double divide(Euro divisor) {
        if (divisor == null || divisor.getCents() == 0L) {
            return Double.NaN;
        }
        return (double)this.getCents() / (double)divisor.getCents();
    }

    public Fraction divideAsFraction(Euro divisor) {
        return Fraction.valueOf(this.getCents(), divisor.getCents());
    }

    @Override
    public Euro subtract(Euro subtrahend) {
        return Euro.ofCents(this.getCents() - subtrahend.getCents());
    }

    @Override
    public Euro multiply(Double factor) {
        return Euro.ofCents((long)((double)this.getCents() * factor));
    }

    @Override
    public Euro multiply(Fraction factor) {
        return Euro.ofCents(Fraction.valueOf(this.getCents(), 1L).multiply(factor).longValue());
    }

    public static String formatRealEuros(long euros) {
        return String.format(EURO_ZERO_CENT_FORMAT, euros);
    }

    @Override
    public Euro max(Euro other) {
        return this.getCents() > other.getCents() ? this : other;
    }

    public static Euro max(Euro a, Euro b) {
        if (a == null || b == null) {
            return null;
        }
        return a.getCents() >= b.getCents() ? a : b;
    }

    public static Euro min(Euro a, Euro b) {
        if (a == null || b == null) {
            return null;
        }
        return a.getCents() <= b.getCents() ? a : b;
    }

    @Override
    public boolean greaterThan(Euro other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean lessThan(Euro other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean greaterThanOrEqualTo(Euro other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public boolean lessThanOrEqualTo(Euro other) {
        return this.compareTo(other) <= 0;
    }

    public static boolean undefined(Euro euro) {
        return euro == null || euro.getCents() < 0L;
    }
}

