/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.interfaces.Calculable;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlID;

public class Fraction
extends Number
implements Comparable<Fraction>,
Calculable<Fraction, Fraction>,
HtmlRtfFormattierend {
    private static final long serialVersionUID = 3162722941330446595L;
    private static final String BRUCHSTRICH = "/";
    private final long numerator;
    private final long denominator;
    public static final Fraction ZERO = new Fraction(0L, 1L);
    public static final Fraction ONE = new Fraction(1L, 1L);
    private static final Map<Long, Map<Long, Fraction>> POOL = new HashMap<Long, Map<Long, Fraction>>();
    private static final Map<Fraction, String> UNICODE_MAP = new HashMap<Fraction, String>();

    static {
        HashMap<Long, Fraction> map = new HashMap<Long, Fraction>();
        map.put(0L, ZERO);
        UNICODE_MAP.put(ZERO, "0");
        map.put(1L, ONE);
        UNICODE_MAP.put(ONE, "1");
        POOL.put(1L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 2L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u00bd");
        POOL.put(2L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 3L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u2153");
        map.put(2L, new Fraction(2L, 3L));
        UNICODE_MAP.put((Fraction)map.get(2L), "\u2154");
        POOL.put(3L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 4L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u00bc");
        map.put(3L, new Fraction(3L, 4L));
        UNICODE_MAP.put((Fraction)map.get(3L), "\u00be");
        POOL.put(4L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 5L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u2155");
        map.put(2L, new Fraction(2L, 5L));
        UNICODE_MAP.put((Fraction)map.get(2L), "\u2156");
        map.put(3L, new Fraction(3L, 5L));
        UNICODE_MAP.put((Fraction)map.get(3L), "\u2157");
        map.put(4L, new Fraction(4L, 5L));
        UNICODE_MAP.put((Fraction)map.get(4L), "\u2158");
        POOL.put(5L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 6L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u2159");
        map.put(5L, new Fraction(5L, 6L));
        UNICODE_MAP.put((Fraction)map.get(5L), "\u215a");
        POOL.put(6L, map);
        map = new HashMap();
        map.put(1L, new Fraction(1L, 8L));
        UNICODE_MAP.put((Fraction)map.get(1L), "\u215b");
        map.put(3L, new Fraction(3L, 8L));
        UNICODE_MAP.put((Fraction)map.get(3L), "\u215c");
        map.put(5L, new Fraction(5L, 8L));
        UNICODE_MAP.put((Fraction)map.get(5L), "\u215d");
        map.put(7L, new Fraction(7L, 8L));
        UNICODE_MAP.put((Fraction)map.get(7L), "\u215e");
        POOL.put(8L, map);
        Object var0 = null;
    }

    private Fraction(long numerator, long denominator) {
        if (denominator == 0L) {
            throw new ArithmeticException("denominator of a fraction must not be zero.");
        }
        if (denominator < 0L) {
            numerator = -numerator;
            denominator = -denominator;
        }
        if (denominator == 1L) {
            this.numerator = numerator;
            this.denominator = 1L;
        } else {
            long gcd = Fraction.greatestCommonDivisor(numerator, denominator);
            this.numerator = numerator / gcd;
            this.denominator = denominator / gcd;
        }
    }

    public double toPercent() {
        return 100.0 * this.doubleValue();
    }

    public String toPercentString() {
        return String.format("%.2f%%", this.toPercent());
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public static Fraction valueOf(double d) {
        long whole = (long)d;
        BigDecimal decimal = BigDecimal.valueOf(Math.abs(d) - (double)Math.abs(whole));
        int scale = decimal.scale();
        byte[] array = Fraction.digits(decimal, scale);
        Fraction f = scale > 3 ? Fraction.infiniteDecimalExpansion(decimal, scale, array).orElse(Fraction.finiteDecimal(decimal, scale)) : Fraction.finiteDecimal(decimal, scale);
        if (whole > 0L) {
            return new Fraction(whole, 1L).add(f);
        }
        if (whole < 0L) {
            return new Fraction(whole, 1L).subtract(f);
        }
        return f;
    }

    public static Fraction valueOf(long numerator, long denominator) {
        Fraction f;
        if (denominator == 0L) {
            throw new ArithmeticException("Denominator must not be zero!");
        }
        Fraction fraction = new Fraction(numerator, denominator);
        Map<Long, Fraction> inner = POOL.get(fraction.denominator);
        if (inner != null && (f = inner.get(fraction.numerator)) != null) {
            return f;
        }
        return fraction;
    }

    public static Fraction valueOf(String s) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("String is null or empty");
        }
        if ((s = s.trim()).contains(BRUCHSTRICH)) {
            String[] parts = s.split(BRUCHSTRICH);
            if (parts.length != 2) {
                throw new NumberFormatException("Invalid fraction: " + s);
            }
            long numerator = Integer.parseInt(parts[0].trim());
            long denominator = Integer.parseInt(parts[1].trim());
            return Fraction.valueOf(numerator, denominator);
        }
        if (s.endsWith("%")) {
            String numberPart = s.substring(0, s.length() - 1).trim().replace(",", ".");
            try {
                return Fraction.valueOf(Double.parseDouble(numberPart) / 100.0);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Ung\u00fcltiges Prozentformat: " + s, e);
            }
        }
        try {
            return Fraction.valueOf(Double.parseDouble(s.replace(",", ".")));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Kann String nicht in Fraction umwandeln: " + s, e);
        }
    }

    private static Optional<Fraction> infiniteDecimalExpansion(BigDecimal decimal, int scale, byte[] array) {
        int begin = Fraction.afterLeadingZeros(array);
        if (begin == -1) {
            return Optional.empty();
        }
        int end = Fraction.findPeriodFrom(array, begin);
        while (end < begin && begin < array.length) {
            end = Fraction.findPeriodFrom(array, ++begin);
        }
        if (begin < array.length && end >= begin) {
            if (begin > 0) {
                return Optional.of(Fraction.infiniteDecimalExpansion(Arrays.copyOfRange(array, 0, begin), Arrays.copyOfRange(array, begin, end + 1)));
            }
            return Optional.of(Fraction.infiniteDecimalExpansion(Arrays.copyOfRange(array, 0, end + 1)));
        }
        return Optional.empty();
    }

    private static Fraction infiniteDecimalExpansion(byte[] beforePeriod, byte[] period) {
        long pow1 = (long)Math.pow(10.0, beforePeriod.length);
        long pow2 = (long)Math.pow(10.0, period.length) - 1L;
        long denominator = pow1 * pow2;
        long numerator = pow2 * Fraction.combineDigits(beforePeriod) + Fraction.combineDigits(period);
        return new Fraction(numerator, denominator);
    }

    private static Fraction infiniteDecimalExpansion(byte[] period) {
        long numerator = Fraction.combineDigits(period);
        long denominator = (long)Math.pow(10.0, period.length) - 1L;
        return new Fraction(numerator, denominator);
    }

    private static Fraction finiteDecimal(BigDecimal decimal, int scale) {
        Fraction f = Fraction.valueOf(decimal.scaleByPowerOfTen(scale).longValue(), BigDecimal.TEN.pow(scale).longValue());
        return f;
    }

    private static int findPeriodFrom(byte[] array, int begin) {
        int end = begin;
        while (end < array.length) {
            if (end >= array.length - 1) {
                return -1;
            }
            byte[] period = Arrays.copyOfRange(array, begin, end + 1);
            if (Fraction.isPeriodic(array, period, end + 1)) {
                return end;
            }
            ++end;
        }
        return -1;
    }

    private static boolean isPeriodic(byte[] array, byte[] period, int begin) {
        int i = begin;
        while (i < array.length) {
            byte[] periodToCompare;
            int end = begin + period.length <= array.length - 1 ? begin + period.length : array.length;
            byte[] remainingPart = Arrays.copyOfRange(array, begin, end);
            byte[] byArray = periodToCompare = remainingPart.length < period.length ? Arrays.copyOfRange(period, 0, remainingPart.length) : period;
            if (!Arrays.equals(remainingPart, periodToCompare)) {
                return false;
            }
            i += period.length;
        }
        return true;
    }

    private static int afterLeadingZeros(byte[] array) {
        int begin = 0;
        while (array[begin] == 0) {
            if (++begin <= array.length - 1) continue;
            return -1;
        }
        return begin;
    }

    private static byte[] digits(BigDecimal remainder, int scale) {
        BigDecimal base = BigDecimal.TEN;
        byte[] bs = new byte[scale];
        int i = 0;
        while (i < scale) {
            byte vorKomma;
            bs[i] = vorKomma = remainder.multiply(base).byteValue();
            remainder = remainder.multiply(base).subtract(BigDecimal.valueOf(vorKomma));
            ++i;
        }
        return bs;
    }

    private static long combineDigits(byte[] bytes) {
        BigInteger base = BigInteger.TEN;
        BigInteger result = BigInteger.ZERO;
        int i = 0;
        while (i < bytes.length) {
            result = result.multiply(base);
            result = result.add(BigInteger.valueOf(bytes[i]));
            ++i;
        }
        return result.longValue();
    }

    private static long greatestCommonDivisor(long a, long b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).longValue();
    }

    private static long lowestCommonMultiple(long denominator1, long denominator2) {
        if (denominator1 == 0L && denominator2 == 0L) {
            throw new ArithmeticException("Es d\u00fcrfen nicht beide Nenner == 0 sein!");
        }
        return BigInteger.valueOf(denominator1).multiply(BigInteger.valueOf(denominator2)).divide(BigInteger.valueOf(Fraction.greatestCommonDivisor(denominator1, denominator2))).longValue();
    }

    public Fraction approx(long maxDenominator) {
        if (this.denominator <= maxDenominator) {
            return this;
        }
        long bestNumerator = this.numerator;
        long bestDenominator = this.denominator;
        double bestError = Double.MAX_VALUE;
        double value = this.doubleValue();
        long denom = 1L;
        while (denom <= maxDenominator) {
            double approx;
            double error;
            long numer = Math.round(value * (double)denom);
            if (numer != 0L && (error = Math.abs((approx = (double)numer / (double)denom) - value)) < bestError) {
                bestNumerator = numer;
                bestDenominator = denom;
                bestError = error;
            }
            ++denom;
        }
        if (bestNumerator == 0L || bestDenominator > maxDenominator) {
            return this;
        }
        return new Fraction(bestNumerator, bestDenominator);
    }

    @Override
    public Fraction max(Fraction other) {
        return this.compareTo(other) > 0 ? this : other;
    }

    @Override
    public int intValue() {
        return (int)(this.numerator / this.denominator);
    }

    @Override
    public long longValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @XmlID
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.denominator ^ this.denominator >>> 32);
        result = 31 * result + (int)(this.numerator ^ this.numerator >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(Fraction other) {
        return Long.compare(this.numerator * other.denominator, other.numerator * this.denominator);
    }

    public String toString() {
        return this.numerator == 0L ? "0" : (this.denominator == 1L ? "" + this.numerator : String.valueOf(this.numerator) + BRUCHSTRICH + this.denominator);
    }

    @Override
    public String toHtmlString() {
        if (UNICODE_MAP.containsKey(this)) {
            return UNICODE_MAP.get(this);
        }
        return "<html><sup><small>" + this.numerator + "</small></sup>&frasl;<sub><small>" + this.denominator + "</small></sub></html>";
    }

    @Override
    public String toRtfString() {
        if (UNICODE_MAP.containsKey(this)) {
            return UNICODE_MAP.get(this);
        }
        return "{\\super " + this.numerator + "}\\'2f{\\sub " + this.denominator + "}";
    }

    @Override
    public Fraction add(Fraction summand) {
        return Fraction.add(this.numerator, this.denominator, summand.numerator, summand.denominator);
    }

    private static Fraction add(long firstNumerator, long firstDenomitator, long secondNumerator, long secondDenomitator) {
        long lCM = Fraction.lowestCommonMultiple(firstDenomitator, secondDenomitator);
        return new Fraction(firstNumerator * lCM / firstDenomitator + secondNumerator * lCM / secondDenomitator, lCM);
    }

    @Override
    public Fraction subtract(Fraction subtrahend) {
        return Fraction.add(this.numerator, this.denominator, -subtrahend.numerator, subtrahend.denominator);
    }

    private static Fraction multiply(long firstNumerator, long firstDenomitator, long secondNumerator, long secondDenomitator) {
        return new Fraction(firstNumerator * secondNumerator, firstDenomitator * secondDenomitator);
    }

    @Override
    public Fraction multiply(Fraction factor) {
        return Fraction.multiply(this.numerator, this.denominator, factor.numerator, factor.denominator);
    }

    @Override
    public Fraction divide(Fraction divisor) {
        return Fraction.multiply(this.numerator, this.denominator, divisor.denominator, divisor.numerator);
    }

    @Override
    public boolean greaterThan(Fraction other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean lessThan(Fraction other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean greaterThanOrEqualTo(Fraction other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public boolean lessThanOrEqualTo(Fraction other) {
        return this.compareTo(other) <= 0;
    }
}

