/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class FractionAdapter
extends XmlAdapter<String, Fraction> {
    @Override
    public Fraction unmarshal(String v) throws Exception {
        if (v == null || v.isEmpty()) {
            return null;
        }
        if ((v = v.trim()).contains("/")) {
            String[] parts = v.split("/");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Ung\u00fcltiger Bruch: " + v);
            }
            long numerator = Long.parseLong(parts[0]);
            long denominator = Long.parseLong(parts[1]);
            return Fraction.valueOf(numerator, denominator);
        }
        double parsed = Double.parseDouble(v);
        if (parsed >= -1.0 && parsed <= 1.0) {
            return Fraction.valueOf(parsed);
        }
        return Fraction.valueOf(Math.round(parsed), 100L);
    }

    @Override
    public String marshal(Fraction v) throws Exception {
        return v.toString();
    }
}

