/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;

public abstract class ProzessVerhaeltnis
implements Comparable<ProzessVerhaeltnis> {
    static final int INT_PROZESS = 0;
    static final int INT_HAUPTSACHE = 1;
    static final int INT_KOSTEN = 2;
    static final int INT_VOLLSTRECKUNG = 3;
    private Beteiligter glaeubiger;
    private Beteiligter schuldner;
    private boolean darueberHinaus;

    public ProzessVerhaeltnis() {
    }

    public ProzessVerhaeltnis(Beteiligter glaeubiger, Beteiligter schuldner, boolean darueberHinaus) {
        this();
        this.glaeubiger = glaeubiger;
        this.schuldner = schuldner;
        this.darueberHinaus = darueberHinaus;
    }

    @XmlElement(name="glaeubiger", type=Beteiligter.class)
    @XmlIDREF
    public Beteiligter getGlaeubiger() {
        return this.glaeubiger;
    }

    public void setGlaeubiger(Beteiligter glaeubiger) {
        this.glaeubiger = glaeubiger;
    }

    @XmlElement(name="schuldner", type=Beteiligter.class)
    @XmlIDREF
    public Beteiligter getSchuldner() {
        return this.schuldner;
    }

    public void setSchuldner(Beteiligter schuldner) {
        this.schuldner = schuldner;
    }

    @XmlAttribute(name="darueberHinaus")
    public boolean isDarueberHinaus() {
        return this.darueberHinaus;
    }

    public void setDarueberHinaus(boolean darueberHinaus) {
        this.darueberHinaus = darueberHinaus;
    }

    @Override
    public int compareTo(ProzessVerhaeltnis other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.getClass() != other.getClass()) {
            return new Integer(this.intForClass(this)).compareTo(new Integer(this.intForClass(other)));
        }
        if (this.getGlaeubiger().equals(other.getGlaeubiger())) {
            return this.getSchuldner().compareTo(other.getSchuldner());
        }
        return this.getGlaeubiger().compareTo(other.getGlaeubiger());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProzessVerhaeltnis anderesPV = (ProzessVerhaeltnis)obj;
        return this.getGlaeubiger().equals(anderesPV.getGlaeubiger()) && this.getSchuldner().equals(anderesPV.getSchuldner());
    }

    public String toString() {
        String darueber = "";
        if (this.isDarueberHinaus()) {
            darueber = " dar\u00fcber hinaus";
        }
        return String.format("%s gegen %s%s", this.getGlaeubiger().parteiBezeichner(Beteiligter.Casus.GENITIV, this.getGlaeubiger().getLfdNr(), false), this.getSchuldner().parteiBezeichner(Beteiligter.Casus.AKKUSATIV, this.getSchuldner().getLfdNr(), false), darueber);
    }

    protected int intForClass(ProzessVerhaeltnis verhaeltnis) {
        if (verhaeltnis instanceof VollstreckungsVerhaeltnis) {
            return 3;
        }
        if (verhaeltnis instanceof KostenTragungsVerhaeltnis) {
            return 2;
        }
        if (verhaeltnis instanceof HauptsacheVerhaeltnis) {
            return 1;
        }
        return 0;
    }
}

