/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Dateikopf;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlRootElement(name="SchustersKleinerKostenTenorXML", namespace="http://www.kostentenor.de/")
public class VerfahrensDatenContainer {
    @XmlElement(name="programminfo")
    public Dateikopf dateikopf = new Dateikopf();
    @XmlElement(name="allgemein")
    public Allgemein allgemein = new Allgemein();
    @XmlElement(name="teilklageruecknahme")
    public Teilklageruecknahme teilklageruecknahme = new Teilklageruecknahme();
    @XmlElement(name="streitgenossen")
    public Streitgenossen streitgenossen = new Streitgenossen();
    @XmlElement(name="forderungsstaffelung")
    public ForderungsStaffelung staffelung = new ForderungsStaffelung();
    @XmlElement(name="gebuehrenberechnung")
    public GebuehrenBerechnung gebuehrenBerechnung = new GebuehrenBerechnung();

    public VerfahrensDatenContainer() {
    }

    public VerfahrensDatenContainer(BaumbachBeteiligtenListe klaeger, BaumbachBeteiligtenListe drittwiderbeklagte, BaumbachBeteiligtenListe beklagte, Euro streitwert, String aktenzeichen, XMLGregorianCalendar speicherDatum) {
        this();
        this.streitgenossen.klaeger = klaeger;
        this.streitgenossen.drittwiderbeklagte = drittwiderbeklagte;
        this.streitgenossen.beklagte = beklagte;
        this.streitgenossen.widerklage = this.streitgenossen.gibtsDrittwiderbeklagte() || this.streitgenossen.gibtsKlaeger() && this.streitgenossen.klaeger.enthaeltAnWiderklageBeteiligte() || this.streitgenossen.gibtsBeklagte() && this.streitgenossen.beklagte.enthaeltAnWiderklageBeteiligte();
        this.allgemein.speicherdatum = speicherDatum;
        this.allgemein.aktenzeichen = aktenzeichen;
        this.allgemein.streitwert = streitwert;
        this.allgemein.selectedPanel = 1;
        this.kopiereBeteiligteAusStreitgenossen();
        this.alleStreitwerteHinauf();
    }

    public String createFileInfo() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (this.allgemein.speicherdatum != null) {
            gregorianCalendar = this.allgemein.speicherdatum.toGregorianCalendar();
        }
        return String.format("Datei-/Systeminfo [speicherdatum=%s, aktenzeichen=%s, version=%s, osName=%s, osArch=%s, osVersion=%s, javaVendor=%s, javaName=%s, javaVersion=%s]", DateFormat.getDateInstance(2, Locale.GERMAN).format(gregorianCalendar.getTime()), this.allgemein.aktenzeichen, this.dateikopf.version, this.dateikopf.osName, this.dateikopf.osArch, this.dateikopf.osVersion, this.dateikopf.javaVendor, this.dateikopf.javaName, this.dateikopf.javaVersion);
    }

    public void setzeStreitwertInAllgemein() {
        this.allgemein.streitwert = this.maxStreitwert();
    }

    private VerfahrensDatenContainer alleStreitwerteHinauf() {
        Euro streitwert = this.allgemein.streitwert;
        if (streitwert.compareTo(Euro.ZERO_CENTS) <= 0) {
            return this;
        }
        Teilklageruecknahme t = this.teilklageruecknahme;
        t.streitwerteUndObsiegen = new ArrayList<Euro>();
        t.streitwerteUndObsiegen.add(streitwert);
        t.streitwerteUndObsiegen.add(streitwert);
        t.streitwerteUndObsiegen.add(streitwert);
        this.gebuehrenBerechnung.streitwert = streitwert;
        return this;
    }

    private VerfahrensDatenContainer kopiereBeteiligteAusStreitgenossen() {
        BaumbachBeteiligtenListe klaegerseite = new BaumbachBeteiligtenListe();
        klaegerseite.addAll(this.streitgenossen.klaeger);
        if (this.streitgenossen.drittwiderbeklagte != null) {
            klaegerseite.addAll(this.streitgenossen.drittwiderbeklagte);
        }
        Beteiligter kl = klaegerseite.ermittleGenusNumerusForAll(Beteiligter.BeteiligtenTyp.KLAEGER);
        BaumbachBeteiligtenListe beklagtenseite = new BaumbachBeteiligtenListe();
        beklagtenseite.addAll(this.streitgenossen.beklagte);
        Beteiligter bk = beklagtenseite.ermittleGenusNumerusForAll(Beteiligter.BeteiligtenTyp.BEKLAGTE);
        ArrayList<Beteiligter> parteien = new ArrayList<Beteiligter>();
        parteien.add(kl);
        parteien.add(bk);
        this.teilklageruecknahme.parteien = parteien;
        this.staffelung.parteien = parteien;
        return this;
    }

    private Euro maxStreitwert() {
        return Euro.max(this.streitgenossen.klaeger.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.KLAEGER), Euro.max(this.streitgenossen.drittwiderbeklagte.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE), Euro.max(this.streitgenossen.beklagte.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.BEKLAGTE), Euro.max(this.gebuehrenBerechnung.streitwert, this.teilklageruecknahme.streitwerteUndObsiegen.get(0)))));
    }
}

