/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.data.tenordaten;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.util.VollstreckbarkeitsPruefer;
import javax.xml.bind.annotation.XmlAttribute;

public class Vollstreckbarkeit
implements Comparable<Vollstreckbarkeit> {
    private boolean b708 = false;
    private boolean b709s1 = false;
    private boolean b709s2 = false;
    private boolean b711 = false;
    private boolean b713 = false;
    private static final Euro GRENZE_708_11_HAUPTSACHE = Euro.ofEuros(1250);
    private static final Euro GRENZE_708_11_KOSTEN = Euro.ofEuros(1500);

    public Vollstreckbarkeit() {
    }

    public Vollstreckbarkeit(boolean b708, boolean b709s1, boolean b709s2, boolean b711, boolean b713) throws IllegalArgumentException {
        this();
        this.b708 = b708;
        this.b709s1 = b709s1;
        this.b709s2 = b709s2;
        this.b711 = b711;
        this.b713 = b713;
        new VollstreckbarkeitsPruefer().pruefeEingabe(this);
    }

    public Vollstreckbarkeit(Vollstreckbarkeit other) {
        this(other.isB708(), other.isB709s1(), other.isB709s2(), other.isB711(), other.isB713());
    }

    public static Vollstreckbarkeit pruefeSicherheitsleistung(Euro hauptsache, Euro kosten) throws IllegalArgumentException {
        if (Euro.ZERO_CENTS.equals(hauptsache) && Euro.ZERO_CENTS.equals(kosten)) {
            return new Vollstreckbarkeit();
        }
        if (hauptsache.greaterThan(GRENZE_708_11_HAUPTSACHE) || Euro.ZERO_CENTS.equals(hauptsache) && kosten.greaterThan(GRENZE_708_11_KOSTEN)) {
            return new Vollstreckbarkeit(false, true, true, false, false);
        }
        return new Vollstreckbarkeit(true, false, true, true, false);
    }

    @XmlAttribute(name="paragraf708")
    public boolean isB708() {
        return this.b708;
    }

    @XmlAttribute(name="paragraf709satz1")
    public boolean isB709s1() {
        return this.b709s1;
    }

    @XmlAttribute(name="paragraf709satz2")
    public boolean isB709s2() {
        return this.b709s2;
    }

    @XmlAttribute(name="paragraf711")
    public boolean isB711() {
        return this.b711;
    }

    @XmlAttribute(name="paragraf713")
    public boolean isB713() {
        return this.b713;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.b713 ? 1231 : 1237);
        result = 31 * result + (this.b709s1 ? 1231 : 1237);
        result = 31 * result + (this.b711 ? 1231 : 1237);
        result = 31 * result + (this.b708 ? 1231 : 1237);
        result = 31 * result + (this.b709s2 ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vollstreckbarkeit other = (Vollstreckbarkeit)obj;
        if (this.b713 != other.b713) {
            return false;
        }
        if (this.b709s1 != other.b709s1) {
            return false;
        }
        if (this.b711 != other.b711) {
            return false;
        }
        if (this.b708 != other.b708) {
            return false;
        }
        return this.b709s2 == other.b709s2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Vollstreckbarkeitsvorschriften: ");
        if (this.isB708()) {
            builder.append("\u00a7 708 ZPO");
        }
        if (this.isB709s1()) {
            builder.append("\u00a7 709 Satz 1 ZPO");
        }
        if (this.isB709s2()) {
            builder.append("\u00a7 709 Satz 2 ZPO");
        }
        if (this.isB711()) {
            builder.append("\u00a7 711 ZPO");
        }
        if (this.isB713()) {
            builder.append("\u00a7 713 ZPO");
        }
        return builder.toString().replace("ZPO\u00a7", "ZPO, \u00a7");
    }

    public boolean hatEintraege() {
        return this.isB708() || this.isB709s1() || this.isB709s2() || this.isB711() || this.isB713();
    }

    @Override
    public int compareTo(Vollstreckbarkeit other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isB713() != other.isB713()) {
            return this.isB713() ? -1 : 1;
        }
        if (this.isB709s1() != other.isB709s1()) {
            return this.isB709s1() ? -1 : 1;
        }
        if (this.isB711() != other.isB711()) {
            return this.isB711() ? -1 : 1;
        }
        if (this.isB708() != other.isB708()) {
            return this.isB708() ? -1 : 1;
        }
        if (this.isB709s2() != other.isB709s2()) {
            return this.isB709s2() ? -1 : 1;
        }
        return 0;
    }

    void setB708(boolean b708) {
        this.b708 = b708;
    }

    void setB709s1(boolean b709s1) {
        this.b709s1 = b709s1;
    }

    void setB709s2(boolean b709s2) {
        this.b709s2 = b709s2;
    }

    void setB711(boolean b711) {
        this.b711 = b711;
    }

    void setB713(boolean b713) {
        this.b713 = b713;
    }
}

