/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;
import eu.gronos.kostenrechner.logic.TenorToken;
import java.util.Arrays;
import java.util.List;

public abstract class TenorTexter<E extends UnterContainerKlasse> {
    public static final String KLAGEABWEISUNG = "Die Klage wird abgewiesen.";
    public static final String EURO_FORMAT = "%,.2f EUR";
    private static final GebuehrenAuflistung KOSTEN_KLAEGER = new GebuehrenAuflistung();
    private static final GebuehrenAuflistung KOSTEN_BEKLAGTER = new GebuehrenAuflistung();
    public static final String KOSTENENTSCHEIDUNG_92_II = "Die Kostenentscheidung beruht auf \u00a7 92 Abs. 1 ZPO.\n";
    public static final String KOSTENENTSCHEIDUNG_91_92_II = "Die Kostenentscheidung beruht auf \u00a7\u00a7 91, 92 Abs. 2 ZPO.\n";
    public static final String KOSTENENTSCHEIDUNG_91 = "Die Kostenentscheidung beruht auf \u00a7 91 ZPO.\n";
    public static final String GRUENDE_UEBERSCHRIFT = "Entscheidungsgr\u00fcnde\n";
    public static final String GRUENDE_UEBERSCHRIFT_IM_EINZELNEN = "Im Einzelnen\n";
    public static final String UND = " und ";
    public static final String KOMMA_LEER = ", ";
    public static final String HABEN = " haben ";
    public static final String HAT = " hat ";
    public static final String WERDEN = "werden";
    public static final String WIRD = "wird";
    public static final String FEHLER_FORDERUNG_LEER = "Die Liste der Forderungen darf nicht null oder leer sein!";
    public static final String FEHLER_REIHENFOLGE_FORDERUNGEN = "Die Reihenfolge (erst Klageforderungen, dann Aufrechnungsforderungen) ist nicht eingehalten!";
    public static final String FEHLER_REIHENFOLGE_STREITWERTE = "Der sp\u00e4tere Streitwert darf nicht gr\u00f6\u00dfer als der fr\u00fchere sein!";
    public static final String FEHLER_REIHENFOLGE_VERURTEILUNG = "Die Verurteilung darf nicht gr\u00f6\u00dfer als der sp\u00e4tere Streitwert sein!";
    public static final String FEHLER_GAR_NIX_PARTEIEN = "baumbachBeteiligtenListe darf nicht null und nicht leer sein!";
    public static final String FEHLER_NIX_PARTEIEN = "Die BaumbachBeteiligtenListe baumbachBeteiligtenListe muss mindestens einen KLAEGER und einen BEKLAGTEn enthalten!";
    public static final String FEHLER_NIX_WIDERBEKLAGTE = "Es wurde ein widerklagender Beklagter, aber kein widerbeklagter Kl\u00e4ger / Drittwiderbeklagter gefunden.";
    public static final String FEHLER_NIX_WIDERKLAEGER = "Es wurden widerbeklagte Kl\u00e4ger / Drittwiderbeklagte, aber kein widerklagender Beklagter gefunden.";
    public static final String FEHLER_NUR_EINER = "Derzeit wird nicht mehr als ein Kl\u00e4ger bzw. ein widerklagender Beklagter unterst\u00fctzt.";
    public static final String FEHLER_REIHENFOLGE_BETEILIGTE = "Die Beteiligten m\u00fcssen in der Reihenfolge Kl\u00e4ger, Drittwiderbeklagte (sofern vorhanden), Beklagte \u00fcbergeben werden. \nBitte Programmierer benachrichtigen!";
    public static final String STREITWERT_KLAGE_WIDERKLAGE = "Der Streitwert wird auf %,.2f EUR, f\u00fcr die Klage auf %,.2f EUR, f\u00fcr die Widerklage auf %,.2f EUR festgesetzt.%n";
    public static final String STREITWERT_KLAGE = "Der Streitwert wird auf %,.2f EUR festgesetzt.%n";
    public static final String STREITWERTFESTSETZUNG_FORMAT = "Der Streitwert wird auf %,.2f EUR bis zum ..., danach auf %,.2f EUR festgesetzt.%n";
    public static final String STREITWERT_FESTGESETZT_EINFACH = "Der Streitwert wird auf %,.2f EUR festgesetzt.%n";
    public static final String STREITWERT_FESTGESETZT_EUR = "Der Streitwert wird auf %s EUR festgesetzt.%n";
    public static final String STREITWERT_FESTGESETZT_VERGANGENHEIT = "Der Streitwert wurde auf %s EUR festgesetzt.%n";
    public static final String ZU_TRAGEN = " zu tragen.\n";
    public static final String PARTEI_ZU_PROZENT = "%s zu %,.2f%%, ";
    public static final String PARTEI_PROZENT_OHNE = "%s %,.2f%%, ";
    public static final String KOSTENTRAGUNG_SELBST = "Im \u00dcbrigen haben die Parteien ihre au\u00dfergerichtlichen Kosten selbst zu tragen.\n";
    public static final String AUSSERGERICHTLICHE_KOSTEN_TEIL = ", die au\u00dfergerichtlichen Kosten ";
    public static final String DIE_AUSSERG_KOSTEN = "Die au\u00dfergerichtlichen Kosten %s haben ";
    public static final String DIE_GERICHTSKOSTEN_HABEN = "Die Gerichtskosten haben ";
    public static final String DIE_GERICHTSKOSTEN = "Die Gerichtskosten";
    public static final String DIE_KOSTEN_DES_RECHTSSTREITS_HABEN = "Die Kosten des Rechtsstreits haben ";
    public static final String KOSTENVERTEILUNG_FORMAT = "Die Kosten haben %s zu %,.2f%% und %s zu %,.2f%% zu tragen. %n";
    public static final String KOSTENTRAGUNG_EINSEITIG = "Die Kosten hat %s zu tragen.%n";
    public static final String GESAMTSCHULDNERISCH_RICHTIG = "werden verurteilt, gesamtschuldnerisch";
    public static final String GESAMTSCHULDNERISCH_FALSCH = "gesamtschuldnerisch werden verurteilt,";
    public static final String GESAMTSCHULDNERISCH_DARUEBER_RICHTIG = "werden dar\u00fcber hinaus verurteilt, gesamtschuldnerisch";
    public static final String GESAMTSCHULDNERISCH_DARUEBER_FALSCH = "gesamtschuldnerisch werden dar\u00fcber hinaus verurteilt,";
    public static final String DARUEBER_HINAUS = " dar\u00fcber hinaus";
    public static final String VERURTEILUNG_ZAHLUNG_AN_GGF_TEILABWEISUNG_FORMAT = "%s %s verurteilt, an %s %,.2f EUR zu zahlen.%s%n";
    public static final String VERURTEILUNGS_FORMAT = "%s wird verurteilt, %s %,.2f EUR zu zahlen. ";
    public static final String VERURTEILUNGS_FORMAT_EUR = "%s wird verurteilt, %s %s EUR zu zahlen. ";
    public static final String KLAGEABWEISUNG_IM_UEBRIGEN_LEERSCHRITT = " Im \u00dcbrigen wird die Klage abgewiesen.";
    public static final String KLAGEABWEISUNG_IM_UEBRIGEN = "Im \u00dcbrigen wird die Klage abgewiesen.";
    public static final String KLAGEABWEISUNG_ZEILE = "Die Klage wird abgewiesen.\n";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709 = "Das Urteil ist gegen Sicherheitsleistung in H\u00f6he von 110% des jeweils zu vollstreckenden Betrags vorl\u00e4ufig vollstreckbar.\n";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709_KOMBI = "Gegen\u00fcber %s ist das Urteil gegen Sicherheitsleistung in H\u00f6he von 110%% des jeweils zu vollstreckenden Betrags vorl\u00e4ufig vollstreckbar.\n";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711 = "%s wird nachgelassen, die Vollstreckung gegen Sicherheitsleistung in H\u00f6he von 110%% des aufgrund des Urteils vollstreckbaren Betrags abzuwenden, wenn nicht %s vor der Vollstreckung Sicherheit in H\u00f6he von 110%% des jeweils zu vollstreckenden Betrags leistet.\n";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR = "Das Urteil ist vorl\u00e4ufig vollstreckbar.\n";
    public static final Euro BERUFUNGS_GRENZE = Euro.ofEuros(1000L);
    public static final String JEWEILIGER_VOLLSTRECKUNGSGLAEUBIGER = "der jeweilige Vollstreckungsgl\u00e4ubiger";
    public static final String JEWEILIGER_VOLLSTRECKUNGSSCHULDNER = "dem jeweiligen Vollstreckungsschuldner";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711_WERIST = "%s wird %s nachgelassen, die Vollstreckung gegen Sicherheitsleistung in H\u00f6he von 110%% des aufgrund des Urteils vollstreckbaren Betrags abzuwenden, wenn nicht %s vor der Vollstreckung Sicherheit in H\u00f6he von 110%% des jeweils zu vollstreckenden Betrags leistet.\n";
    public static final String URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709_EINZELN = " ist es gegen Sicherheitsleistung in H\u00f6he von 110% des jeweils zu vollstreckenden Betrags vorl\u00e4ufig vollstreckbar.\n";
    protected boolean alsBruch;

    protected TenorTexter(boolean alsBruch) {
        this.alsBruch = alsBruch;
    }

    public abstract String texteHauptsache(EntscheidungsListenElemente<HauptsacheVerhaeltnis> var1);

    public String texteKostenentscheidung(EntscheidungsListenElemente<KostenTragungsVerhaeltnis> elemente) {
        List verhaeltnisse = elemente.prozessverhaeltnisse;
        if (verhaeltnisse.isEmpty()) {
            throw new IllegalArgumentException("elemente darf nicht leer sein!");
        }
        if (verhaeltnisse.size() == 1) {
            Beteiligter schuldner = ((KostenTragungsVerhaeltnis)verhaeltnisse.get(0)).getSchuldner();
            return String.format(KOSTENTRAGUNG_EINSEITIG, schuldner.parteiBezeichner(Beteiligter.Casus.NOMINATIV, schuldner.getLfdNr(), true));
        }
        KostenTragungsVerhaeltnis bkkl = (KostenTragungsVerhaeltnis)elemente.prozessverhaeltnisse.get(0);
        KostenTragungsVerhaeltnis klbk = (KostenTragungsVerhaeltnis)elemente.prozessverhaeltnisse.get(1);
        if (this.alsBruch) {
            return String.valueOf(TenorToken.DIE_KOSTEN_DES_RECHTSSTREITS.toString()) + TenorToken.LEER + TenorToken.HABEN + TenorToken.LEER + bkkl.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, bkkl.getSchuldner().getLfdNr(), true) + TenorToken.LEER + TenorToken.ZU + TenorToken.LEER + bkkl.getKostenBruchteil().approx(99L) + UND + klbk.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, klbk.getSchuldner().getLfdNr(), true) + TenorToken.LEER + TenorToken.ZU + TenorToken.LEER + klbk.getKostenBruchteil().approx(99L) + TenorToken.LEER + TenorToken.ZU_TRAGEN + TenorToken.PUNKT_ABSATZ;
        }
        return String.format(KOSTENVERTEILUNG_FORMAT, bkkl.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, bkkl.getSchuldner().getLfdNr(), true), bkkl.getKostenBruchteil().toPercent(), klbk.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, klbk.getSchuldner().getLfdNr(), true), klbk.getKostenBruchteil().toPercent());
    }

    public String texteVollstreckbarkeit(EntscheidungsListenElemente<VollstreckungsVerhaeltnis> elemente, VollstreckbarkeitsListe liste) {
        String schuldner = JEWEILIGER_VOLLSTRECKUNGSSCHULDNER;
        String glaeubiger = JEWEILIGER_VOLLSTRECKUNGSGLAEUBIGER;
        if (liste.sindAlle708iVm713()) {
            return URTEIL_VORLAEUFIG_VOLLSTRECKBAR;
        }
        if (liste.sindAlle709()) {
            return URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709;
        }
        if (liste.sindAlle708iVm711()) {
            if (1 == elemente.prozessverhaeltnisse.size()) {
                VollstreckungsVerhaeltnis verhaeltnis = (VollstreckungsVerhaeltnis)elemente.prozessverhaeltnisse.get(0);
                schuldner = verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.Casus.DATIV, verhaeltnis.getSchuldner().getLfdNr(), true);
                glaeubiger = verhaeltnis.getGlaeubiger().parteiBezeichner(Beteiligter.Casus.NOMINATIV, verhaeltnis.getGlaeubiger().getLfdNr(), true);
            }
            return URTEIL_VORLAEUFIG_VOLLSTRECKBAR + this.satzBeginn(String.format(URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711, schuldner, glaeubiger));
        }
        StringBuffer tenor = new StringBuffer(URTEIL_VORLAEUFIG_VOLLSTRECKBAR);
        for (VollstreckungsVerhaeltnis verhaeltnis : elemente.prozessverhaeltnisse) {
            glaeubiger = verhaeltnis.getGlaeubiger().parteiBezeichner(Beteiligter.Casus.NOMINATIV, verhaeltnis.getGlaeubiger().getLfdNr(), true);
            schuldner = verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.Casus.DATIV, verhaeltnis.getSchuldner().getLfdNr(), true);
            if (verhaeltnis.getVollstreckbarkeit().isB709s1()) {
                tenor.append(String.format(URTEIL_VORLAEUFIG_VOLLSTRECKBAR_709_KOMBI, schuldner));
                continue;
            }
            tenor.append(this.satzBeginn(String.format(URTEIL_VORLAEUFIG_VOLLSTRECKBAR_708_711, this.satzBeginn(schuldner), glaeubiger)));
        }
        return tenor.toString();
    }

    public abstract String texteStreitwert(StreitwertEntscheidungsElemente var1);

    public String hatStattHaben(String satz) {
        if (!satz.contains(KOMMA_LEER) && !satz.contains(UND) && satz.contains(HABEN)) {
            int wo = satz.indexOf(HABEN);
            String davor = satz.substring(0, wo);
            String danach = satz.substring(wo + HABEN.length());
            return String.valueOf(davor) + HAT + danach;
        }
        return satz;
    }

    public String satzBeginn(String satz) {
        String zwischen = "";
        if (satz != null && satz.length() > 0) {
            zwischen = String.valueOf(satz.substring(0, 1).toUpperCase()) + satz.substring(1);
        }
        return zwischen;
    }

    public static String letztesKommaWeg(String satz) {
        String zwischen = satz;
        if (satz != null && satz.trim().endsWith(",")) {
            zwischen = satz.substring(0, satz.lastIndexOf(","));
        }
        return zwischen;
    }

    public static String undStattKomma(String satz) {
        String zwischen = satz;
        int j = satz.lastIndexOf(KOMMA_LEER);
        if (j > 0 && j < satz.length()) {
            zwischen = String.valueOf(satz.substring(0, j)) + UND + satz.substring(j + 2);
        }
        return zwischen;
    }

    public String getWirdWerden(boolean plural) {
        return plural ? WERDEN : WIRD;
    }

    public String verbessereGesamtschuldner(String satz) {
        return satz.replace(GESAMTSCHULDNERISCH_FALSCH, GESAMTSCHULDNERISCH_RICHTIG).replace(GESAMTSCHULDNERISCH_DARUEBER_FALSCH, GESAMTSCHULDNERISCH_DARUEBER_RICHTIG);
    }

    public static Object[] appendArray(Object[] objekte, Object wert) {
        Object[] array = Arrays.copyOf(objekte, objekte.length + 1);
        System.arraycopy(new Object[]{wert}, 0, array, objekte.length, 1);
        return array;
    }

    public static Object[] concat(Object[] eins, Object[] zwei) {
        Object[] drei = Arrays.copyOf(eins, eins.length + zwei.length);
        System.arraycopy(zwei, 0, drei, eins.length, zwei.length);
        return drei;
    }

    public static GebuehrenAuflistung getKostenKlaeger() {
        if (KOSTEN_KLAEGER.isEmpty()) {
            KOSTEN_KLAEGER.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV"));
            KOSTEN_KLAEGER.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3104 VV"));
            Kostenrechner.getLogger().info("KostenKlaeger gesetzt!");
        }
        return KOSTEN_KLAEGER;
    }

    public static GebuehrenAuflistung getKostenBeklagter() {
        if (KOSTEN_BEKLAGTER.isEmpty()) {
            KOSTEN_BEKLAGTER.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3104 VV"));
            Kostenrechner.getLogger().info("KostenBeklagter gesetzt!");
        }
        return KOSTEN_BEKLAGTER;
    }
}

