/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.AngriffListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachVollstreckbarkeit;
import eu.gronos.kostenrechner.data.baumbach.GerichtsKostenBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.ImUebrigen;
import eu.gronos.kostenrechner.data.baumbach.MehrfachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.baumbach.StreitgenossenAngriffe;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.ProzessVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.AntragErfolgElement;
import eu.gronos.kostenrechner.interfaces.ParteiBeziehung;
import eu.gronos.kostenrechner.interfaces.TenorVorbereitend;
import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.logic.VollstreckbarkeitsHelfer;
import eu.gronos.kostenrechner.logic.baumbach.BaumbachTexter;
import eu.gronos.kostenrechner.logic.baumbach.BegruendungsTexter;
import eu.gronos.kostenrechner.util.VerlusteBank;
import eu.gronos.kostenrechner.util.baumbach.AngriffeFilter;
import eu.gronos.kostenrechner.util.baumbach.ProzessVerhaeltnisseInTenorReihenfolge;
import eu.gronos.kostenrechner.util.baumbach.StreitgenossenAngriffePruefer;
import eu.gronos.kostenrechner.util.baumbach.StreitgenossenPruefer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BaumbachFormel
implements TenorVorbereitend {
    private final TenorDatenContainer container;
    private Map<Beteiligter, VerlusteBank> quoten;
    private Map<Beteiligter, VerlusteBank> bereinigteQuoten;
    private final BaumbachTexter texter;
    private final BegruendungsTexter begruendungsTexter;
    private final StreitgenossenAngriffe streit;

    public BaumbachFormel(VerfahrensDatenContainer verfahrensDaten) throws IllegalArgumentException {
        new StreitgenossenPruefer().pruefeEingabe(verfahrensDaten.streitgenossen);
        this.streit = new StreitgenossenAngriffConverter().apply(verfahrensDaten.streitgenossen);
        new StreitgenossenAngriffePruefer().pruefeEingabe(this.streit);
        this.container = new TenorDatenContainer(verfahrensDaten);
        this.container.erweiterteKlasse = this.streit;
        this.container.allgemein = verfahrensDaten.allgemein;
        this.texter = new BaumbachTexter(this.streit, this.container.allgemein.alsBruch);
        this.begruendungsTexter = new BegruendungsTexter(this.streit);
    }

    @Override
    public TenorDatenContainer erzeugeContainer() {
        this.container.berechnungsTyp = this.getBerechnungsTyp();
        this.container.hauptsacheEntscheidung = this.erzeugeHauptsacheEntscheidung();
        this.container.kostenEntscheidung = this.erzeugeKostenEntscheidung();
        this.container.vollstreckbarkeitsEntscheidung = this.erzeugeVollstreckbarkeitsEntscheidung();
        this.container.streitwertEntscheidung = this.erzeugeStreitwertEntscheidung();
        this.container.sonstigeEntscheidung = this.erzeugeSonstigeEntscheidung();
        this.container.begruendung = this.begruendungsTexter.begruendungsElemente();
        this.container.allgemein.selectedPanel = 1;
        return this.container;
    }

    @Override
    public EntscheidungsListenElemente<HauptsacheVerhaeltnis> erzeugeHauptsacheEntscheidung() {
        EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache = new EntscheidungsListenElemente<HauptsacheVerhaeltnis>();
        hauptsache.prozessverhaeltnisse = this.baueHauptsacheVerhaeltnisse(this.streit.angriffe);
        List<List<Angriff>> gruppen = AngriffListe.gruppiereAngriffe(this.streit.angriffe);
        this.texter.setGruppen(gruppen);
        ArrayList<ImUebrigen> biue = new ArrayList<ImUebrigen>();
        for (List<Angriff> gruppe : gruppen) {
            ImUebrigen iue = this.baueImUebrigen(gruppe);
            biue.add(iue);
        }
        this.texter.setImUebrigen(biue);
        Collections.sort(hauptsache.prozessverhaeltnisse, new ProzessVerhaeltnisseInTenorReihenfolge());
        hauptsache.text = this.texter.texteHauptsache(hauptsache);
        new EntscheidungsListenElementeAbgleicher().apply(this.streit.pseudo, hauptsache);
        return hauptsache;
    }

    @Override
    public EntscheidungsListenElemente<KostenTragungsVerhaeltnis> erzeugeKostenEntscheidung() {
        EntscheidungsListenElemente<KostenTragungsVerhaeltnis> kostenEntscheidung = new EntscheidungsListenElemente<KostenTragungsVerhaeltnis>();
        this.quoten = this.errechneAlleVerluste(this.streit.angriffe);
        this.bereinigteQuoten = this.container.allgemein.b92ii ? this.entferneUnwesentlichesUnterliegen(this.quoten, this.container.allgemein.vomHundert92ii) : this.quoten;
        kostenEntscheidung.prozessverhaeltnisse = this.baueKostenTragungsVerhaeltnisse(this.quoten, this.bereinigteQuoten, this.streit.angriffe);
        Collections.sort(kostenEntscheidung.prozessverhaeltnisse, new ProzessVerhaeltnisseInTenorReihenfolge());
        this.texter.setBereinigteQuoten(this.bereinigteQuoten);
        kostenEntscheidung.text = this.texter.texteKostenentscheidung(kostenEntscheidung);
        this.begruendungsTexter.baueGruende(this.quoten.get(new GerichtsKostenBeteiligter()));
        new EntscheidungsListenElementeAbgleicher().apply(this.streit.pseudo, kostenEntscheidung);
        return kostenEntscheidung;
    }

    @Override
    public EntscheidungsListenElemente<VollstreckungsVerhaeltnis> erzeugeVollstreckbarkeitsEntscheidung() {
        EntscheidungsListenElemente<VollstreckungsVerhaeltnis> vollEntscheidung = new EntscheidungsListenElemente<VollstreckungsVerhaeltnis>();
        VollstreckbarkeitsListe vollstreckbarkeit = this.berechneVollstreckbarkeit(this.streit.angriffe, this.bereinigteQuoten, this.quoten);
        vollEntscheidung.prozessverhaeltnisse = this.baueVollstreckungsVerhaeltnisse(vollstreckbarkeit, this.container.hauptsacheEntscheidung.prozessverhaeltnisse, this.container.kostenEntscheidung.prozessverhaeltnisse);
        this.begruendungsTexter.erweitereGruende(vollstreckbarkeit.toString());
        vollEntscheidung.text = this.texter.texteVollstreckbarkeit(vollEntscheidung, vollstreckbarkeit);
        return vollEntscheidung;
    }

    @Override
    public StreitwertEntscheidungsElemente erzeugeStreitwertEntscheidung() {
        StreitwertEntscheidungsElemente streitwert = new StreitwertEntscheidungsElemente();
        for (Euro wert : this.errechneStreitwert(this.streit.angriffe)) {
            streitwert.streitwerte.add(wert);
        }
        streitwert.text = this.texter.texteStreitwert(streitwert);
        return streitwert;
    }

    @Override
    public EntscheidungsElemente erzeugeSonstigeEntscheidung() {
        EntscheidungsElemente sonstige = new EntscheidungsElemente();
        sonstige.text = "";
        return sonstige;
    }

    @Override
    public String getBerechnungsTyp() {
        return "Tenor bei Streitgenossen nach der sog. Baumbach'schen Formel (Hauptsachetenor, Kostentenor, Vollstreckbarkeitstenor sowie Streitwertbeschluss).";
    }

    @Override
    public String getGruende() {
        return this.begruendungsTexter.getGruende();
    }

    private Map<Beteiligter, VerlusteBank> errechneAlleVerluste(List<Angriff> angriffe) {
        HashMap<Beteiligter, VerlusteBank> alleVerluste = new HashMap<Beteiligter, VerlusteBank>();
        GerichtsKostenBeteiligter gerichtsKosten = new GerichtsKostenBeteiligter();
        alleVerluste.put(gerichtsKosten, this.errechneVerluste(angriffe, gerichtsKosten));
        for (Beteiligter b : ((AngriffListe)angriffe).getBeteiligte()) {
            alleVerluste.put(b, this.errechneVerluste(angriffe, b));
        }
        return alleVerluste;
    }

    private VerlusteBank errechneVerluste(List<Angriff> angriffe, Beteiligter beteiligter) {
        VerlusteBank verluste = new VerlusteBank();
        AngriffeFilter tester = new AngriffeFilter(beteiligter);
        for (Angriff angriff : angriffe) {
            ArrayList<Beteiligter> gegner;
            if (!tester.test(angriff)) continue;
            double multi = beteiligter instanceof GerichtsKostenBeteiligter || angriff.getAngreifer().contains(beteiligter) ? angriff.getGegner().size() : 1;
            Euro angreiferUnterliegen = this.angreiferUnterliegen(angriff);
            verluste.add((List<Beteiligter>)angriff.getAngreifer(), angreiferUnterliegen.multiply(multi));
            if (this.gegnerUnterliegen(angriff).getCents() <= 0L) continue;
            if (angriff.getGegner().size() > 1 && angriff.getGegner().contains(beteiligter)) {
                gegner = new ArrayList<Beteiligter>();
                gegner.add(beteiligter);
            } else {
                gegner = angriff.getGegner();
            }
            verluste.add(gegner, this.gegnerUnterliegen(angriff).multiply(multi));
        }
        verluste.removeBlanks();
        return verluste;
    }

    private Euro gegnerUnterliegen(AntragErfolgElement angriff) {
        return angriff.getErfolg();
    }

    private Euro angreiferUnterliegen(AntragErfolgElement angriff) {
        return angriff.getAntrag().subtract(this.gegnerUnterliegen(angriff));
    }

    private List<HauptsacheVerhaeltnis> baueHauptsacheVerhaeltnisse(List<Angriff> angriffe) {
        ArrayList<HauptsacheVerhaeltnis> verhaeltnisse = new ArrayList<HauptsacheVerhaeltnis>();
        for (Angriff angriff : angriffe) {
            if (angriff.getErfolg().getCents() <= 0L) continue;
            HauptsacheVerhaeltnis verhaeltnis = this.baueHauptsacheVerhaeltnis(angriffe, angriff);
            verhaeltnisse.add(verhaeltnis);
        }
        return verhaeltnisse;
    }

    private HauptsacheVerhaeltnis baueHauptsacheVerhaeltnis(List<Angriff> angriffe, Angriff angriff) {
        return new HauptsacheVerhaeltnis(this.angreiferAusAngriff(angriff), this.gegnerAusAngriff(angriff), this.findeDarueberHinaus(angriffe, angriff).size() > 0, angriff.getErfolg());
    }

    private List<KostenTragungsVerhaeltnis> baueKostenTragungsVerhaeltnisse(Map<Beteiligter, VerlusteBank> quoten, Map<Beteiligter, VerlusteBank> bereinigteQuoten, List<Angriff> angriffe) {
        ArrayList<KostenTragungsVerhaeltnis> verhaeltnisse = new ArrayList<KostenTragungsVerhaeltnis>();
        ArrayList<Beteiligter> beteiligte = new ArrayList<Beteiligter>(bereinigteQuoten.keySet().size());
        bereinigteQuoten.keySet().forEach(beteiligte::add);
        for (Beteiligter b : bereinigteQuoten.keySet()) {
            if (b instanceof GerichtsKostenBeteiligter) {
                beteiligte.add(0, b);
                continue;
            }
            beteiligte.add(b);
        }
        for (Beteiligter glaeubiger : beteiligte) {
            VerlusteBank verluste = bereinigteQuoten.get(glaeubiger);
            for (List<Beteiligter> kontoInhaber : verluste.keySet()) {
                KostenTragungsVerhaeltnis verhaeltnis;
                if (kontoInhaber.contains(glaeubiger) || verhaeltnisse.contains(verhaeltnis = this.baueKostenTragungsVerhaeltnis(angriffe, verluste, kontoInhaber, glaeubiger))) continue;
                verhaeltnisse.add(verhaeltnis);
            }
        }
        return verhaeltnisse;
    }

    private KostenTragungsVerhaeltnis baueKostenTragungsVerhaeltnis(List<Angriff> angriffe, VerlusteBank verluste, List<Beteiligter> kontoInhaber, Beteiligter glaeubiger) {
        return new KostenTragungsVerhaeltnis(glaeubiger, this.schuldnerAusVerlustKonto(kontoInhaber, angriffe), this.findeDarueberHinaus(kontoInhaber, verluste).size() > 0, verluste.getFractionFor(kontoInhaber));
    }

    private Beteiligter angreiferAusAngriff(Angriff angriff) {
        return MehrfachBeteiligter.from((List<Beteiligter>)angriff.getAngreifer(), false);
    }

    private Beteiligter gegnerAusAngriff(Angriff angriff) {
        return MehrfachBeteiligter.from((List<Beteiligter>)angriff.getGegner(), angriff.isGesamtSchuldnerisch());
    }

    private Beteiligter schuldnerAusVerlustKonto(List<Beteiligter> kontoInhaber, List<Angriff> angriffe) {
        return MehrfachBeteiligter.from(kontoInhaber, this.istGesamtschuldnerisch(kontoInhaber, angriffe));
    }

    private List<VollstreckungsVerhaeltnis> baueVollstreckungsVerhaeltnisse(VollstreckbarkeitsListe vollstreckbarkeit, List<HauptsacheVerhaeltnis> hauptsacheVerhaeltnisse, List<KostenTragungsVerhaeltnis> kostenVerhaeltnisse) {
        if (vollstreckbarkeit != null && !vollstreckbarkeit.isEmpty() && vollstreckbarkeit.sindAlle708iVm713()) {
            return new VollstreckbarkeitsHelfer(hauptsacheVerhaeltnisse, kostenVerhaeltnisse).errechneAlleVollstreckungsVerhaeltnisse((Vollstreckbarkeit)vollstreckbarkeit.get(0));
        }
        ArrayList<VollstreckungsVerhaeltnis> verhaeltnisse = new ArrayList<VollstreckungsVerhaeltnis>();
        for (Vollstreckbarkeit vo : vollstreckbarkeit) {
            BaumbachVollstreckbarkeit bvo;
            if (!(vo instanceof BaumbachVollstreckbarkeit) || (bvo = (BaumbachVollstreckbarkeit)vo).getGlaeubiger() instanceof GerichtsKostenBeteiligter || !bvo.hatEintraege() || bvo.getGlaeubiger().equals(bvo.getSchuldner())) continue;
            VollstreckungsVerhaeltnis verhaeltnis = new VollstreckungsVerhaeltnis(bvo);
            verhaeltnisse.add(verhaeltnis);
        }
        Collections.sort(verhaeltnisse);
        return verhaeltnisse;
    }

    private VollstreckbarkeitsListe berechneVollstreckbarkeit(List<Angriff> angriffe, Map<Beteiligter, VerlusteBank> bereinigteQuoten, Map<Beteiligter, VerlusteBank> quoten) {
        VollstreckbarkeitsListe vollstreckbarkeit = new VollstreckbarkeitsListe();
        vollstreckbarkeit.add(this.pruefeUnanfechtbarkeit(quoten.get(new GerichtsKostenBeteiligter())));
        if (vollstreckbarkeit.sindAlle708iVm713()) {
            return vollstreckbarkeit;
        }
        List<Euro> streitwerte = this.errechneStreitwert(angriffe);
        Euro streitwert = streitwerte.get(0);
        for (Beteiligter glaeubiger : quoten.keySet()) {
            if (glaeubiger == null) continue;
            VerlusteBank glaeubigerQuoten = bereinigteQuoten.get(glaeubiger);
            for (Beteiligter schuldner : this.streit.beteiligte) {
                if (schuldner == null || schuldner.equals(glaeubiger)) continue;
                Euro hauptsache = Euro.ZERO_CENTS;
                Euro vollstreckbareKosten = Euro.ZERO_CENTS;
                for (Angriff angriff : angriffe) {
                    if (angriff == null || !angriff.getAngreifer().contains(glaeubiger) || !angriff.getGegner().contains(schuldner)) continue;
                    hauptsache = hauptsache.add(angriff.getErfolg());
                }
                if (glaeubiger.getTyp() == Beteiligter.BeteiligtenTyp.KLAEGER) {
                    vollstreckbareKosten = vollstreckbareKosten.add(GebuehrenAuflistung.errechneGebuehr((GebuehrenTatbestand)TenorTexter.getKostenKlaeger().get(0), streitwert).multiply(this.berechneGanzeQuote(schuldner, bereinigteQuoten.get(new GerichtsKostenBeteiligter()))));
                }
                vollstreckbareKosten = vollstreckbareKosten.add(TenorTexter.getKostenBeklagter().errechneGebuehrenSumme(streitwert).multiply(this.berechneGanzeQuote(schuldner, glaeubigerQuoten)));
                vollstreckbarkeit.add(BaumbachVollstreckbarkeit.pruefeSicherheitsleistung(hauptsache.longValue(), vollstreckbareKosten.longValue(), glaeubiger, schuldner));
            }
        }
        return vollstreckbarkeit;
    }

    private Fraction berechneGanzeQuote(Beteiligter schuldner, VerlusteBank bank) {
        if (schuldner == null || bank == null || bank.getFiktiverStreitwert() == null || bank.getFiktiverStreitwert().getCents() == 0L) {
            return Fraction.ZERO;
        }
        Euro gesamt = Euro.ZERO_CENTS;
        for (List<Beteiligter> beteiligte : bank.keySet()) {
            if (!beteiligte.contains(schuldner)) continue;
            gesamt = gesamt.add(bank.get(beteiligte));
        }
        return gesamt.divideAsFraction(bank.getFiktiverStreitwert());
    }

    private List<Angriff> findeDarueberHinaus(List<Angriff> angriffe, ParteiBeziehung<List<Beteiligter>> angriff) {
        ArrayList<Angriff> liste = new ArrayList<Angriff>();
        if (angriffe != null && angriff != null && angriffe.size() >= 1) {
            for (Angriff a : angriffe) {
                if (a.equals(angriff) || !a.getAngreifer().equals(angriff.getAngreifer()) || !a.getGegner().containsAll((Collection)angriff.getGegner()) || a.getErfolg().getCents() <= 0L) continue;
                liste.add(a);
            }
        }
        return liste;
    }

    private ImUebrigen baueImUebrigen(List<Angriff> gruppe) {
        ImUebrigen imUebrigen = new ImUebrigen(false, true, AngriffListe.klageOderWiderklage(gruppe));
        Euro gesamtErfolg = AngriffListe.addiereErfolg(gruppe);
        imUebrigen.setVollBegruendet(AngriffListe.addiereAntrag(gruppe).getCents() <= gesamtErfolg.getCents());
        imUebrigen.setGanzUnbegruendet(gesamtErfolg.getCents() <= 0L);
        return imUebrigen;
    }

    private Map<Beteiligter, VerlusteBank> entferneUnwesentlichesUnterliegen(Map<Beteiligter, VerlusteBank> quoten, int vomHundert92ii) {
        HashMap<Beteiligter, VerlusteBank> bereinigteQuoten = new HashMap<Beteiligter, VerlusteBank>();
        for (Beteiligter key : quoten.keySet()) {
            bereinigteQuoten.put(key, this.entferneUnwesentlichesUnterliegen(quoten.get(key), vomHundert92ii));
        }
        return bereinigteQuoten;
    }

    private VerlusteBank entferneUnwesentlichesUnterliegen(VerlusteBank quoten, int vomHundert92ii) {
        VerlusteBank bereinigteQuoten = new VerlusteBank();
        for (List<Beteiligter> beteiligte : quoten.keySet()) {
            if (100.0 * quoten.getQuotaFor(beteiligte) < (double)vomHundert92ii) continue;
            bereinigteQuoten.add(beteiligte, quoten.get(beteiligte));
        }
        if (bereinigteQuoten.getFiktiverStreitwert().getCents() <= 0L || quoten.getFiktiverStreitwert().equals(bereinigteQuoten.getFiktiverStreitwert())) {
            return quoten;
        }
        return bereinigteQuoten;
    }

    private boolean istGesamtschuldnerisch(List<Beteiligter> beteiligte, List<Angriff> angriffe) {
        if (beteiligte == null || beteiligte.size() < 2) {
            return false;
        }
        for (Angriff angriff : angriffe) {
            if (!angriff.getGegner().equals(beteiligte)) continue;
            return angriff.isGesamtSchuldnerisch();
        }
        return false;
    }

    private Vollstreckbarkeit pruefeUnanfechtbarkeit(VerlusteBank quoten) {
        for (List<Beteiligter> key : quoten.keySet()) {
            Euro verluste = quoten.get(key);
            if (verluste.greaterThan(TenorTexter.BERUFUNGS_GRENZE)) {
                return new Vollstreckbarkeit();
            }
            for (Euro verlust : this.findeDarueberHinaus(key, quoten)) {
                verluste = verluste.add(verlust);
            }
            if (!verluste.greaterThan(TenorTexter.BERUFUNGS_GRENZE)) continue;
            return new Vollstreckbarkeit();
        }
        return new Vollstreckbarkeit(true, false, false, false, true);
    }

    private List<Euro> findeDarueberHinaus(List<Beteiligter> beteiligte, VerlusteBank verluste) {
        ArrayList<Euro> liste = new ArrayList<Euro>();
        if (beteiligte != null && verluste != null && beteiligte.size() >= 1) {
            liste.addAll(verluste.keySet().stream().filter(verlustKonto -> !verlustKonto.equals(beteiligte)).filter(verlustKonto -> verlustKonto.containsAll(beteiligte)).filter(verlustKonto -> verluste.get((List<Beteiligter>)verlustKonto).greaterThan(Euro.ZERO_CENTS)).map(verluste::get).collect(Collectors.toList()));
        }
        return liste;
    }

    private List<Euro> errechneStreitwert(List<Angriff> angriffe) {
        List<List<Angriff>> gruppen = AngriffListe.gruppiereAngriffe(angriffe);
        ArrayList<Euro> streitwerte = new ArrayList<Euro>(gruppen.size());
        Euro hoechsteKlage = Euro.ZERO_CENTS;
        Euro hoechsteWiderklage = Euro.ZERO_CENTS;
        for (List<Angriff> gruppe : gruppen) {
            Euro wert = this.hoechterWert(gruppe);
            if (AngriffListe.klageOderWiderklage(gruppe) == Angriff.AngriffArt.WIDERKLAGE) {
                hoechsteWiderklage = wert.max(hoechsteWiderklage);
                continue;
            }
            hoechsteKlage = wert.max(hoechsteKlage);
        }
        streitwerte.add(hoechsteKlage);
        if (hoechsteWiderklage.getCents() > 0L) {
            streitwerte.add(0, this.streit.p45i3GKG ? Euro.max(hoechsteKlage, hoechsteWiderklage) : hoechsteKlage.add(hoechsteWiderklage));
            streitwerte.add(hoechsteWiderklage);
        }
        return streitwerte;
    }

    private Euro hoechterWert(List<Angriff> gruppe) {
        Euro hoechterWert = Euro.ZERO_CENTS;
        for (Angriff angriff : gruppe) {
            Euro wert = angriff.getAntrag();
            hoechterWert = wert.max(hoechterWert);
        }
        return hoechterWert;
    }

    private static class EntscheidungsListenElementeAbgleicher
    implements BiFunction<List<Beteiligter>, EntscheidungsListenElemente<? extends ProzessVerhaeltnis>, List<Beteiligter>> {
        private EntscheidungsListenElementeAbgleicher() {
        }

        @Override
        public List<Beteiligter> apply(List<Beteiligter> pseudo, EntscheidungsListenElemente<? extends ProzessVerhaeltnis> entscheidungsListenElemente) {
            for (ProzessVerhaeltnis v : entscheidungsListenElemente.prozessverhaeltnisse) {
                this.pseudoAbgleichen(pseudo, v.getGlaeubiger(), b -> v.setGlaeubiger((Beteiligter)b));
                this.pseudoAbgleichen(pseudo, v.getSchuldner(), b -> v.setSchuldner((Beteiligter)b));
            }
            return pseudo;
        }

        private void pseudoAbgleichen(List<Beteiligter> pseudo, Beteiligter beteiligter, Consumer<Beteiligter> setter) {
            if (!(beteiligter instanceof MehrfachBeteiligter) && !(beteiligter instanceof GerichtsKostenBeteiligter)) {
                return;
            }
            if (pseudo.contains(beteiligter)) {
                setter.accept(pseudo.get(pseudo.indexOf(beteiligter)));
            } else {
                pseudo.add(beteiligter);
            }
        }
    }

    static class StreitgenossenAngriffConverter
    implements Function<Streitgenossen, StreitgenossenAngriffe> {
        StreitgenossenAngriffConverter() {
        }

        @Override
        public StreitgenossenAngriffe apply(Streitgenossen streitgenossenContainer) {
            AngriffListe angriffe = new AngriffListe();
            angriffe.addAll(AngriffListe.from(this.baueListe(streitgenossenContainer)));
            Collections.sort(angriffe);
            StreitgenossenAngriffe angriffContainer = new StreitgenossenAngriffe();
            angriffContainer.angriffe = angriffe;
            angriffContainer.beteiligte = AngriffListe.alleBeteiligteAus(angriffe);
            angriffContainer.p45i3GKG = streitgenossenContainer.wirtschaftlichIdentisch;
            return angriffContainer;
        }

        private BaumbachBeteiligtenListe baueListe(Streitgenossen streitgenossenContainer) {
            BaumbachBeteiligtenListe baumbachBeteiligtenListe = new BaumbachBeteiligtenListe();
            baumbachBeteiligtenListe.addAll(streitgenossenContainer.klaeger);
            if (streitgenossenContainer.drittwiderbeklagte != null && streitgenossenContainer.drittwiderbeklagte.size() > 0) {
                baumbachBeteiligtenListe.addAll(streitgenossenContainer.drittwiderbeklagte);
            }
            baumbachBeteiligtenListe.addAll(streitgenossenContainer.beklagte);
            return baumbachBeteiligtenListe;
        }
    }
}

