/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.AngriffListe;
import eu.gronos.kostenrechner.data.baumbach.MehrfachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.StreitgenossenAngriffe;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.logic.TenorToken;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.VerlusteBank;
import java.util.ArrayList;
import java.util.List;

public class BegruendungsTexter {
    private final StringBuilder gruende = new StringBuilder();
    private BegruendungsZahlenTabelle zeilen;
    private final StreitgenossenAngriffe streit;

    public BegruendungsTexter(StreitgenossenAngriffe streit) {
        this.streit = streit;
    }

    public String getGruende() {
        return this.gruende.toString();
    }

    public BegruendungsElemente begruendungsElemente() {
        return this.zeilen.toBegruendungsElemente(this.getGruende());
    }

    void starteGruende() {
        if (this.gruende.length() > 0) {
            this.gruende.delete(0, this.gruende.length());
        }
    }

    void erweitereGruende(CharSequence text) {
        this.gruende.append(text);
    }

    StringBuilder baueGruende(VerlusteBank quoten) {
        this.zeilen = this.baueAngriffsTabelle(quoten);
        this.starteGruende();
        this.erweitereGruende(TenorToken.GRUENDE_EINLEITUNG);
        this.erweitereGruende(TenorToken.GRUENDE_91_92_100II);
        this.erweitereGruende(TenorToken.DOPPELPUNKT_ABSATZ);
        this.zeilen.toStringBuilder(this.gruende);
        return this.gruende;
    }

    private BegruendungsZahlenTabelle baueAngriffsTabelle(VerlusteBank quoten) {
        BegruendungsZahlenTabelle zeilen = new BegruendungsZahlenTabelle();
        List<List<Angriff>> gruppen = AngriffListe.gruppiereAngriffe(this.streit.angriffe);
        ArrayList<String> columnHeaders = new ArrayList<String>();
        columnHeaders.add(TenorToken.KOPFZEILE_BEGINN.toString());
        List<List<Beteiligter>> beteiligtenSpalten = this.fuelleBeteiligtenSpalten(columnHeaders);
        zeilen.add(columnHeaders);
        for (List<Angriff> gruppe : gruppen) {
            this.fuelleZeilenFuerGruppe(zeilen, gruppe, this.streit.beteiligte, beteiligtenSpalten);
        }
        String ergebnisHeader = String.valueOf(TenorToken.ERGEBNIS_ZEILE.toString()) + quoten.getFiktiverStreitwert() + TenorToken.LEER + TenorToken.EURO;
        String verlusteHeader = TenorToken.VERLUST_GESAMT.toString();
        zeilen.add(verlusteHeader, this.fuelleVerlustsummen(quoten, beteiligtenSpalten));
        zeilen.add(ergebnisHeader, this.fuelleErgebnisse(quoten, beteiligtenSpalten));
        return zeilen;
    }

    private BegruendungsZahlenZeile fuelleErgebnisse(VerlusteBank quoten, List<List<Beteiligter>> beteiligtenSpalten) {
        BegruendungsZahlenZeile ergebnisRows = new BegruendungsZahlenZeile(beteiligtenSpalten.size());
        int spalte = 0;
        while (spalte < beteiligtenSpalten.size()) {
            if (quoten.get(beteiligtenSpalten.get(spalte)) != null) {
                ergebnisRows.add(quoten.getFractionFor(beteiligtenSpalten.get(spalte)));
            } else {
                ergebnisRows.add(Fraction.ZERO);
            }
            ++spalte;
        }
        return ergebnisRows;
    }

    private BegruendungsZahlenZeile fuelleVerlustsummen(VerlusteBank quoten, List<List<Beteiligter>> beteiligtenSpalten) {
        BegruendungsZahlenZeile verlusteRows = new BegruendungsZahlenZeile(beteiligtenSpalten.size());
        int spalte = 0;
        while (spalte < beteiligtenSpalten.size()) {
            if (quoten.get(beteiligtenSpalten.get(spalte)) != null) {
                verlusteRows.add(quoten.get(beteiligtenSpalten.get(spalte)));
            } else {
                verlusteRows.add(Euro.ZERO_CENTS);
            }
            ++spalte;
        }
        return verlusteRows;
    }

    private void fuelleZeilenFuerGruppe(BegruendungsZahlenTabelle zeilen, List<Angriff> gruppe, List<Beteiligter> beteiligte, List<List<Beteiligter>> beteiligtenSpalten) {
        ArrayList<Angriff> uebersprungen = new ArrayList<Angriff>();
        for (Angriff angriff : gruppe) {
            if (angriff.getGegner().size() > 1) {
                if (angriff.getErfolg().getCents() <= 0L) continue;
                uebersprungen.add(angriff);
                continue;
            }
            zeilen.add(Angriff.benenneAngriff(angriff, beteiligte), this.fuelleEinzelverluste(beteiligtenSpalten, uebersprungen, angriff));
        }
    }

    private BegruendungsZahlenZeile fuelleEinzelverluste(List<List<Beteiligter>> beteiligtenSpalten, List<Angriff> uebersprungen, Angriff angriff) {
        BegruendungsZahlenZeile rows = new BegruendungsZahlenZeile();
        for (List<Beteiligter> beteiligter : beteiligtenSpalten) {
            rows.add(this.fuelleEinzelverlust(uebersprungen, angriff, beteiligter));
        }
        return rows;
    }

    private Euro fuelleEinzelverlust(List<Angriff> uebersprungen, Angriff angriff, List<Beteiligter> beteiligter) {
        if (beteiligter.equals(angriff.getGegner())) {
            return angriff.getErfolg();
        }
        if (beteiligter.size() > 1) {
            return this.findeWeiterenErfolg(beteiligter, uebersprungen, (List<Beteiligter>)angriff.getGegner());
        }
        if (beteiligter.equals(angriff.getAngreifer())) {
            Euro einzelErfolg = angriff.getErfolg();
            einzelErfolg = einzelErfolg.add(this.findeWeiterenErfolg(uebersprungen, (List<Beteiligter>)angriff.getGegner()));
            return angriff.getAntrag().subtract(einzelErfolg);
        }
        return Euro.ZERO_CENTS;
    }

    private List<List<Beteiligter>> fuelleBeteiligtenSpalten(List<String> columnHeaders) {
        ArrayList<List<Beteiligter>> beteiligtenSpalten = new ArrayList<List<Beteiligter>>();
        for (Angriff angriff : this.streit.angriffe) {
            Object spalte = null;
            Beteiligter partei = null;
            if (!beteiligtenSpalten.contains(angriff.getAngreifer())) {
                spalte = angriff.getAngreifer();
                partei = MehrfachBeteiligter.from((List<Beteiligter>)spalte, false);
                this.fuelleBeteiligtenSpalte(columnHeaders, beteiligtenSpalten, (List<Beteiligter>)spalte, partei);
            }
            if (beteiligtenSpalten.contains(angriff.getGegner())) continue;
            spalte = angriff.getGegner();
            partei = MehrfachBeteiligter.from((List<Beteiligter>)spalte, angriff.isGesamtSchuldnerisch());
            this.fuelleBeteiligtenSpalte(columnHeaders, beteiligtenSpalten, (List<Beteiligter>)spalte, partei);
        }
        return beteiligtenSpalten;
    }

    private void fuelleBeteiligtenSpalte(List<String> columnHeaders, List<List<Beteiligter>> beteiligtenSpalten, List<Beteiligter> spalte, Beteiligter partei) {
        if (spalte != null && partei != null) {
            columnHeaders.add(partei.parteiBezeichner(Beteiligter.Casus.GENITIV, partei.getLfdNr(), MehrfachBeteiligter.istEinzigerSeinerArt(partei, this.streit.beteiligte)));
            beteiligtenSpalten.add(spalte);
        }
    }

    private Euro findeWeiterenErfolg(List<Beteiligter> beteiligter, List<Angriff> uebersprungen, List<Beteiligter> gegner) {
        return uebersprungen.stream().filter(angriff -> angriff.getGegner().equals(beteiligter) && angriff.getGegner().containsAll(gegner)).map(Angriff::getErfolg).reduce(Euro.ZERO_CENTS, (bisher, neu) -> bisher.add((Euro)neu));
    }

    private Euro findeWeiterenErfolg(List<Angriff> uebersprungen, List<Beteiligter> gegner) {
        return uebersprungen.stream().filter(angriff -> angriff.getGegner().containsAll(gegner)).map(Angriff::getErfolg).reduce(Euro.ZERO_CENTS, (bisher, neu) -> bisher.add((Euro)neu));
    }
}

