/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.forderungen;

import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.logic.TenorTexter;

public class AngriffsTexter
extends TenorTexter<ForderungsStaffelung> {
    private Euro ganz;

    public AngriffsTexter(boolean alsBruch) {
        super(alsBruch);
    }

    @Override
    public String texteHauptsache(EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache) {
        String tenor;
        HauptsacheVerhaeltnis verhaeltnis = (HauptsacheVerhaeltnis)hauptsache.prozessverhaeltnisse.get(0);
        if (verhaeltnis.getVerurteilung().greaterThan(Euro.ZERO_CENTS)) {
            tenor = this.satzBeginn(String.format("%s wird verurteilt, %s %s EUR zu zahlen. ", verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, verhaeltnis.getSchuldner().getLfdNr(), true), verhaeltnis.getGlaeubiger().parteiBezeichner(Beteiligter.Casus.DATIV, verhaeltnis.getGlaeubiger().getLfdNr(), true), verhaeltnis.getVerurteilung()));
            if (this.ganz.greaterThan(verhaeltnis.getVerurteilung())) {
                tenor = String.valueOf(tenor) + "Im \u00dcbrigen wird die Klage abgewiesen.";
            }
        } else {
            tenor = "Die Klage wird abgewiesen.";
        }
        tenor = String.valueOf(tenor) + "\n";
        return tenor;
    }

    @Override
    public String texteStreitwert(StreitwertEntscheidungsElemente elemente) {
        return String.format("Der Streitwert wird auf %s EUR festgesetzt.%n", elemente.streitwerte.get(0));
    }

    public void setGanz(Euro euro) {
        this.ganz = euro;
    }
}

