/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRueckgabe;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.logic.TenorToken;
import eu.gronos.kostenrechner.logic.gebuehren.StreitwertReduktion;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.VerlusteBank;
import java.util.Arrays;

public class MehrkostenMethode
extends StreitwertReduktion {
    public MehrkostenMethode(VerfahrensDatenContainer verfahrensDaten) throws IllegalArgumentException {
        super(verfahrensDaten);
    }

    @Override
    public String getBerechnungsTyp() {
        return "Tenor nach der sog. Mehrkostenmethode (Hauptsachetenor, Kostentenor, Vollstreckbarkeitstenor und Streitwertbeschluss).";
    }

    @Override
    protected Fraction berechneUnterliegensQuote() {
        Fraction klVerlustTkn = this.unterliegenTeilKlageruecknahme();
        int i = 2;
        Fraction gewichtungVerbleibend = this.gewichtungVerbleibend(klVerlustTkn, 2, 0);
        Fraction sonstigerVerlust = this.verteilung(1).getFractionFor(this.klaegerlein).multiply(gewichtungVerbleibend);
        this.zeilen = this.baueBegruendungsTabelle(this.verteilung(0), gewichtungVerbleibend, sonstigerVerlust);
        super.starteGruende(this.baueGruende(this.verteilung(0), this.zeilen));
        return klVerlustTkn.add(sonstigerVerlust);
    }

    private Fraction unterliegenTeilKlageruecknahme() {
        int i = 0;
        while (i < this.reduktionen().size()) {
            GebuehrenAuflistung tatbestaende = this.tatbestaende(i);
            if (tatbestaende != null) {
                for (GebuehrenTatbestand gt : tatbestaende) {
                    GebuehrenRueckgabe durchgang = this.gebuehrenZeile(i, gt);
                    this.verteilung(0).add(this.beklagte, durchgang.unterliegensBetragBk);
                    this.verteilung(0).add(this.klaegerlein, durchgang.unterliegensBetragKl);
                }
            }
            ++i;
        }
        Fraction klVerlustTkn = this.verteilung(0).getFractionFor(this.klaegerlein);
        return klVerlustTkn;
    }

    private BegruendungsZahlenTabelle baueBegruendungsTabelle(VerlusteBank verluste, Fraction gewichtungVerbleibend, Fraction sonstigerVerlust) {
        BegruendungsZahlenTabelle zeilen = new BegruendungsZahlenTabelle();
        zeilen.add(Arrays.asList("Geb\u00fchrentatbestand", "Tats\u00e4chlicher Streitwert (EUR)", "Tats\u00e4chliche Geb\u00fchrenh\u00f6he (EUR)", "Reduzierter Streitwert (EUR)", "Fiktive Geb\u00fchrenh\u00f6he (EUR)", "Mehrkosten (EUR)", "Differenz (%)"));
        int i = 0;
        while (i < this.reduktionen().size() - 1) {
            GebuehrenAuflistung tatbestaende = this.tatbestaende(i);
            if (tatbestaende != null) {
                for (GebuehrenTatbestand gt : tatbestaende) {
                    BegruendungsZahlenZeile numbers = new BegruendungsZahlenZeile(6);
                    GebuehrenRueckgabe durchgang = this.gebuehrenZeile(i, gt);
                    numbers.add(this.streitwert(i));
                    numbers.add(durchgang.gebuehrTatsaechlich);
                    numbers.add(this.streitwert(1));
                    numbers.add(durchgang.unterliegensBetragBk);
                    numbers.add(durchgang.unterliegensBetragKl);
                    if (durchgang.gebuehrTatsaechlich.getCents() == 0L) {
                        numbers.add(Fraction.ZERO);
                    } else {
                        numbers.add(durchgang.unterliegensBetragKl.divideAsFraction(durchgang.gebuehrTatsaechlich));
                    }
                    zeilen.add(gt.langBezeichnung(), numbers);
                }
            }
            ++i;
        }
        i = 2;
        if (this.zusatz((int)2).begruendet.lessThan(this.differenz(1))) {
            String zwischenUeberschrift = "Zwischensumme";
            String verbliebeneUeberschrift = String.format("Verbliebener Streitgegenstand (gewichtet zu %,.2f%%)", gewichtungVerbleibend.toPercent());
            BegruendungsZahlenZeile zwischenZeile = new BegruendungsZahlenZeile(6);
            zwischenZeile.add(verluste.getFiktiverStreitwert());
            zwischenZeile.add(this.streitwert(1));
            zwischenZeile.add(verluste.get(this.beklagte));
            zwischenZeile.add(verluste.get(this.klaegerlein));
            zwischenZeile.add(verluste.getFractionFor(this.klaegerlein));
            zeilen.add("Zwischensumme", zwischenZeile);
            BegruendungsZahlenZeile verbliebenZeile = new BegruendungsZahlenZeile(6);
            verbliebenZeile.add(this.streitwert(1));
            verbliebenZeile.add(this.streitwert(1));
            verbliebenZeile.add(this.zusatz((int)2).begruendet);
            verbliebenZeile.add(this.zusatz((int)2).begruendet);
            verbliebenZeile.add(this.differenz(1).subtract(this.zusatz((int)2).begruendet));
            verbliebenZeile.add(sonstigerVerlust);
            zeilen.add(verbliebeneUeberschrift, verbliebenZeile);
        }
        BegruendungsZahlenZeile gesamtWerte = new BegruendungsZahlenZeile(6);
        gesamtWerte.add(this.streitwert(0));
        gesamtWerte.add(verluste.getFiktiverStreitwert());
        gesamtWerte.add(this.streitwert(1));
        gesamtWerte.add(verluste.get(this.beklagte));
        gesamtWerte.add(verluste.get(this.klaegerlein));
        gesamtWerte.add(verluste.getFractionFor(this.klaegerlein).add(sonstigerVerlust));
        zeilen.add("Gesamtsumme", gesamtWerte);
        return zeilen;
    }

    private GebuehrenRueckgabe gebuehrenZeile(int zeile, GebuehrenTatbestand gt) {
        GebuehrenRueckgabe durchgang = new GebuehrenRueckgabe();
        durchgang.gebuehrTatsaechlich = GebuehrenAuflistung.errechneGebuehr(gt, this.streitwert(zeile));
        durchgang.unterliegensBetragBk = GebuehrenAuflistung.errechneGebuehr(gt, this.swrn.streitwerte.get(1));
        durchgang.unterliegensBetragKl = durchgang.gebuehrTatsaechlich.subtract(durchgang.unterliegensBetragBk);
        return durchgang;
    }

    private StringBuilder baueGruende(VerlusteBank verluste, BegruendungsZahlenTabelle zeilen) {
        StringBuilder gruende = new StringBuilder(TenorToken.GRUENDE_EINLEITUNG);
        if (verluste.getQuotaFor(this.klaegerlein) == 0.0 || verluste.getQuotaFor(this.klaegerlein) == 0.0) {
            gruende.append(TenorToken.GRUENDE_EINLEITUNG_91);
            gruende.append("\n");
        } else {
            gruende.append(TenorToken.GRUENDE_EINLEITUNG_92_269);
            gruende.append(TenorToken.WEITER_GRUENDE_MEHRK);
            gruende.append(TenorToken.PUNKT_ABSATZ);
            gruende.append(TenorToken.GRUENDE_BERECHNUNG_MEHRKOSTEN);
            if (this.swrn.streitwerte.get(1).greaterThan(this.reduktionen().get((int)2).zusatz.begruendet)) {
                gruende.append(TenorToken.GRUENDE_VERBLIEBENER_GEGENSTAND);
                gruende.append(TenorToken.GRUENDE_VERBLIEBENER_GEGENSTAND_SONST);
            }
            gruende.append(TenorToken.GRUENDE_EINLEITUNG_TABELLE);
            gruende.append(TenorToken.DOPPELPUNKT_ABSATZ);
        }
        return zeilen.toStringBuilder(gruende);
    }
}

