/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRueckgabe;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.logic.TenorToken;
import eu.gronos.kostenrechner.logic.gebuehren.StreitwertReduktion;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.VerlusteBank;
import java.util.Arrays;

public class QuotenMethode
extends StreitwertReduktion {
    public QuotenMethode(VerfahrensDatenContainer verfahrensDaten) throws IllegalArgumentException {
        super(verfahrensDaten);
    }

    @Override
    public String getBerechnungsTyp() {
        return "Tenor nach der sog. Quotenmethode (Hauptsachetenor, Kostentenor, Vollstreckbarkeitstenor und Streitwertbeschluss)";
    }

    @Override
    protected Fraction berechneUnterliegensQuote() {
        Fraction klVerlustTkn = this.unterliegenTeilKlageruecknahme();
        System.out.println("klVerlustTkn = " + klVerlustTkn.toString() + " = " + klVerlustTkn.doubleValue());
        int i = 2;
        Fraction gewichtungVerbleibend = this.gewichtungVerbleibend(klVerlustTkn, 2, 0);
        System.out.println("gewichtungVerbleibend = " + gewichtungVerbleibend.toString() + " = " + gewichtungVerbleibend.doubleValue());
        Fraction sonstigerVerlust = this.verteilung(1).getFractionFor(this.klaegerlein).multiply(gewichtungVerbleibend);
        System.out.println("sonstigerVerlust = " + sonstigerVerlust.toString() + " = " + sonstigerVerlust.doubleValue());
        this.zeilen = this.baueBegruendungsTabelle(this.verteilung(0), gewichtungVerbleibend, sonstigerVerlust);
        super.starteGruende(this.baueGruende(this.verteilung(0), this.zeilen));
        if (this.streitwerte.length == 2 && this.streitwerte[0].equals(this.streitwerte[1]) && !this.streitwerte[1].equals(this.verurteilung)) {
            return Fraction.ONE.subtract(Fraction.valueOf(this.verurteilung.getCents(), this.streitwerte[1].getCents()));
        }
        return klVerlustTkn;
    }

    private Fraction unterliegenTeilKlageruecknahme() {
        int zeile = 0;
        while (zeile < this.reduktionen().size() - 1) {
            GebuehrenAuflistung tatbestaende = this.tatbestaende(zeile);
            Fraction verlustQuote = Fraction.ONE.subtract(Fraction.valueOf(this.verurteilung.getCents(), this.streitwert(zeile).getCents()));
            System.out.println("Zeile " + zeile + ". Verlustquote Kl\u00e4ger f\u00fcr " + this.streitwert(zeile) + ", im Verh\u00e4ltnis zu " + this.verurteilung + " = " + verlustQuote);
            if (tatbestaende != null) {
                for (GebuehrenTatbestand gt : tatbestaende) {
                    GebuehrenRueckgabe gr = this.gebuehrenZeile(zeile, verlustQuote, gt);
                    this.verteilung(0).add(this.beklagte, gr.unterliegensBetragBk);
                    this.verteilung(0).add(this.klaegerlein, gr.unterliegensBetragKl);
                    System.out.println(String.valueOf(gt.getVorschrift()) + "=" + gr.gebuehrTatsaechlich + ", Kl\u00e4ger: " + gr.unterliegensBetragKl + ", Bk: " + gr.unterliegensBetragBk);
                }
            }
            ++zeile;
        }
        Fraction klVerlustTkn = this.verteilung(0).getFractionFor(this.klaegerlein);
        return klVerlustTkn;
    }

    private BegruendungsZahlenTabelle baueBegruendungsTabelle(VerlusteBank verluste, Fraction gewichtungVerbleibend, Fraction sonstigerVerlust) {
        BegruendungsZahlenTabelle zeilen = new BegruendungsZahlenTabelle();
        zeilen.add(Arrays.asList("Geb\u00fchrentatbestand", "Streitwert (EUR)", "Geb\u00fchrenbetrag (EUR)", "Verlustquote Kl.", "Unterliegen Kl. (EUR)"));
        int zeile = 0;
        while (zeile < this.reduktionen().size() - 1) {
            GebuehrenAuflistung tatbestaende = this.tatbestaende(zeile);
            Fraction verlustQuote = Fraction.ONE.subtract(Fraction.valueOf(this.verurteilung.getCents(), this.streitwert(zeile).getCents()));
            if (tatbestaende != null) {
                for (GebuehrenTatbestand gt : tatbestaende) {
                    BegruendungsZahlenZeile numbers = new BegruendungsZahlenZeile(4);
                    GebuehrenRueckgabe gr = this.gebuehrenZeile(zeile, verlustQuote, gt);
                    numbers.add(this.streitwert(zeile));
                    numbers.add(gr.gebuehrTatsaechlich);
                    numbers.add(verlustQuote);
                    numbers.add(gr.unterliegensBetragKl);
                    zeilen.add(gt.langBezeichnung(), numbers);
                }
            }
            ++zeile;
        }
        int i = 2;
        if (this.zusatz((int)2).begruendet.lessThan(this.differenz(1))) {
            String zwischenUeberschrift = "Zwischensumme";
            String verbliebeneUeberschrift = String.format("Verbliebener Streitgegenstand (gewichtet zu %s)", gewichtungVerbleibend.toString());
            BegruendungsZahlenZeile zwischenZeile = new BegruendungsZahlenZeile(4);
            zwischenZeile.add(Euro.ZERO_CENTS);
            zwischenZeile.add(verluste.getFiktiverStreitwert());
            zwischenZeile.add(verluste.getFractionFor(this.klaegerlein));
            zwischenZeile.add(verluste.get(this.klaegerlein));
            zwischenZeile.add(verluste.getFractionFor(this.klaegerlein));
            zeilen.add("Zwischensumme", zwischenZeile);
            BegruendungsZahlenZeile verbliebenZeile = new BegruendungsZahlenZeile(4);
            verbliebenZeile.add(this.streitwert(1));
            verbliebenZeile.add(this.streitwert(1));
            verbliebenZeile.add(sonstigerVerlust);
            verbliebenZeile.add(this.differenz(1).subtract(this.zusatz((int)2).begruendet));
            zeilen.add(verbliebeneUeberschrift, verbliebenZeile);
        }
        BegruendungsZahlenZeile gesamtWerte = new BegruendungsZahlenZeile(4);
        gesamtWerte.add(Euro.ZERO_CENTS);
        gesamtWerte.add(verluste.getFiktiverStreitwert());
        gesamtWerte.add(verluste.getFractionFor(this.klaegerlein));
        gesamtWerte.add(verluste.get(this.klaegerlein));
        zeilen.add("Gesamt:", gesamtWerte);
        return zeilen;
    }

    private GebuehrenRueckgabe gebuehrenZeile(int zeile, Fraction verlustQuote, GebuehrenTatbestand gt) {
        GebuehrenRueckgabe gr = new GebuehrenRueckgabe();
        gr.gebuehrTatsaechlich = GebuehrenAuflistung.errechneGebuehr(gt, this.streitwert(zeile));
        gr.unterliegensBetragKl = gr.gebuehrTatsaechlich.multiply(verlustQuote);
        gr.unterliegensBetragBk = gr.gebuehrTatsaechlich.subtract(gr.unterliegensBetragKl);
        return gr;
    }

    private CharSequence baueGruende(VerlusteBank verluste, BegruendungsZahlenTabelle zeilen) {
        StringBuilder gruende = new StringBuilder(TenorToken.GRUENDE_EINLEITUNG);
        if (verluste.getQuotaFor(this.klaegerlein) == 0.0 || verluste.getQuotaFor(this.klaegerlein) == 0.0) {
            gruende.append(TenorToken.GRUENDE_EINLEITUNG_91);
            gruende.append("Denn auch unter Ber\u00fccksichtigung der quotalen Beteiligung der Parteien an allen Geb\u00fchren ergibt sich ein eindeutiges Ergebnis, wie sich aus folgender Tabelle ergibt:\n");
        } else {
            gruende.append(TenorToken.GRUENDE_EINLEITUNG_92_269);
            gruende.append(TenorToken.WEITER_GRUENDE_QUOTENM);
            gruende.append(TenorToken.PUNKT_ABSATZ);
            gruende.append("Denn an den einzelnen Geb\u00fchren sind die Parteien mit verschiedenen Quoten beteiligt, je nachdem, ob die einzelne Geb\u00fchr vor oder nach der Reduktion angefallen ist, wie sich aus der folgenden Tabelle ergibt:\n");
            if (this.swrn.streitwerte.get(1).greaterThan(this.reduktionen().get((int)2).zusatz.begruendet)) {
                gruende.append(TenorToken.GRUENDE_VERBLIEBENER_GEGENSTAND);
                gruende.append(TenorToken.GRUENDE_VERBLIEBENER_GEGENSTAND_SONST);
            }
        }
        return zeilen.toStringBuilder(gruende);
    }
}

