/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.gebuehren;

import eu.gronos.kostenrechner.data.KostenZweierquote;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.ReduktionStruktur;
import eu.gronos.kostenrechner.data.gebuehren.ReduktionZusatzInformation;
import eu.gronos.kostenrechner.data.gebuehren.ReduktionsGrund;
import eu.gronos.kostenrechner.data.gebuehren.ReduktionsVerarbeitung;
import eu.gronos.kostenrechner.data.gebuehren.StreitwertReduktionen;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.Vollstreckbarkeit;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckbarkeitsListe;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.interfaces.TenorVorbereitend;
import eu.gronos.kostenrechner.logic.TenorTexter;
import eu.gronos.kostenrechner.logic.VollstreckbarkeitsHelfer;
import eu.gronos.kostenrechner.logic.gebuehren.StreitwertReduktionTexter;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.VerlusteBank;
import eu.gronos.kostenrechner.util.gebuehren.TeilklageruecknahmePruefer;
import java.util.ArrayList;
import java.util.List;

public abstract class StreitwertReduktion
implements TenorVorbereitend {
    protected final StreitwertReduktionen swrn;
    protected final List<Beteiligter> klaegerlein;
    protected final List<Beteiligter> beklagte;
    protected final List<ReduktionsVerarbeitung> verarbeitungen;
    protected final Euro[] streitwerte;
    protected final Euro verurteilung;
    final Beteiligter klaeger;
    final Beteiligter beklagter;
    protected final StringBuilder gruende;
    protected BegruendungsZahlenTabelle zeilen;
    private Fraction quote = Fraction.valueOf(-1.0);
    private VollstreckbarkeitsListe vollstreckbarkeitsListe;
    private final TenorDatenContainer container;
    private Pruefend<Teilklageruecknahme> pruefer = new TeilklageruecknahmePruefer();
    private final StreitwertReduktionTexter texter;
    private Allgemein allgemein;

    public StreitwertReduktion(VerfahrensDatenContainer verfahrensDaten) throws IllegalArgumentException {
        Teilklageruecknahme teilklageruecknahme = verfahrensDaten.teilklageruecknahme;
        this.streitwerte = new Euro[]{teilklageruecknahme.streitwerteUndObsiegen.get(0), teilklageruecknahme.streitwerteUndObsiegen.get(1)};
        this.verurteilung = teilklageruecknahme.streitwerteUndObsiegen.get(2);
        this.pruefer.pruefeEingabe(teilklageruecknahme);
        this.klaeger = (Beteiligter)teilklageruecknahme.parteien.get(0);
        this.beklagter = (Beteiligter)teilklageruecknahme.parteien.get(1);
        this.allgemein = verfahrensDaten.allgemein;
        this.texter = new StreitwertReduktionTexter(this.allgemein.alsBruch);
        this.gruende = new StringBuilder();
        this.container = new TenorDatenContainer(verfahrensDaten);
        this.swrn = this.toStreitwertReduktionen(teilklageruecknahme);
        this.container.erweiterteKlasse = this.swrn;
        this.klaegerlein = new ArrayList<Beteiligter>(this.swrn.parteien.subList(0, 1));
        this.beklagte = new ArrayList<Beteiligter>(this.swrn.parteien.subList(1, verfahrensDaten.teilklageruecknahme.parteien.size()));
        this.verarbeitungen = new ArrayList<ReduktionsVerarbeitung>();
        this.initVerarbeitungen();
    }

    private void initVerarbeitungen() {
        int i = 1;
        while (i < this.swrn.reduktionen.size() && i < this.swrn.streitwerte.size()) {
            ReduktionsVerarbeitung verarbeitung = new ReduktionsVerarbeitung();
            verarbeitung.differenz = this.swrn.streitwerte.get(i - 1).subtract(this.swrn.streitwerte.get(i));
            verarbeitung.anteilAmRechtsstreit = verarbeitung.differenz.divideAsFraction(this.swrn.streitwerte.get(0));
            this.verarbeitungen.add(verarbeitung);
            ++i;
        }
    }

    protected Fraction anteilAmRechtsstreit(int i) {
        return this.verarbeitungen.get((int)i).anteilAmRechtsstreit;
    }

    protected List<ReduktionStruktur> reduktionen() {
        return this.swrn.reduktionen;
    }

    protected GebuehrenAuflistung tatbestaende(int i) {
        return this.swrn.reduktionen.get((int)i).tatbestaende;
    }

    protected VerlusteBank verteilung(int i) {
        return this.verarbeitungen.get((int)i).verteilung;
    }

    protected Euro streitwert(int i) {
        return this.swrn.streitwerte.get(i);
    }

    protected ReduktionZusatzInformation zusatz(int i) {
        return this.swrn.reduktionen.get((int)i).zusatz;
    }

    protected Euro differenz(int i) {
        return this.verarbeitungen.get((int)i).differenz;
    }

    protected Fraction gewichtungVerbleibend(Fraction klVerlustBisher, int letzteZeile, int zeileRn) {
        Fraction gewichtungVerbleibend = this.anteilAmRechtsstreit(zeileRn).subtract(klVerlustBisher).add(this.anteilAmRechtsstreit(letzteZeile - 1));
        this.verteilung(letzteZeile - 1).add(this.beklagte, this.zusatz((int)letzteZeile).begruendet);
        this.verteilung(letzteZeile - 1).add(this.klaegerlein, this.differenz(letzteZeile - 1).subtract(this.zusatz((int)letzteZeile).begruendet));
        return gewichtungVerbleibend;
    }

    private StreitwertReduktionen toStreitwertReduktionen(Teilklageruecknahme tkrn) {
        ReduktionStruktur struktur;
        StreitwertReduktionen swrn = new StreitwertReduktionen();
        swrn.parteien.addAll(tkrn.parteien);
        int i = 0;
        while (i < tkrn.streitwerteUndObsiegen.size() - 1) {
            struktur = new ReduktionStruktur();
            struktur.streitwert = tkrn.streitwerteUndObsiegen.get(i);
            swrn.streitwerte.add(struktur.streitwert);
            switch (i) {
                case 0: {
                    struktur.grund = ReduktionsGrund.VORHER;
                    struktur.tatbestaende.addAll(tkrn.vorher);
                    break;
                }
                case 1: {
                    struktur.grund = ReduktionsGrund.TEILKLAGERUECKNAHME;
                    struktur.tatbestaende.addAll(tkrn.nachher);
                }
            }
            swrn.reduktionen.add(struktur);
            ++i;
        }
        i = tkrn.streitwerteUndObsiegen.size() - 1;
        struktur = new ReduktionStruktur();
        struktur.grund = ReduktionsGrund.ENDENTSCHEIDUNG;
        struktur.streitwert = Euro.ZERO_CENTS;
        swrn.streitwerte.add(struktur.streitwert);
        struktur.zusatz = new ReduktionZusatzInformation();
        struktur.zusatz.begruendet = tkrn.streitwerteUndObsiegen.get(i);
        swrn.reduktionen.add(struktur);
        return swrn;
    }

    protected abstract Fraction berechneUnterliegensQuote();

    @Override
    public String getGruende() {
        return this.gruende.toString();
    }

    @Override
    public EntscheidungsListenElemente<HauptsacheVerhaeltnis> erzeugeHauptsacheEntscheidung() {
        EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache = new EntscheidungsListenElemente<HauptsacheVerhaeltnis>();
        hauptsache.prozessverhaeltnisse.clear();
        hauptsache.prozessverhaeltnisse.add(new HauptsacheVerhaeltnis(this.klaeger, this.beklagter, false, this.verurteilung));
        this.texter.setStreitwerte(this.streitwerte);
        hauptsache.text = this.texter.texteHauptsache(hauptsache);
        return hauptsache;
    }

    @Override
    public EntscheidungsListenElemente<KostenTragungsVerhaeltnis> erzeugeKostenEntscheidung() {
        EntscheidungsListenElemente<KostenTragungsVerhaeltnis> kostenEntscheidung = new EntscheidungsListenElemente<KostenTragungsVerhaeltnis>();
        if (this.getQuote().equals(Fraction.ZERO)) {
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.klaeger, this.beklagter, false, Fraction.ONE));
        } else if (this.getQuote().equals(Fraction.ONE)) {
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.beklagter, this.klaeger, false, Fraction.ONE));
        } else {
            KostenZweierquote zweierQuote = new KostenZweierquote(this.getQuote());
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.beklagter, this.klaeger, false, zweierQuote.getKlaegerQuote()));
            kostenEntscheidung.prozessverhaeltnisse.add(new KostenTragungsVerhaeltnis(this.klaeger, this.beklagter, false, zweierQuote.getBeklagtenQuote()));
        }
        kostenEntscheidung.text = this.texter.texteKostenentscheidung(kostenEntscheidung);
        return kostenEntscheidung;
    }

    @Override
    public EntscheidungsListenElemente<VollstreckungsVerhaeltnis> erzeugeVollstreckbarkeitsEntscheidung() {
        EntscheidungsListenElemente<VollstreckungsVerhaeltnis> vollEntscheidung = new EntscheidungsListenElemente<VollstreckungsVerhaeltnis>();
        if (this.vollstreckbarkeitsListe == null) {
            this.vollstreckbarkeitsListe = this.berechneVollstreckbarkeit();
        }
        this.erweitereGruende(this.vollstreckbarkeitsListe.toString());
        VollstreckbarkeitsHelfer helfer = new VollstreckbarkeitsHelfer(this.container.hauptsacheEntscheidung.prozessverhaeltnisse, this.container.kostenEntscheidung.prozessverhaeltnisse);
        vollEntscheidung.prozessverhaeltnisse = helfer.toVollstreckbarkeitsVerhaeltnisse(this.klaeger, this.beklagter, this.vollstreckbarkeitsListe);
        vollEntscheidung.text = this.texter.texteVollstreckbarkeit(vollEntscheidung, this.vollstreckbarkeitsListe);
        return vollEntscheidung;
    }

    @Override
    public StreitwertEntscheidungsElemente erzeugeStreitwertEntscheidung() {
        StreitwertEntscheidungsElemente elemente = this.container.streitwertEntscheidung;
        elemente.streitwerte.add(this.streitwerte[0]);
        elemente.streitwerte.add(this.streitwerte[1]);
        elemente.text = this.texter.texteStreitwert(elemente);
        return elemente;
    }

    @Override
    public EntscheidungsElemente erzeugeSonstigeEntscheidung() {
        EntscheidungsElemente sonstige = new EntscheidungsElemente();
        sonstige.text = "";
        return sonstige;
    }

    @Override
    public TenorDatenContainer erzeugeContainer() {
        this.container.berechnungsTyp = this.getBerechnungsTyp();
        this.container.hauptsacheEntscheidung = this.erzeugeHauptsacheEntscheidung();
        this.container.kostenEntscheidung = this.erzeugeKostenEntscheidung();
        this.container.vollstreckbarkeitsEntscheidung = this.erzeugeVollstreckbarkeitsEntscheidung();
        this.container.streitwertEntscheidung = this.erzeugeStreitwertEntscheidung();
        this.container.sonstigeEntscheidung = this.erzeugeSonstigeEntscheidung();
        this.container.begruendung = this.zeilen.toBegruendungsElemente(this.getGruende());
        this.container.allgemein.selectedPanel = 0;
        return this.container;
    }

    Fraction getQuote() {
        if (this.quote.lessThan(Fraction.ZERO)) {
            this.quote = this.berechneUnterliegensQuote();
            if (this.isB92ii()) {
                this.quote = this.entferneUnwesentlichesUnterliegen(this.quote);
            }
        }
        return this.quote;
    }

    boolean isB92ii() {
        return this.allgemein.b92ii;
    }

    private Fraction entferneUnwesentlichesUnterliegen(Fraction quote) {
        Fraction unwesentlich = Fraction.valueOf(this.allgemein.vomHundert92ii, 100L);
        if (quote.greaterThan(Fraction.ZERO) && quote.lessThan(unwesentlich)) {
            return Fraction.ZERO;
        }
        if (Fraction.ONE.subtract(quote).lessThan(unwesentlich)) {
            return Fraction.ONE;
        }
        return quote;
    }

    private VollstreckbarkeitsListe berechneVollstreckbarkeit() {
        VollstreckbarkeitsListe vollstreckbarkeitsListe = new VollstreckbarkeitsListe();
        vollstreckbarkeitsListe.add(this.pruefeUnanfechtbarkeit());
        if (vollstreckbarkeitsListe.sindAlle708iVm713()) {
            return vollstreckbarkeitsListe;
        }
        Vollstreckbarkeit voKl = Vollstreckbarkeit.pruefeSicherheitsleistung(this.verurteilung, TenorTexter.getKostenKlaeger().errechneGebuehrenSumme(this.streitwerte[0]).multiply(Fraction.ONE.subtract(this.getQuote())));
        vollstreckbarkeitsListe.add(voKl);
        Vollstreckbarkeit voBk = Vollstreckbarkeit.pruefeSicherheitsleistung(Euro.ZERO_CENTS, TenorTexter.getKostenBeklagter().errechneGebuehrenSumme(this.streitwerte[0]).multiply(this.getQuote()));
        vollstreckbarkeitsListe.add(voBk);
        return vollstreckbarkeitsListe;
    }

    private Vollstreckbarkeit pruefeUnanfechtbarkeit() {
        Vollstreckbarkeit unanfechtbarkeit = new Vollstreckbarkeit();
        if (this.streitwerte[0].compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0) {
            unanfechtbarkeit = new Vollstreckbarkeit(true, false, false, false, true);
        } else if (this.streitwerte[0].compareTo(TenorTexter.BERUFUNGS_GRENZE.multiply(2.0)) <= 0 && this.streitwerte[0].subtract(this.verurteilung).compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0 && this.verurteilung.compareTo(TenorTexter.BERUFUNGS_GRENZE) <= 0) {
            unanfechtbarkeit = new Vollstreckbarkeit(true, false, false, false, true);
        }
        return unanfechtbarkeit;
    }

    protected void starteGruende(CharSequence text) {
        if (this.gruende.length() > 0) {
            this.gruende.delete(0, this.gruende.length());
        }
        this.erweitereGruende(text);
    }

    void erweitereGruende(CharSequence text) {
        this.gruende.append(text);
    }
}

