/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;

public class ScalableBeteiligtenTableModel
extends BeteiligtenTableModel {
    private static final long serialVersionUID = -7940005728950314998L;
    private int columnCount = 2;
    public static final int MAX_SPALTEN = 4;
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Integer.class, Beteiligter.class, Euro.class, Euro.class, Boolean.class};
    private static final String[] COLUMN_NAMES = new String[]{"#", "Parteibezeichnung (m/w)", "Streitwert", "Unterliegen", "Widerklage?"};

    public ScalableBeteiligtenTableModel(Beteiligter.BeteiligtenTyp beteiligtenTyp, BaumbachBeteiligtenListe values) {
        super(beteiligtenTyp, false, values);
    }

    @Deprecated
    public ScalableBeteiligtenTableModel(int beteiligtenTyp, BaumbachBeteiligtenListe values) {
        super(beteiligtenTyp, false, values);
    }

    public Beteiligter[] getBeteiligterColumn() {
        Beteiligter[] bba = new Beteiligter[this.values.findeGesamtschuldnerIndices(this.beteiligtenTyp, false).size()];
        int row = -1;
        for (Beteiligter beteiligter : this.values) {
            if (beteiligter instanceof BaumbachGesamtschuldnerschaft) continue;
            bba[++row] = (Beteiligter)this.values.get(row);
        }
        return bba;
    }

    @Override
    public int getRowCount() {
        return this.values == null ? 0 : this.values.findeGesamtschuldnerIndices(this.beteiligtenTyp, false).size();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        if (columnCount != this.columnCount) {
            this.columnCount = columnCount;
            super.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.values != null && this.values.size() > rowIndex && this.columnCount - 1 == columnIndex;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.values == null || this.values.size() <= rowIndex || columnIndex == 0 || COLUMN_NAMES.length <= columnIndex) {
            return;
        }
        boolean erfolgreich = false;
        switch (columnIndex - 1) {
            case 0: {
                erfolgreich = this.setParteiBezeichnerAt(aValue, rowIndex);
                break;
            }
            case 1: {
                erfolgreich = this.setStreitwertAt(aValue, rowIndex);
                break;
            }
            case 2: {
                erfolgreich = this.setUnterliegenAt(aValue, rowIndex);
                break;
            }
            case 3: {
                System.err.println("Jemand \u00e4ndert anWiderklageBeteiligt!!!!");
                erfolgreich = this.setWiderklageAt(aValue, rowIndex);
                break;
            }
            default: {
                erfolgreich = false;
            }
        }
        if (erfolgreich) {
            super.fireTableCellUpdated(rowIndex, columnIndex);
            super.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public void setEachStreitwert(Euro streitwert) {
        int rowIndex = 0;
        while (rowIndex < this.values.size()) {
            if (!(this.values.get(rowIndex) instanceof BaumbachGesamtschuldnerschaft)) {
                ((BaumbachBeteiligter)this.values.get(rowIndex)).setAntrag(streitwert);
            }
            ++rowIndex;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public HtmlRtfFormattierend getHoechstenStreitwert() {
        Euro sw = Euro.ZERO_CENTS;
        this.values.getHoechstenStreitwert(Beteiligter.BeteiligtenTyp.KLAEGER);
        int row = 0;
        while (row < this.getRowCount()) {
            Euro d = ((BaumbachBeteiligter)this.values.get(row)).getAntrag();
            if (d.greaterThan(sw)) {
                sw = d;
            }
            ++row;
        }
        return sw;
    }

    public void setEachUnterliegen(Euro unterliegen) {
        int rowIndex = 0;
        while (rowIndex < this.values.size()) {
            if (!(this.values.get(rowIndex) instanceof BaumbachGesamtschuldnerschaft)) {
                ((BaumbachBeteiligter)this.values.get(rowIndex)).setErfolg(unterliegen);
            }
            ++rowIndex;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        if (this.values == null || this.values.size() < rowIndex || this.columnCount < columnIndex) {
            return null;
        }
        return super.getValueAt(rowIndex, columnIndex - 1);
    }
}

