/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.forderungen;

import eu.gronos.kostenrechner.data.forderungen.AufrechnungsForderung;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.KlageForderung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.RowHandler;
import eu.gronos.kostenrechner.interfaces.RowList;
import eu.gronos.kostenrechner.interfaces.TooltipLieferant;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ForderungenTableModel
extends AbstractTableModel
implements RowHandler<Forderung>,
RowList<Forderung>,
TooltipLieferant {
    private static final long serialVersionUID = 3439877940063327994L;
    private static final int COLUMN_COUNT = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Forderungsart", "H\u00f6he der Forderung", "Begr\u00fcndetheit", "Richtung"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Hauptklageantrag oder Hilfsaufrechnung", "H\u00f6he der Forderung", "Inwieweit das Angriffs- oder Verteidigungsmittel begr\u00fcndet ist", "Richtung"};
    private static final Class<?>[] COLUMN_CLASS = new Class[]{Forderung.class, Double.class, Double.class, Boolean.class};
    private List<Forderung> values = new ArrayList<Forderung>();

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASS[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        return columnIndex >= 0 && columnIndex < this.getColumnCount();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return;
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return;
        }
        if (!this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                if (aValue instanceof KlageForderung || aValue instanceof AufrechnungsForderung) {
                    Forderung f = (Forderung)aValue;
                    f.setAntrag(this.getRow(rowIndex).getAntrag());
                    f.setErfolg(this.getRow(rowIndex).getErfolg());
                    this.values.set(rowIndex, f);
                    break;
                }
                return;
            }
            case 1: {
                if (aValue instanceof Double) {
                    double d = (Double)aValue;
                    this.getRow(rowIndex).setAntrag(Euro.ofEuros(d));
                    break;
                }
                return;
            }
            case 2: {
                if (aValue instanceof Double) {
                    double d = (Double)aValue;
                    this.getRow(rowIndex).setErfolg(Euro.ofEuros(d));
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.getRow(rowIndex);
            }
            case 1: {
                return this.getRow(rowIndex).getAntrag();
            }
            case 2: {
                return this.getRow(rowIndex).getErfolg();
            }
        }
        return null;
    }

    public Forderung[] toArray() {
        if (this.values != null) {
            Forderung[] array = new Forderung[this.values.size()];
            array = this.values.toArray(array);
            return array;
        }
        return null;
    }

    @Override
    public List<Forderung> getAllValues() {
        return this.values;
    }

    public void setAllValues(List<Forderung> values) {
        this.values = values;
        this.fireTableDataChanged();
    }

    @Override
    public void clear() {
        if (this.values == null) {
            this.values = new ArrayList<Forderung>();
        } else {
            this.values.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public Forderung getRow(int rowIndex) throws IndexOutOfBoundsException {
        if (this.values == null) {
            return null;
        }
        return this.values.get(rowIndex);
    }

    @Override
    public void removeRow(int rowIndex) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.values == null || rowIndex < 0 || this.values.size() - 1 < rowIndex) {
            return;
        }
        this.values.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    @Override
    public void addRow(Forderung forderung) throws IllegalArgumentException {
        this.values.add(forderung);
        this.fireTableRowsInserted(this.values.size() - 1, this.values.size() - 1);
    }

    @Override
    public String getTooltipText(int columnIndex) {
        return COLUMN_TOOLTIPS[columnIndex];
    }

    @Override
    public void addAll(List<Forderung> c) throws NullPointerException, UnsupportedOperationException {
    }
}

