/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenVerzeichnis;
import javax.swing.AbstractListModel;

public class GebuehrenListModel
extends AbstractListModel<GebuehrenTatbestand> {
    private static final long serialVersionUID = 4142435767759392682L;
    private GebuehrenVerzeichnis values = new GebuehrenVerzeichnis();
    private GebuehrenAuflistung filtered = new GebuehrenAuflistung();
    private String term = "";

    public GebuehrenListModel() {
        this.refilter();
    }

    public void addAll(GebuehrenVerzeichnis verzeichnis) {
        this.values.putAll(verzeichnis);
        this.refilter();
    }

    @Override
    public int getSize() {
        return this.filtered.size();
    }

    @Override
    public GebuehrenTatbestand getElementAt(int index) {
        if (index >= 0 && index < this.filtered.size()) {
            return (GebuehrenTatbestand)this.filtered.get(index);
        }
        return null;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
        this.refilter();
    }

    private void refilter() {
        int vorher = 0;
        if (this.filtered != null || !this.filtered.isEmpty()) {
            vorher = this.filtered.size();
        }
        this.filtered = this.values.filter(this.getTerm());
        int nachher = this.filtered.size();
        if (nachher > vorher) {
            this.fireIntervalAdded(this, vorher, nachher - 1);
        } else if (vorher > nachher) {
            this.fireIntervalRemoved(this, nachher, vorher - 1);
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

