/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GerichtsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.interfaces.RowHandler;
import eu.gronos.kostenrechner.interfaces.RowList;
import eu.gronos.kostenrechner.interfaces.TooltipLieferant;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class GebuehrenTableModel
extends AbstractTableModel
implements RowHandler<GebuehrenTatbestand>,
RowList<GebuehrenTatbestand>,
TooltipLieferant {
    private static final int COLUMN_COUNT = 3;
    private static final long serialVersionUID = 2980582500842074125L;
    private static final int SPALTE_BEZEICHNUNG = 0;
    private static final int SPALTE_SATZ = 1;
    private static final int SPALTE_VERZEICHNIS = 2;
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Double.class, String.class};
    private GebuehrenAuflistung values = new GebuehrenAuflistung();
    private static final String[] COLUMN_NAMES = new String[]{"Geb\u00fchrentatbestand", "Satz", "Vorschrift/Gesetz"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Der Geb\u00fchrentatbestand aus dem Kostenverzeichnis bzw. Verg\u00fctungsverzeichnis", "Der Geb\u00fchrensatz bzw. die H\u00f6he der Auslagen", "Die Vorschrift aus dem Kostenverzeichnis bzw. Verg\u00fctungsverzeichnis"};

    public GebuehrenTableModel(GebuehrenAuflistung values) {
        this.values.addAll(values);
    }

    @Override
    public int getRowCount() {
        if (this.values != null) {
            return this.values.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getBezeichnungAt(rowIndex);
            }
            case 1: {
                return this.getSatzAt(rowIndex);
            }
            case 2: {
                return this.getVerzeichnisAt(rowIndex);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (1 == columnIndex) {
            GebuehrenTatbestand gt = (GebuehrenTatbestand)this.values.get(rowIndex);
            boolean cfr_ignored_0 = gt instanceof AuslagenTatbestand;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (1 == columnIndex) {
            GebuehrenTatbestand gt = (GebuehrenTatbestand)this.values.get(rowIndex);
            boolean cfr_ignored_0 = gt instanceof AuslagenTatbestand;
        }
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 3) {
            return COLUMN_NAMES[columnIndex];
        }
        return super.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 3) {
            return COLUMN_CLASSES[columnIndex];
        }
        return super.getColumnClass(columnIndex);
    }

    public GebuehrenTatbestand[] toArray() {
        if (this.values != null) {
            GebuehrenTatbestand[] array = new GebuehrenTatbestand[this.values.size()];
            array = this.values.toArray(array);
            return array;
        }
        return null;
    }

    public GebuehrenAuflistung getValues() {
        return this.values;
    }

    public GebuehrenAuflistung getAllValues() {
        return this.values;
    }

    @Override
    public void clear() {
        if (this.values == null) {
            this.values = new GebuehrenAuflistung();
        } else {
            this.values.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addAll(List<GebuehrenTatbestand> gebuehren) throws NullPointerException, UnsupportedOperationException {
        if (gebuehren == null) {
            throw new NullPointerException("Das array darf nicht null sein!");
        }
        this.values.addAll(gebuehren);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(GebuehrenTatbestand gt) throws IllegalArgumentException {
        if (gt != null) {
            this.values.add(gt);
            this.fireTableRowsInserted(this.values.size() - 1, this.values.size() - 1);
        }
    }

    public void addRowAt(int rowIndex, GebuehrenTatbestand gt) throws IllegalArgumentException {
        if (gt != null && rowIndex > -1 && rowIndex <= this.values.size()) {
            this.values.add(rowIndex, gt);
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    @Override
    public void removeRow(int rowIndex) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.values != null && rowIndex > -1 && rowIndex < this.getRowCount()) {
            this.values.remove(rowIndex);
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    @Override
    public GebuehrenTatbestand getRow(int rowIndex) throws IndexOutOfBoundsException {
        return (GebuehrenTatbestand)this.values.get(rowIndex);
    }

    @Override
    public String getTooltipText(int columnIndex) {
        return COLUMN_TOOLTIPS[columnIndex];
    }

    private String getVerzeichnisAt(int rowIndex) {
        if (this.values == null) {
            return null;
        }
        Class<? extends GebuehrenTabelle> gebuehrenKlasse = ((GebuehrenTatbestand)this.values.get(rowIndex)).getGebuehrenKlasse();
        String verzeichnis = "";
        if (GerichtsGebuehrenTabelle.class == gebuehrenKlasse) {
            verzeichnis = "GKG";
        } else if (AnwaltsGebuehrenTabelle.class == gebuehrenKlasse) {
            verzeichnis = "RVG";
        }
        return String.format("%s (%s)", ((GebuehrenTatbestand)this.values.get(rowIndex)).getVorschrift(), verzeichnis);
    }

    private Double getSatzAt(int rowIndex) {
        if (this.values != null) {
            GebuehrenTatbestand gt = (GebuehrenTatbestand)this.values.get(rowIndex);
            if (gt instanceof AuslagenTatbestand) {
                return ((AuslagenTatbestand)gt).getBetrag().doubleValue();
            }
            if (gt instanceof PauschalTatbestand) {
                return ((PauschalTatbestand)gt).getBetrag().doubleValue();
            }
            if (gt instanceof GebuehrenSatzTatbestand) {
                return ((GebuehrenSatzTatbestand)gt).getSatz();
            }
            if (gt instanceof MehrwertsteuerTatbestand) {
                return ((MehrwertsteuerTatbestand)gt).getSteuerSatz();
            }
        }
        return null;
    }

    private String getBezeichnungAt(int rowIndex) {
        if (this.values != null) {
            return ((GebuehrenTatbestand)this.values.get(rowIndex)).getBezeichnung();
        }
        return null;
    }
}

