/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.TooltipLieferant;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class StreitwertTableModel
extends AbstractTableModel
implements TooltipLieferant {
    private static final long serialVersionUID = -3648963976826657812L;
    private static final int COLUMN_COUNT = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Streitwert bis", "GKG 1,0", "RVG 1,0"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Streitwert bis zu", "H\u00f6he einer 1,0 Geb\u00fchr nach \u00a7 34 GKG", "H\u00f6he einer 1,0 Geb\u00fchr nach \u00a7 13 RVG"};
    private static final Class<?>[] COLUMN_CLASS = new Class[]{Long.class, Double.class, Double.class};
    private final ArrayList<Euro> values = GebuehrenGesetzesSammlung.getRvg().errechneStreitwertListe();

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASS[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.values.get(rowIndex);
            }
            case 1: {
                return GebuehrenGesetzesSammlung.getGkg().errechneGebuehr(this.values.get(rowIndex));
            }
            case 2: {
                return GebuehrenGesetzesSammlung.getRvg().errechneGebuehr(this.values.get(rowIndex));
            }
        }
        return null;
    }

    public int rowAtStreitwert(Euro streitwert) {
        if (this.values == null || this.values.size() < 1) {
            return -1;
        }
        if (this.values.contains(streitwert)) {
            return this.values.indexOf(streitwert);
        }
        for (Euro grenze : this.values) {
            if (grenze.compareTo(streitwert) < 0) continue;
            return this.values.indexOf(grenze);
        }
        return this.values.size() - 1;
    }

    @Override
    public String getTooltipText(int columnIndex) {
        return COLUMN_TOOLTIPS[columnIndex];
    }
}

